/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.renderpass;

import com.prupe.mcpatcher.MCLogger;
import com.prupe.mcpatcher.ctm.CTMUtils;
import com.prupe.mcpatcher.mal.block.BlockAPI;
import com.prupe.mcpatcher.mal.block.RenderPassAPI;
import com.prupe.mcpatcher.mal.resource.BlendMethod;
import com.prupe.mcpatcher.mal.resource.PropertiesFile;
import com.prupe.mcpatcher.mal.resource.TexturePackAPI;
import com.prupe.mcpatcher.mal.resource.TexturePackChangeHandler;
import com.prupe.mcpatcher.renderpass.RenderPassMap;
import java.util.Arrays;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.opengl.GL11;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class RenderPass {
    private static final MCLogger logger = MCLogger.getLogger(MCLogger.Category.BETTER_GLASS);
    private static final ResourceLocation RENDERPASS_PROPERTIES = TexturePackAPI.newMCPatcherResourceLocation("renderpass.properties");
    private static final Map<Block, Integer> baseRenderPass = new IdentityHashMap<Block, Integer>();
    private static final Map<Block, Integer> extraRenderPass = new IdentityHashMap<Block, Integer>();
    private static final Map<Block, Integer> renderPassBits = new IdentityHashMap<Block, Integer>();
    private static final Set<Block> customRenderPassBlocks = new HashSet<Block>();
    private static BlendMethod blendMethod;
    private static ResourceLocation blendBlankResource;
    private static boolean enableLightmap;
    private static boolean enableColormap;
    private static final boolean[] backfaceCulling;
    private static int currentRenderPass;
    private static int maxRenderPass;
    private static boolean canRenderInThisPass;
    private static boolean hasCustomRenderPasses;
    private static boolean ambientOcclusion;
    private static final int COLOR_POS_0 = 3;
    private static final int COLOR_POS_1 = 10;
    private static final int COLOR_POS_2 = 17;
    private static final int COLOR_POS_3 = 24;
    private static int saveColor0;
    private static int saveColor1;
    private static int saveColor2;
    private static int saveColor3;

    public static void start(int pass) {
        currentRenderPass = RenderPassMap.vanillaToMCPatcher(pass);
        CTMUtils.setBlankResource();
    }

    public static void finish() {
        currentRenderPass = -1;
        CTMUtils.setBlankResource();
    }

    public static boolean skipAllRenderPasses(boolean[] skipRenderPass) {
        return skipRenderPass[0] && skipRenderPass[1] && skipRenderPass[2] && skipRenderPass[3];
    }

    public static boolean checkRenderPasses(Block block, boolean moreRenderPasses) {
        int bits = renderPassBits.get(block) >>> currentRenderPass;
        canRenderInThisPass = (bits & 1) != 0;
        hasCustomRenderPasses = customRenderPassBlocks.contains(block);
        return moreRenderPasses || bits >>> 1 != 0;
    }

    public static boolean canRenderInThisPass(boolean canRender) {
        return hasCustomRenderPasses ? canRenderInThisPass : canRender;
    }

    public static boolean shouldSideBeRendered(Block block, IBlockAccess blockAccess, int x, int y, int z, int face) {
        if (block.func_149646_a(blockAccess, x, y, z, face)) {
            return true;
        }
        if (!extraRenderPass.containsKey(block)) {
            Block neighbor = blockAccess.func_147439_a(x, y, z);
            return extraRenderPass.containsKey(neighbor);
        }
        return false;
    }

    public static boolean setAmbientOcclusion(boolean ambientOcclusion) {
        RenderPass.ambientOcclusion = ambientOcclusion;
        return ambientOcclusion;
    }

    public static float getAOBaseMultiplier(float multiplier) {
        return RenderPassAPI.instance.useLightmapThisPass() ? multiplier : 1.0f;
    }

    public static boolean useBlockShading() {
        return RenderPassAPI.instance.useLightmapThisPass();
    }

    public static void unshadeBuffer(int[] b) {
        if (!RenderPass.useBlockShading()) {
            saveColor0 = b[3];
            saveColor1 = b[10];
            saveColor2 = b[17];
            saveColor3 = b[24];
            b[24] = -1;
            b[17] = -1;
            b[10] = -1;
            b[3] = -1;
        }
    }

    public static void reshadeBuffer(int[] b) {
        if (!RenderPass.useBlockShading()) {
            b[3] = saveColor0;
            b[10] = saveColor1;
            b[17] = saveColor2;
            b[24] = saveColor3;
        }
    }

    public static boolean preRenderPass(int pass) {
        currentRenderPass = pass;
        if (pass > maxRenderPass) {
            return false;
        }
        switch (pass) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                if (backfaceCulling[pass]) break;
                GL11.glDisable((int)2884);
                break;
            }
            case 5: {
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glPolygonOffset((float)-2.0f, (float)-2.0f);
                GL11.glEnable((int)32823);
                if (backfaceCulling[pass]) {
                    GL11.glEnable((int)2884);
                } else {
                    GL11.glDisable((int)2884);
                }
                if (ambientOcclusion) {
                    GL11.glShadeModel((int)7425);
                }
                blendMethod.applyBlending();
                break;
            }
        }
        return true;
    }

    public static int postRenderPass(int value) {
        switch (currentRenderPass) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                if (backfaceCulling[currentRenderPass]) break;
                GL11.glEnable((int)2884);
                break;
            }
            case 5: {
                GL11.glPolygonOffset((float)0.0f, (float)0.0f);
                GL11.glDisable((int)32823);
                if (!backfaceCulling[currentRenderPass]) {
                    GL11.glEnable((int)2884);
                }
                GL11.glDisable((int)3042);
                GL11.glShadeModel((int)7424);
                break;
            }
        }
        currentRenderPass = -1;
        return value;
    }

    public static void enableDisableLightmap(EntityRenderer renderer, double partialTick) {
        if (RenderPassAPI.instance.useLightmapThisPass()) {
            renderer.func_78463_b(partialTick);
        } else {
            renderer.func_78483_a(partialTick);
        }
    }

    static {
        backfaceCulling = new boolean[RenderPassAPI.NUM_RENDER_PASSES];
        currentRenderPass = -1;
        maxRenderPass = 1;
        RenderPassAPI.instance = new RenderPassAPI(){

            @Override
            public boolean skipDefaultRendering(Block block) {
                return currentRenderPass > 4;
            }

            @Override
            public boolean skipThisRenderPass(Block block, int pass) {
                if (currentRenderPass < 0) {
                    return pass > 4;
                }
                if (pass < 0) {
                    pass = RenderPassMap.getDefaultRenderPass(block);
                }
                return pass != currentRenderPass;
            }

            @Override
            public boolean useColorMultiplierThisPass(Block block) {
                return currentRenderPass != 5 || enableColormap;
            }

            @Override
            public boolean useLightmapThisPass() {
                return currentRenderPass != 5 || enableLightmap;
            }

            @Override
            public void clear() {
                canRenderInThisPass = false;
                maxRenderPass = 3;
                baseRenderPass.clear();
                extraRenderPass.clear();
                renderPassBits.clear();
                customRenderPassBlocks.clear();
                blendMethod = BlendMethod.ALPHA;
                blendBlankResource = blendMethod.getBlankResource();
                if (blendBlankResource == null) {
                    blendBlankResource = BlendMethod.ALPHA.getBlankResource();
                }
                enableLightmap = true;
                enableColormap = false;
                Arrays.fill(backfaceCulling, true);
                RenderPass.backfaceCulling[4] = false;
                for (Block block : BlockAPI.getAllBlocks()) {
                    baseRenderPass.put(block, RenderPassMap.getDefaultRenderPass(block));
                }
            }

            @Override
            public void refreshBlendingOptions() {
                PropertiesFile properties = PropertiesFile.get(logger, RENDERPASS_PROPERTIES);
                if (properties != null) {
                    this.remapProperties(properties);
                    String method = properties.getString("blend.overlay", "alpha").trim().toLowerCase();
                    blendMethod = BlendMethod.parse(method);
                    if (blendMethod == null) {
                        logger.error("%s: unknown blend method '%s'", RENDERPASS_PROPERTIES, method);
                        blendMethod = BlendMethod.ALPHA;
                    }
                    if ((blendBlankResource = blendMethod.getBlankResource()) == null) {
                        blendBlankResource = BlendMethod.ALPHA.getBlankResource();
                    }
                    enableLightmap = properties.getBoolean("enableLightmap.overlay", !blendMethod.isColorBased());
                    enableColormap = properties.getBoolean("enableColormap.overlay", false);
                    RenderPass.backfaceCulling[5] = properties.getBoolean("backfaceCulling.overlay", true);
                    boolean bl = properties.getBoolean("backfaceCulling.cutout", true);
                    RenderPass.backfaceCulling[RenderPassMap.getCutoutRenderPass()] = bl;
                    RenderPass.backfaceCulling[2] = bl;
                    RenderPass.backfaceCulling[1] = properties.getBoolean("backfaceCulling.cutout_mipped", backfaceCulling[2]);
                    RenderPass.backfaceCulling[3] = properties.getBoolean("backfaceCulling.translucent", true);
                }
            }

            private void remapProperties(PropertiesFile properties) {
                for (Map.Entry<String, String> entry : properties.entrySet()) {
                    String key = entry.getKey();
                    key = key.replaceFirst("\\.3$", ".overlay");
                    if (!(key = key.replaceFirst("\\.2$", ".backface")).equals(entry.getKey())) {
                        properties.warning("%s is deprecated in 1.8.  Use %s instead", entry.getKey(), key);
                    }
                    properties.setProperty(key, entry.getValue());
                }
            }

            @Override
            public void setRenderPassForBlock(Block block, int pass) {
                String name;
                if (block == null || pass < 0) {
                    return;
                }
                if (pass <= 4) {
                    baseRenderPass.put(block, pass);
                    name = "base";
                } else {
                    extraRenderPass.put(block, pass);
                    name = "extra";
                }
                logger.fine("%s %s render pass -> %s", BlockAPI.getBlockName(block), name, RenderPassAPI.instance.getRenderPassName(pass));
                customRenderPassBlocks.add(block);
                maxRenderPass = Math.max(maxRenderPass, pass);
            }

            @Override
            public ResourceLocation getBlankResource(int pass) {
                return pass == 5 ? blendBlankResource : super.getBlankResource(pass);
            }

            @Override
            public ResourceLocation getBlankResource() {
                return this.getBlankResource(currentRenderPass);
            }
        };
        TexturePackChangeHandler.register(new TexturePackChangeHandler("Better Glass", 4){

            @Override
            public void beforeChange() {
            }

            @Override
            public void afterChange() {
                for (Block block : BlockAPI.getAllBlocks()) {
                    int bits = 0;
                    Integer i = baseRenderPass.get(block);
                    if (i != null && i >= 0) {
                        bits |= 1 << i;
                    }
                    if ((i = extraRenderPass.get(block)) != null && i >= 0) {
                        bits |= 1 << i;
                    }
                    renderPassBits.put(block, bits);
                }
            }
        });
    }
}

