/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.mob;

import com.prupe.mcpatcher.MCLogger;
import com.prupe.mcpatcher.MCPatcherUtils;
import com.prupe.mcpatcher.mal.biome.BiomeAPI;
import com.prupe.mcpatcher.mal.resource.PropertiesFile;
import com.prupe.mcpatcher.mal.resource.TexturePackAPI;
import com.prupe.mcpatcher.mal.util.WeightedIndex;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.util.ResourceLocation;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class MobRuleList {
    private static final MCLogger logger = MCLogger.getLogger(MCLogger.Category.RANDOM_MOBS);
    public static final String ALTERNATIVES_REGEX = "_(eyes|overlay|tame|angry|collar|fur|invulnerable|shooting)\\.properties$";
    private static final Map<ResourceLocation, MobRuleList> allRules = new HashMap<ResourceLocation, MobRuleList>();
    private final ResourceLocation baseSkin;
    private final List<ResourceLocation> allSkins;
    private final int skinCount;
    private final List<MobRuleEntry> entries;

    private MobRuleList(ResourceLocation baseSkin) {
        ResourceLocation skin;
        this.baseSkin = baseSkin;
        String newPath = baseSkin.func_110623_a().replaceFirst("^textures/entity/", "mcpatcher/mob/");
        ResourceLocation newSkin = new ResourceLocation(baseSkin.func_110624_b(), newPath);
        this.allSkins = new ArrayList<ResourceLocation>();
        this.allSkins.add(baseSkin);
        int i = 2;
        while (TexturePackAPI.hasResource(skin = TexturePackAPI.transformResourceLocation(newSkin, ".png", i + ".png"))) {
            this.allSkins.add(skin);
            ++i;
        }
        this.skinCount = this.allSkins.size();
        if (this.skinCount <= 1) {
            this.entries = null;
            return;
        }
        logger.fine("found %d variations for %s", this.skinCount, baseSkin);
        ResourceLocation filename = TexturePackAPI.transformResourceLocation(newSkin, ".png", ".properties");
        ResourceLocation altFilename = new ResourceLocation(newSkin.func_110624_b(), filename.func_110623_a().replaceFirst(ALTERNATIVES_REGEX, ".properties"));
        PropertiesFile properties = PropertiesFile.get(logger, filename);
        if (properties == null && !filename.equals((Object)altFilename) && (properties = PropertiesFile.get(logger, altFilename)) != null) {
            logger.fine("using %s for %s", altFilename, baseSkin);
        }
        ArrayList<MobRuleEntry> tmpEntries = new ArrayList<MobRuleEntry>();
        if (properties != null) {
            int i2 = 0;
            while (true) {
                MobRuleEntry entry;
                if ((entry = MobRuleEntry.load(properties, i2, this.skinCount)) == null) {
                    if (i2 > 0) {
                        break;
                    }
                } else {
                    logger.fine("  %s", entry.toString());
                    tmpEntries.add(entry);
                }
                ++i2;
            }
        }
        this.entries = tmpEntries.isEmpty() ? null : tmpEntries;
    }

    ResourceLocation getSkin(long key, int i, int j, int k, Integer biome) {
        if (this.entries == null) {
            int index = (int)(key % (long)this.skinCount);
            if (index < 0) {
                index += this.skinCount;
            }
            return this.allSkins.get(index);
        }
        if (j < 0) {
            j = 0;
        }
        for (MobRuleEntry entry : this.entries) {
            if (!entry.match(i, j, k, biome)) continue;
            int index = entry.weightedIndex.choose(key);
            return this.allSkins.get(entry.skins[index]);
        }
        return this.baseSkin;
    }

    static MobRuleList get(ResourceLocation texture) {
        MobRuleList list = allRules.get(texture);
        if (list == null) {
            list = new MobRuleList(texture);
            allRules.put(texture, list);
        }
        return list;
    }

    static void clear() {
        allRules.clear();
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class MobRuleEntry {
        final int[] skins;
        final WeightedIndex weightedIndex;
        private final BitSet biomes;
        private final BitSet height;

        static MobRuleEntry load(PropertiesFile properties, int index, int limit) {
            BitSet biomes;
            WeightedIndex chooser;
            int[] skins;
            String skinList = properties.getString("skins." + index, "").toLowerCase();
            if (skinList.equals("*") || skinList.equals("all") || skinList.equals("any")) {
                skins = new int[limit];
                for (i = 0; i < skins.length; ++i) {
                    skins[i] = i;
                }
            } else {
                skins = MCPatcherUtils.parseIntegerList(skinList, 1, limit);
                if (skins.length <= 0) {
                    return null;
                }
                i = 0;
                while (i < skins.length) {
                    int n = i++;
                    skins[n] = skins[n] - 1;
                }
            }
            if ((chooser = WeightedIndex.create(skins.length, properties.getString("weights." + index, ""))) == null) {
                return null;
            }
            String biomeList = properties.getString("biomes." + index, "");
            if (biomeList.isEmpty()) {
                biomes = null;
            } else {
                biomes = new BitSet();
                BiomeAPI.parseBiomeList(biomeList, biomes);
            }
            BitSet height = BiomeAPI.getHeightListProperty(properties, "." + index);
            return new MobRuleEntry(skins, chooser, biomes, height);
        }

        MobRuleEntry(int[] skins, WeightedIndex weightedIndex, BitSet biomes, BitSet height) {
            this.skins = skins;
            this.weightedIndex = weightedIndex;
            this.biomes = biomes;
            this.height = height;
        }

        boolean match(int x, int y, int z, Integer biome) {
            if (!(this.biomes == null || biome != null && this.biomes.get(biome))) {
                return false;
            }
            return this.height == null || this.height.get(y);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("skins:");
            for (int i : this.skins) {
                sb.append(' ').append(i + 1);
            }
            if (this.biomes != null) {
                sb.append(", biomes:");
                int i = this.biomes.nextSetBit(0);
                while (i >= 0) {
                    sb.append(' ').append(i);
                    i = this.biomes.nextSetBit(i + 1);
                }
            }
            if (this.height != null) {
                sb.append(", height:");
                int i = this.height.nextSetBit(0);
                while (i >= 0) {
                    sb.append(' ').append(i);
                    i = this.height.nextSetBit(i + 1);
                }
            }
            sb.append(", weights: ").append(this.weightedIndex.toString());
            return sb.toString();
        }
    }
}

