/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.mal.resource;

import com.prupe.mcpatcher.mal.resource.GLAPI;
import com.prupe.mcpatcher.mal.resource.TexturePackAPI;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class BlendMethod {
    private static final Set<ResourceLocation> blankResources = new HashSet<ResourceLocation>();
    public static final BlendMethod ALPHA = new BlendMethod("alpha", 770, 771, true, false, true, 0);
    public static final BlendMethod ADD = new BlendMethod("add", 770, 1, true, false, true, 0);
    public static final BlendMethod SUBTRACT = new BlendMethod("subtract", 775, 0, true, true, false, 0);
    public static final BlendMethod MULTIPLY = new BlendMethod("multiply", 774, 771, true, true, true, -1);
    public static final BlendMethod DODGE = new BlendMethod("dodge", 1, 1, true, true, false, 0);
    public static final BlendMethod BURN = new BlendMethod("burn", 0, 769, true, true, false, null);
    public static final BlendMethod SCREEN = new BlendMethod("screen", 1, 769, true, true, false, -1);
    public static final BlendMethod OVERLAY = new BlendMethod("overlay", 774, 768, true, true, false, -2139062144);
    public static final BlendMethod REPLACE = new BlendMethod("replace", 0, 0, false, false, true, null);
    private final int srcBlend;
    private final int dstBlend;
    private final String name;
    private final boolean blend;
    private final boolean fadeRGB;
    private final boolean fadeAlpha;
    private final ResourceLocation blankResource;

    public static BlendMethod parse(String text) {
        switch (text = text.toLowerCase().trim()) {
            case "alpha": {
                return ALPHA;
            }
            case "add": {
                return ADD;
            }
            case "subtract": {
                return SUBTRACT;
            }
            case "multiply": {
                return MULTIPLY;
            }
            case "dodge": {
                return DODGE;
            }
            case "burn": {
                return BURN;
            }
            case "screen": {
                return SCREEN;
            }
            case "overlay": 
            case "color": {
                return OVERLAY;
            }
            case "replace": 
            case "none": {
                return REPLACE;
            }
        }
        String[] tokens = text.split("\\s+");
        if (tokens.length >= 2) {
            try {
                int srcBlend = Integer.parseInt(tokens[0]);
                int dstBlend = Integer.parseInt(tokens[1]);
                return new BlendMethod("custom(" + srcBlend + "," + dstBlend + ")", srcBlend, dstBlend, true, true, false, 0);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public static Set<ResourceLocation> getAllBlankResources() {
        return blankResources;
    }

    private BlendMethod(String name, int srcBlend, int dstBlend, boolean blend, boolean fadeRGB, boolean fadeAlpha, Integer neutralRGB) {
        this.name = name;
        this.srcBlend = srcBlend;
        this.dstBlend = dstBlend;
        this.blend = blend;
        this.fadeRGB = fadeRGB;
        this.fadeAlpha = fadeAlpha;
        if (neutralRGB == null) {
            this.blankResource = null;
        } else {
            String filename = String.format("blank_%08x.png", neutralRGB);
            this.blankResource = TexturePackAPI.newMCPatcherResourceLocation(filename);
        }
        if (this.blankResource != null) {
            blankResources.add(this.blankResource);
        }
    }

    public String toString() {
        return this.name;
    }

    public void applyFade(float fade) {
        if (this.fadeRGB && this.fadeAlpha) {
            GL11.glColor4f((float)fade, (float)fade, (float)fade, (float)fade);
        } else if (this.fadeRGB) {
            GL11.glColor4f((float)fade, (float)fade, (float)fade, (float)1.0f);
        } else if (this.fadeAlpha) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)fade);
        }
    }

    public void applyAlphaTest() {
        if (this.blend) {
            GL11.glDisable((int)3008);
        } else {
            GL11.glEnable((int)3008);
            GL11.glAlphaFunc((int)516, (float)0.01f);
        }
    }

    public void applyDepthFunc() {
        if (this.blend) {
            GL11.glDepthFunc((int)514);
        } else {
            GL11.glDepthFunc((int)515);
            GL11.glDepthMask((boolean)true);
        }
    }

    public void applyBlending() {
        if (this.blend) {
            GL11.glEnable((int)3042);
            GLAPI.glBlendFuncSeparate(this.srcBlend, this.dstBlend, 1, 771);
        } else {
            GL11.glDisable((int)3042);
        }
    }

    public boolean isColorBased() {
        return this.fadeRGB;
    }

    public boolean canFade() {
        return this.blend && (this.fadeAlpha || this.fadeRGB);
    }

    public ResourceLocation getBlankResource() {
        return this.blankResource;
    }
}

