/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.cit;

import com.prupe.mcpatcher.MCLogger;
import com.prupe.mcpatcher.cit.ItemOverride;
import com.prupe.mcpatcher.mal.resource.PropertiesFile;
import com.prupe.mcpatcher.mal.resource.TexturePackAPI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionHelper;
import net.minecraft.util.ResourceLocation;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class PotionReplacer {
    private static final MCLogger logger = MCLogger.getLogger(MCLogger.Category.CUSTOM_ITEM_TEXTURES, "CIT");
    private static final String ITEM_ID_POTION = "minecraft:potion";
    private static final String ITEM_ID_GLASS_BOTTLE = "minecraft:glass_bottle";
    private static final String LAYER_POTION_CONTENTS = "potion_overlay";
    private static final String LAYER_POTION_DRINKABLE = "potion_bottle_drinkable";
    private static final String LAYER_POTION_SPLASH = "potion_bottle_splash";
    private static final String LAYER_EMPTY_BOTTLE = "potion_bottle_empty";
    private static final int SPLASH_BIT = 16384;
    private static final int EFFECT_BITS = 16399;
    private static final int MUNDANE_BITS = 16447;
    private static final int WATER_BITS = 65535;
    private static final int[] POTION_EFFECTS = new int[]{-1, 2, 10, -1, -1, 9, 5, 12, -1, -1, 1, -1, 3, -1, 14, -1, 6, -1, 8, 4, -1};
    private static final Map<String, Integer> mundanePotionMap = new HashMap<String, Integer>();
    private static int weight = -2;
    final List<ItemOverride> overrides = new ArrayList<ItemOverride>();

    PotionReplacer() {
        ResourceLocation path = PotionReplacer.getPotionPath("water", false);
        if (TexturePackAPI.hasResource(path)) {
            ++weight;
            this.registerVanillaPotion(path, 0, 65535, false);
            --weight;
        }
        if (TexturePackAPI.hasResource(path = PotionReplacer.getPotionPath("empty", false))) {
            this.registerEmptyBottle(path);
        }
        this.registerPotionsByEffect(false);
        this.registerPotionsByEffect(true);
        this.registerMundanePotions(false);
        this.registerMundanePotions(true);
        this.registerOtherPotions(false);
        this.registerOtherPotions(true);
    }

    private static ResourceLocation getPotionPath(String name, boolean splash) {
        String path = "cit/potion/" + (splash ? "splash/" : "normal/") + name + ".png";
        return TexturePackAPI.newMCPatcherResourceLocation(path);
    }

    private static Properties newProperties(ResourceLocation path, String itemID, String layer) {
        Properties properties = new Properties();
        properties.setProperty("type", "item");
        properties.setProperty("items", itemID);
        properties.setProperty("texture." + layer, path.toString());
        properties.setProperty("texture.potion_overlay", "blank");
        properties.setProperty("weight", String.valueOf(weight));
        return properties;
    }

    private static Properties newProperties(ResourceLocation path, String itemID, boolean splash) {
        String layer = splash ? LAYER_POTION_SPLASH : LAYER_POTION_DRINKABLE;
        return PotionReplacer.newProperties(path, itemID, layer);
    }

    private void registerPotionsByEffect(boolean splash) {
        for (int effect = 0; effect < Potion.field_76425_a.length; ++effect) {
            ResourceLocation path;
            if (Potion.field_76425_a[effect] == null || !TexturePackAPI.hasResource(path = PotionReplacer.getPotionPath(Potion.field_76425_a[effect].func_76393_a().replaceFirst("^potion\\.", ""), splash))) continue;
            if (effect < POTION_EFFECTS.length && POTION_EFFECTS[effect] >= 0) {
                int damage = POTION_EFFECTS[effect];
                if (splash) {
                    damage |= 0x4000;
                }
                this.registerVanillaPotion(path, damage, 16399, splash);
            }
            if (splash) continue;
            this.registerCustomPotion(path, effect, splash);
        }
    }

    private void registerMundanePotions(boolean splash) {
        for (Map.Entry<String, Integer> entry : mundanePotionMap.entrySet()) {
            int damage = entry.getValue();
            if (splash) {
                damage |= 0x4000;
            }
            this.registerMundanePotion(entry.getKey(), damage, splash);
        }
    }

    private void registerMundanePotion(String name, int damage, boolean splash) {
        ResourceLocation path = PotionReplacer.getPotionPath(name, splash);
        if (TexturePackAPI.hasResource(path)) {
            this.registerVanillaPotion(path, damage, 16447, splash);
        }
    }

    private void registerOtherPotions(boolean splash) {
        ResourceLocation path = PotionReplacer.getPotionPath("other", splash);
        if (TexturePackAPI.hasResource(path)) {
            Properties properties = PotionReplacer.newProperties(path, ITEM_ID_POTION, splash);
            StringBuilder sb = new StringBuilder();
            for (int i : mundanePotionMap.values()) {
                if (splash) {
                    i |= 0x4000;
                }
                sb.append(' ').append(i);
            }
            properties.setProperty("damage", sb.toString().trim());
            properties.setProperty("damageMask", String.valueOf(16447));
            this.addOverride(path, properties);
        }
    }

    private void registerVanillaPotion(ResourceLocation path, int damage, int mask, boolean splash) {
        Properties properties = PotionReplacer.newProperties(path, ITEM_ID_POTION, splash);
        properties.setProperty("damage", String.valueOf(damage));
        properties.setProperty("damageMask", String.valueOf(mask));
        this.addOverride(path, properties);
    }

    private void registerCustomPotion(ResourceLocation path, int effect, boolean splash) {
        Properties properties = PotionReplacer.newProperties(path, ITEM_ID_POTION, splash);
        properties.setProperty("nbt.CustomPotionEffects.0.Id", String.valueOf(effect));
        this.addOverride(path, properties);
    }

    private void registerEmptyBottle(ResourceLocation path) {
        Properties properties = PotionReplacer.newProperties(path, ITEM_ID_GLASS_BOTTLE, LAYER_EMPTY_BOTTLE);
        this.addOverride(path, properties);
    }

    private void addOverride(ResourceLocation path, Properties properties) {
        ResourceLocation propertiesName = TexturePackAPI.transformResourceLocation(path, ".png", ".properties");
        ItemOverride override = new ItemOverride(new PropertiesFile(logger, propertiesName, properties));
        if (override.properties.valid()) {
            this.overrides.add(override);
        }
    }

    static {
        try {
            for (int i : new int[]{0, 7, 11, 13, 15, 16, 23, 27, 29, 31, 32, 39, 43, 45, 47, 48, 55, 59, 61, 63}) {
                String name = PotionHelper.func_77905_c((int)i).replaceFirst("^potion\\.prefix\\.", "");
                mundanePotionMap.put(name, i);
                logger.fine("%s potion -> damage value %d", name, i);
            }
            for (int i = 0; i < Potion.field_76425_a.length; ++i) {
                Potion potion = Potion.field_76425_a[i];
                if (potion == null) continue;
                logger.fine("%s potion -> effect %d", potion.func_76393_a().replaceFirst("^potion\\.", ""), i);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

