/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.cit;

import com.prupe.mcpatcher.cit.CITUtils;
import com.prupe.mcpatcher.cit.OverrideBase;
import com.prupe.mcpatcher.mal.resource.PropertiesFile;
import com.prupe.mcpatcher.mal.resource.TexturePackAPI;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.ResourceLocation;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
final class ArmorOverride
extends OverrideBase {
    private final Map<ResourceLocation, ResourceLocation> armorMap;

    ArmorOverride(PropertiesFile properties) {
        super(properties);
        if (this.items == null) {
            properties.error("no matching items specified", new Object[0]);
        }
        if (this.textureName == null && this.alternateTextures == null) {
            properties.error("no replacement textures specified", new Object[0]);
        }
        if (this.alternateTextures == null) {
            this.armorMap = null;
        } else {
            this.armorMap = new HashMap<ResourceLocation, ResourceLocation>();
            for (Map.Entry entry : this.alternateTextures.entrySet()) {
                String key = (String)entry.getKey();
                ResourceLocation value = (ResourceLocation)entry.getValue();
                this.armorMap.put(TexturePackAPI.parseResourceLocation(CITUtils.FIXED_ARMOR_RESOURCE, key), value);
            }
        }
    }

    @Override
    String getType() {
        return "armor";
    }

    ResourceLocation getReplacementTexture(ResourceLocation origResource) {
        ResourceLocation newResource;
        if (this.armorMap != null && (newResource = this.armorMap.get(origResource)) != null) {
            return newResource;
        }
        return this.textureName;
    }

    @Override
    String preprocessAltTextureKey(String name) {
        if (!((String)name).endsWith(".png")) {
            name = (String)name + ".png";
        }
        if (!((String)name).contains("/")) {
            name = "./" + (String)name;
        }
        return TexturePackAPI.parseResourceLocation(CITUtils.FIXED_ARMOR_RESOURCE, (String)name).toString();
    }
}

