/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.cc;

import com.prupe.mcpatcher.MCLogger;
import com.prupe.mcpatcher.cc.ColorizeBlock;
import com.prupe.mcpatcher.cc.ColorizeEntity;
import com.prupe.mcpatcher.cc.ColorizeItem;
import com.prupe.mcpatcher.cc.ColorizeWorld;
import com.prupe.mcpatcher.cc.Lightmap;
import com.prupe.mcpatcher.mal.biome.ColorMap;
import com.prupe.mcpatcher.mal.biome.ColorUtils;
import com.prupe.mcpatcher.mal.resource.PropertiesFile;
import com.prupe.mcpatcher.mal.resource.TexturePackAPI;
import com.prupe.mcpatcher.mal.resource.TexturePackChangeHandler;
import jss.notfine.config.MCPatcherForgeConfig;
import net.minecraft.potion.Potion;
import net.minecraft.util.ResourceLocation;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class Colorizer {
    private static final MCLogger logger = MCLogger.getLogger(MCLogger.Category.CUSTOM_COLORS);
    static final ResourceLocation COLOR_PROPERTIES = TexturePackAPI.newMCPatcherResourceLocation("color.properties");
    private static PropertiesFile properties;
    static final boolean usePotionColors;
    static final boolean useParticleColors;
    static final boolean useFogColors;
    static final boolean useCloudType;
    static final boolean useMapColors;
    static final boolean useDyeColors;
    static final boolean useTextColors;
    static final boolean useXPOrbColors;
    static final boolean useEggColors;
    public static final float[] setColor;

    public static void setColorF(int color) {
        ColorUtils.intToFloat3(color, setColor);
    }

    static void setColorF(float[] color) {
        Colorizer.setColor[0] = color[0];
        Colorizer.setColor[1] = color[1];
        Colorizer.setColor[2] = color[2];
    }

    public static void init() {
    }

    private static void reset() {
        properties = new PropertiesFile(logger, COLOR_PROPERTIES);
        ColorMap.reset();
        ColorizeBlock.reset();
        Lightmap.reset();
        ColorizeItem.reset();
        ColorizeWorld.reset();
        ColorizeEntity.reset();
    }

    private static void reloadColorProperties() {
        properties = PropertiesFile.getNonNull(logger, COLOR_PROPERTIES);
        logger.finer("reloading %s", properties);
    }

    static String getStringKey(String[] keys, int index) {
        if (keys != null && index >= 0 && index < keys.length && keys[index] != null) {
            return keys[index];
        }
        return "" + index;
    }

    static void loadIntColor(String key, Potion potion) {
        potion.field_76414_N = Colorizer.loadIntColor(key, potion.func_76401_j());
    }

    static boolean loadIntColor(String key, int[] color, int index) {
        logger.config("%s=%06x", key, color[index]);
        String value = properties.getString(key, "");
        if (!value.isEmpty()) {
            try {
                color[index] = Integer.parseInt(value, 16);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    static int loadIntColor(String key, int color) {
        logger.config("%s=%06x", key, color);
        return properties.getHex(key, color);
    }

    static void loadFloatColor(String key, float[] color) {
        int intColor = ColorUtils.float3ToInt(color);
        ColorUtils.intToFloat3(Colorizer.loadIntColor(key, intColor), color);
    }

    static Integer loadIntegerColor(String key) {
        int[] tmp = new int[1];
        if (Colorizer.loadIntColor(key, tmp, 0)) {
            return tmp[0];
        }
        return null;
    }

    static float[] loadFloatColor(String key) {
        Integer color = Colorizer.loadIntegerColor(key);
        if (color == null) {
            return null;
        }
        float[] rgb = new float[3];
        ColorUtils.intToFloat3(color, rgb);
        return rgb;
    }

    static {
        usePotionColors = MCPatcherForgeConfig.CustomColors.potion;
        useParticleColors = MCPatcherForgeConfig.CustomColors.particle;
        useFogColors = MCPatcherForgeConfig.CustomColors.fog;
        useCloudType = MCPatcherForgeConfig.CustomColors.clouds;
        useMapColors = MCPatcherForgeConfig.CustomColors.map;
        useDyeColors = MCPatcherForgeConfig.CustomColors.dye;
        useTextColors = MCPatcherForgeConfig.CustomColors.text;
        useXPOrbColors = MCPatcherForgeConfig.CustomColors.xporb;
        useEggColors = MCPatcherForgeConfig.CustomColors.egg;
        setColor = new float[3];
        try {
            Colorizer.reset();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        TexturePackChangeHandler.register(new TexturePackChangeHandler("Custom Colors", 2){

            @Override
            public void beforeChange() {
                Colorizer.reset();
            }

            @Override
            public void afterChange() {
                Colorizer.reloadColorProperties();
                ColorMap.reloadColorMapSettings(properties);
                if (useParticleColors) {
                    ColorizeEntity.reloadParticleColors(properties);
                }
                ColorizeBlock.reloadAll(properties);
                if (useFogColors) {
                    ColorizeWorld.reloadFogColors(properties);
                }
                if (usePotionColors) {
                    ColorizeItem.reloadPotionColors(properties);
                }
                if (useCloudType) {
                    ColorizeWorld.reloadCloudType(properties);
                }
                if (useMapColors) {
                    ColorizeItem.reloadMapColors(properties);
                }
                if (useDyeColors) {
                    ColorizeEntity.reloadDyeColors(properties);
                }
                if (useTextColors) {
                    ColorizeWorld.reloadTextColors(properties);
                }
                if (useXPOrbColors) {
                    ColorizeEntity.reloadXPOrbColors(properties);
                }
            }
        });
    }
}

