/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.lwjgl.lwjgl3;

import com.mitchej123.lwjgl.DebugMessageHandler;
import com.mitchej123.lwjgl.GLExtension;
import com.mitchej123.lwjgl.LWJGLService;
import com.mitchej123.lwjgl.MemoryStack;
import com.mitchej123.lwjgl.lwjgl3.LWJGL3DebugSupport;
import com.mitchej123.lwjgl.lwjgl3.LWJGL3MemoryStack;
import java.io.PrintStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengl.ARBTimerQuery;
import org.lwjgl.opengl.ARBVertexArrayObject;
import org.lwjgl.opengl.EXTGPUShader4;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL11C;
import org.lwjgl.opengl.GL13C;
import org.lwjgl.opengl.GL14C;
import org.lwjgl.opengl.GL15C;
import org.lwjgl.opengl.GL20C;
import org.lwjgl.opengl.GL30C;
import org.lwjgl.opengl.GL31C;
import org.lwjgl.opengl.GL32C;
import org.lwjgl.opengl.GL33C;
import org.lwjgl.opengl.GL43C;
import org.lwjgl.opengl.GL44C;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.opengl.KHRDebug;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class LWJGL3Service
implements LWJGLService {
    private static final Logger LOGGER = LogManager.getLogger((String)"Celeritas/LWJGL3Service");
    private final LWJGL3DebugSupport debugSupport = new LWJGL3DebugSupport();
    private final VAOMode vaoMode;
    private final TimerQueryMode timerQueryMode;
    private final DebugMode debugMode;
    private final VertexAttribIMode vertexAttribIMode;
    private static final long glGenVertexArraysAPPLE = GL.getFunctionProvider().getFunctionAddress((CharSequence)"glGenVertexArraysAPPLE");
    private static final long glDeleteVertexArraysAPPLE = GL.getFunctionProvider().getFunctionAddress((CharSequence)"glDeleteVertexArraysAPPLE");
    private static final long glBindVertexArrayAPPLE = GL.getFunctionProvider().getFunctionAddress((CharSequence)"glBindVertexArrayAPPLE");

    @Override
    public int getPriority() {
        return 100;
    }

    @Override
    public boolean isOpenGLVersionSupported(int major, int minor) {
        GLCapabilities caps = GL.getCapabilities();
        return switch (major * 10 + minor) {
            case 11 -> caps.OpenGL11;
            case 12 -> caps.OpenGL12;
            case 13 -> caps.OpenGL13;
            case 14 -> caps.OpenGL14;
            case 15 -> caps.OpenGL15;
            case 20 -> caps.OpenGL20;
            case 21 -> caps.OpenGL21;
            case 30 -> caps.OpenGL30;
            case 31 -> caps.OpenGL31;
            case 32 -> caps.OpenGL32;
            case 33 -> caps.OpenGL33;
            case 40 -> caps.OpenGL40;
            case 41 -> caps.OpenGL41;
            case 42 -> caps.OpenGL42;
            case 43 -> caps.OpenGL43;
            case 44 -> caps.OpenGL44;
            case 45 -> caps.OpenGL45;
            case 46 -> caps.OpenGL46;
            default -> false;
        };
    }

    @Override
    public boolean isExtensionSupported(GLExtension extension) {
        GLCapabilities caps = GL.getCapabilities();
        return switch (extension) {
            default -> throw new IncompatibleClassChangeError();
            case GLExtension.ARB_buffer_storage -> caps.GL_ARB_buffer_storage;
            case GLExtension.ARB_multi_draw_indirect -> caps.GL_ARB_multi_draw_indirect;
            case GLExtension.ARB_draw_elements_base_vertex -> caps.GL_ARB_draw_elements_base_vertex;
            case GLExtension.ARB_direct_state_access -> caps.GL_ARB_direct_state_access;
            case GLExtension.ARB_shader_storage_buffer_object -> caps.GL_ARB_shader_storage_buffer_object;
            case GLExtension.ARB_sync -> caps.GL_ARB_sync;
            case GLExtension.ARB_timer_query -> caps.GL_ARB_timer_query;
            case GLExtension.ARB_debug_output -> caps.GL_ARB_debug_output;
            case GLExtension.KHR_debug -> caps.GL_KHR_debug;
            case GLExtension.AMD_debug_output -> caps.GL_AMD_debug_output;
            case GLExtension.ARB_uniform_buffer_object -> caps.GL_ARB_uniform_buffer_object;
            case GLExtension.ARB_vertex_array_object -> caps.GL_ARB_vertex_array_object;
            case GLExtension.ARB_map_buffer_range -> caps.GL_ARB_map_buffer_range;
            case GLExtension.ARB_copy_buffer -> caps.GL_ARB_copy_buffer;
            case GLExtension.ARB_texture_storage -> caps.GL_ARB_texture_storage;
            case GLExtension.ARB_base_instance -> caps.GL_ARB_base_instance;
            case GLExtension.ARB_compatibility -> caps.GL_ARB_compatibility;
        };
    }

    @Override
    public int getPointerSize() {
        return Pointer.POINTER_SIZE;
    }

    @Override
    public int glGenBuffers() {
        return GL15C.glGenBuffers();
    }

    @Override
    public void glDeleteBuffers(int buffer) {
        GL15C.glDeleteBuffers((int)buffer);
    }

    @Override
    public void glBindBuffer(int target, int buffer) {
        GL15C.glBindBuffer((int)target, (int)buffer);
    }

    @Override
    public void glBufferData(int target, long size, int usage) {
        GL15C.glBufferData((int)target, (long)size, (int)usage);
    }

    @Override
    public void glBufferData(int target, ByteBuffer data, int usage) {
        GL15C.glBufferData((int)target, (ByteBuffer)data, (int)usage);
    }

    @Override
    public void glBufferData(int target, long size, long data, int usage) {
        GL15C.nglBufferData((int)target, (long)size, (long)data, (int)usage);
    }

    @Override
    public void glBufferStorage(int target, long size, int flags) {
        GL44C.glBufferStorage((int)target, (long)size, (int)flags);
    }

    @Override
    public ByteBuffer glMapBufferRange(int target, long offset, long length, int flags) {
        return GL30C.glMapBufferRange((int)target, (long)offset, (long)length, (int)flags);
    }

    @Override
    public long nglMapBuffer(int target, int access) {
        return GL15C.nglMapBuffer((int)target, (int)access);
    }

    @Override
    public ByteBuffer glMapBuffer(int target, int access) {
        return GL15C.glMapBuffer((int)target, (int)access, null);
    }

    @Override
    public void glUnmapBuffer(int target) {
        GL15C.glUnmapBuffer((int)target);
    }

    @Override
    public void glFlushMappedBufferRange(int target, long offset, long length) {
        GL30C.glFlushMappedBufferRange((int)target, (long)offset, (long)length);
    }

    @Override
    public void glCopyBufferSubData(int readTarget, int writeTarget, long readOffset, long writeOffset, long size) {
        GL31C.glCopyBufferSubData((int)readTarget, (int)writeTarget, (long)readOffset, (long)writeOffset, (long)size);
    }

    @Override
    public void glBindBufferBase(int target, int index, int buffer) {
        GL30C.glBindBufferBase((int)target, (int)index, (int)buffer);
    }

    public LWJGL3Service() {
        GLCapabilities caps = GL.getCapabilities();
        this.vaoMode = caps.OpenGL30 ? VAOMode.CORE : (caps.GL_ARB_vertex_array_object ? VAOMode.ARB : (glBindVertexArrayAPPLE != 0L ? VAOMode.APPLE : VAOMode.NONE));
        if (caps.OpenGL33) {
            this.timerQueryMode = TimerQueryMode.CORE;
        } else if (caps.GL_ARB_timer_query) {
            this.timerQueryMode = TimerQueryMode.ARB;
        } else {
            this.timerQueryMode = TimerQueryMode.NONE;
            LOGGER.warn("ARB_timer_query extension not available - GPU profiling will be disabled");
        }
        this.debugMode = caps.GL_KHR_debug || caps.OpenGL43 ? DebugMode.KHR : DebugMode.NONE;
        this.vertexAttribIMode = caps.OpenGL30 ? VertexAttribIMode.CORE : (caps.GL_EXT_gpu_shader4 ? VertexAttribIMode.EXT : VertexAttribIMode.NONE);
    }

    @Override
    public int glGenVertexArrays() {
        int n;
        switch (this.vaoMode.ordinal()) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case 0: {
                int n2;
                n = n2 = GL30C.glGenVertexArrays();
                break;
            }
            case 1: {
                int n3;
                n = n3 = ARBVertexArrayObject.glGenVertexArrays();
                break;
            }
            case 2: {
                try (org.lwjgl.system.MemoryStack stack = org.lwjgl.system.MemoryStack.stackPush();){
                    IntBuffer buf = stack.callocInt(1);
                    JNI.callPV((int)1, (long)MemoryUtil.memAddress((IntBuffer)buf), (long)glGenVertexArraysAPPLE);
                    int n4 = buf.get(0);
                    n = n4;
                    break;
                }
            }
            case 3: {
                throw new UnsupportedOperationException("VAO not supported");
            }
        }
        return n;
    }

    @Override
    public void glDeleteVertexArrays(int array) {
        switch (this.vaoMode.ordinal()) {
            case 0: {
                GL30C.glDeleteVertexArrays((int)array);
                break;
            }
            case 1: {
                ARBVertexArrayObject.glDeleteVertexArrays((int)array);
                break;
            }
            case 2: {
                try (org.lwjgl.system.MemoryStack stack = org.lwjgl.system.MemoryStack.stackPush();){
                    IntBuffer buf = stack.ints(array);
                    JNI.callPV((int)1, (long)MemoryUtil.memAddress((IntBuffer)buf), (long)glDeleteVertexArraysAPPLE);
                    break;
                }
            }
            case 3: {
                throw new UnsupportedOperationException("VAO not supported");
            }
        }
    }

    @Override
    public void glBindVertexArray(int array) {
        switch (this.vaoMode.ordinal()) {
            case 0: {
                GL30C.glBindVertexArray((int)array);
                break;
            }
            case 1: {
                ARBVertexArrayObject.glBindVertexArray((int)array);
                break;
            }
            case 2: {
                JNI.callV((int)array, (long)glBindVertexArrayAPPLE);
                break;
            }
            case 3: {
                throw new UnsupportedOperationException("VAO not supported");
            }
        }
    }

    @Override
    public void glVertexAttribPointer(int index, int size, int type, boolean normalized, int stride, long pointer) {
        GL20C.glVertexAttribPointer((int)index, (int)size, (int)type, (boolean)normalized, (int)stride, (long)pointer);
    }

    @Override
    public void glVertexAttribIPointer(int index, int size, int type, int stride, long pointer) {
        switch (this.vertexAttribIMode.ordinal()) {
            case 0: {
                GL30C.glVertexAttribIPointer((int)index, (int)size, (int)type, (int)stride, (long)pointer);
                break;
            }
            case 1: {
                EXTGPUShader4.glVertexAttribIPointerEXT((int)index, (int)size, (int)type, (int)stride, (long)pointer);
                break;
            }
            case 2: {
                throw new UnsupportedOperationException("glVertexAttribIPointer not supported");
            }
        }
    }

    @Override
    public void glEnableVertexAttribArray(int index) {
        GL20C.glEnableVertexAttribArray((int)index);
    }

    @Override
    public int glCreateShader(int type) {
        return GL20C.glCreateShader((int)type);
    }

    @Override
    public void glShaderSource(int shader, CharSequence source) {
        GL20C.glShaderSource((int)shader, (CharSequence)source);
    }

    @Override
    public void glShaderSourceSafe(int shader, CharSequence source) {
        try (org.lwjgl.system.MemoryStack stack = org.lwjgl.system.MemoryStack.stackPush();){
            ByteBuffer sourceBuffer = MemoryUtil.memUTF8((CharSequence)source, (boolean)true);
            PointerBuffer pointers = stack.mallocPointer(1);
            pointers.put(sourceBuffer);
            GL20C.nglShaderSource((int)shader, (int)1, (long)pointers.address0(), (long)0L);
            APIUtil.apiArrayFree((long)pointers.address0(), (int)1);
        }
    }

    @Override
    public void glCompileShader(int shader) {
        GL20C.glCompileShader((int)shader);
    }

    @Override
    public String glGetShaderInfoLog(int shader, int maxLength) {
        return GL20C.glGetShaderInfoLog((int)shader);
    }

    @Override
    public int glGetShaderi(int shader, int pname) {
        return GL20C.glGetShaderi((int)shader, (int)pname);
    }

    @Override
    public void glDeleteShader(int shader) {
        GL20C.glDeleteShader((int)shader);
    }

    @Override
    public int glCreateProgram() {
        return GL20C.glCreateProgram();
    }

    @Override
    public void glAttachShader(int program, int shader) {
        GL20C.glAttachShader((int)program, (int)shader);
    }

    @Override
    public void glLinkProgram(int program) {
        GL20C.glLinkProgram((int)program);
    }

    @Override
    public String glGetProgramInfoLog(int program, int maxLength) {
        return GL20C.glGetProgramInfoLog((int)program);
    }

    @Override
    public int glGetProgrami(int program, int pname) {
        return GL20C.glGetProgrami((int)program, (int)pname);
    }

    @Override
    public void glUseProgram(int program) {
        GL20C.glUseProgram((int)program);
    }

    @Override
    public void glDeleteProgram(int program) {
        GL20C.glDeleteProgram((int)program);
    }

    @Override
    public void glBindAttribLocation(int program, int index, CharSequence name) {
        GL20C.glBindAttribLocation((int)program, (int)index, (CharSequence)name);
    }

    @Override
    public void glBindFragDataLocation(int program, int colorNumber, CharSequence name) {
        GL30C.glBindFragDataLocation((int)program, (int)colorNumber, (CharSequence)name);
    }

    @Override
    public int glGetUniformLocation(int program, CharSequence name) {
        return GL20C.glGetUniformLocation((int)program, (CharSequence)name);
    }

    @Override
    public int glGetUniformBlockIndex(int program, CharSequence name) {
        return GL31C.glGetUniformBlockIndex((int)program, (CharSequence)name);
    }

    @Override
    public void glUniformBlockBinding(int program, int blockIndex, int blockBinding) {
        GL31C.glUniformBlockBinding((int)program, (int)blockIndex, (int)blockBinding);
    }

    @Override
    public void glUniform1f(int location, float v0) {
        GL20C.glUniform1f((int)location, (float)v0);
    }

    @Override
    public void glUniform1i(int location, int v0) {
        GL20C.glUniform1i((int)location, (int)v0);
    }

    @Override
    public void glUniform1fv(int location, FloatBuffer value) {
        GL20C.glUniform1fv((int)location, (FloatBuffer)value);
    }

    @Override
    public void glUniform2i(int location, int v0, int v1) {
        GL20C.glUniform2i((int)location, (int)v0, (int)v1);
    }

    @Override
    public void glUniform3f(int location, float v0, float v1, float v2) {
        GL20C.glUniform3f((int)location, (float)v0, (float)v1, (float)v2);
    }

    @Override
    public void glUniform3fv(int location, FloatBuffer value) {
        GL20C.glUniform3fv((int)location, (FloatBuffer)value);
    }

    @Override
    public void glUniform3fv(int location, float[] value) {
        GL20C.glUniform3fv((int)location, (float[])value);
    }

    @Override
    public void glUniform4fv(int location, FloatBuffer value) {
        GL20C.glUniform4fv((int)location, (FloatBuffer)value);
    }

    @Override
    public void glUniform4fv(int location, float[] value) {
        GL20C.glUniform4fv((int)location, (float[])value);
    }

    @Override
    public void glUniformMatrix3fv(int location, boolean transpose, FloatBuffer value) {
        GL20C.glUniformMatrix3fv((int)location, (boolean)transpose, (FloatBuffer)value);
    }

    @Override
    public void glUniformMatrix4fv(int location, boolean transpose, FloatBuffer value) {
        GL20C.glUniformMatrix4fv((int)location, (boolean)transpose, (FloatBuffer)value);
    }

    @Override
    public void glDrawElementsBaseVertex(int mode, int count, int type, long indices, int basevertex) {
        GL32C.glDrawElementsBaseVertex((int)mode, (int)count, (int)type, (long)indices, (int)basevertex);
    }

    @Override
    public void glMultiDrawElementsBaseVertex(int mode, long pCount, int type, long pIndices, int drawcount, long pBaseVertex) {
        GL32C.nglMultiDrawElementsBaseVertex((int)mode, (long)pCount, (int)type, (long)pIndices, (int)drawcount, (long)pBaseVertex);
    }

    @Override
    public void glMultiDrawElementsIndirect(int mode, int type, long indirect, int drawcount, int stride) {
        GL43C.glMultiDrawElementsIndirect((int)mode, (int)type, (long)indirect, (int)drawcount, (int)stride);
    }

    @Override
    public long glFenceSync(int condition, int flags) {
        return GL32C.glFenceSync((int)condition, (int)flags);
    }

    @Override
    public int glClientWaitSync(long sync, int flags, long timeout) {
        return GL32C.glClientWaitSync((long)sync, (int)flags, (long)timeout);
    }

    @Override
    public int glGetSynci(long sync, int pname, IntBuffer length) {
        return GL32C.glGetSynci((long)sync, (int)pname, (IntBuffer)length);
    }

    @Override
    public void glWaitSync(long sync, int flags, long timeout) {
        GL32C.glWaitSync((long)sync, (int)flags, (long)timeout);
    }

    @Override
    public void glDeleteSync(long sync) {
        GL32C.glDeleteSync((long)sync);
    }

    @Override
    public int glGenQueries() {
        return GL15C.glGenQueries();
    }

    @Override
    public void glDeleteQueries(int query) {
        GL15C.glDeleteQueries((int)query);
    }

    @Override
    public void glQueryCounter(int id, int target) {
        switch (this.timerQueryMode.ordinal()) {
            case 0: {
                GL33C.glQueryCounter((int)id, (int)target);
                break;
            }
            case 1: {
                ARBTimerQuery.glQueryCounter((int)id, (int)target);
                break;
            }
        }
    }

    @Override
    public long glGetQueryObjectui64(int id, int pname) {
        return switch (this.timerQueryMode.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> GL33C.glGetQueryObjectui64((int)id, (int)pname);
            case 1 -> ARBTimerQuery.glGetQueryObjectui64((int)id, (int)pname);
            case 2 -> 0L;
        };
    }

    @Override
    public PrintStream getDebugStream() {
        return APIUtil.DEBUG_STREAM;
    }

    @Override
    public int setupDebugCallback(DebugMessageHandler handler) {
        return this.debugSupport.setupDebugCallback(handler);
    }

    @Override
    public void disableDebugCallback() {
        this.debugSupport.disableDebugCallback();
    }

    @Override
    public void glObjectLabel(int identifier, int name, CharSequence label) {
        if (this.debugMode == DebugMode.KHR) {
            KHRDebug.glObjectLabel((int)identifier, (int)name, (CharSequence)label);
        }
    }

    @Override
    public void glPushDebugGroup(int source, int id, CharSequence message) {
        if (this.debugMode == DebugMode.KHR) {
            KHRDebug.glPushDebugGroup((int)source, (int)id, (CharSequence)message);
        }
    }

    @Override
    public void glPopDebugGroup() {
        if (this.debugMode == DebugMode.KHR) {
            KHRDebug.glPopDebugGroup();
        }
    }

    @Override
    public int glGenTextures() {
        return GL11C.glGenTextures();
    }

    @Override
    public void glGenTextures(int[] textures) {
        GL11C.glGenTextures((int[])textures);
    }

    @Override
    public void glDeleteTextures(int texture) {
        GL11C.glDeleteTextures((int)texture);
    }

    @Override
    public void glDeleteTextures(int[] textures) {
        GL11C.glDeleteTextures((int[])textures);
    }

    @Override
    public void glBindTexture(int target, int texture) {
        GL11C.glBindTexture((int)target, (int)texture);
    }

    @Override
    public void glActiveTexture(int texture) {
        GL13C.glActiveTexture((int)texture);
    }

    @Override
    public int glGetTexLevelParameteri(int target, int level, int pname) {
        return GL11C.glGetTexLevelParameteri((int)target, (int)level, (int)pname);
    }

    @Override
    public void glCopyTexSubImage2D(int target, int level, int xoffset, int yoffset, int x, int y, int width, int height) {
        GL11C.glCopyTexSubImage2D((int)target, (int)level, (int)xoffset, (int)yoffset, (int)x, (int)y, (int)width, (int)height);
    }

    @Override
    public void glPixelStorei(int pname, int param) {
        GL11C.glPixelStorei((int)pname, (int)param);
    }

    @Override
    public int glGenFramebuffers() {
        return GL30C.glGenFramebuffers();
    }

    @Override
    public void glDeleteFramebuffers(int framebuffer) {
        GL30C.glDeleteFramebuffers((int)framebuffer);
    }

    @Override
    public void glBindFramebuffer(int target, int framebuffer) {
        GL30C.glBindFramebuffer((int)target, (int)framebuffer);
    }

    @Override
    public int glCheckFramebufferStatus(int target) {
        return GL30C.glCheckFramebufferStatus((int)target);
    }

    @Override
    public void glFramebufferTexture2D(int target, int attachment, int textarget, int texture, int level) {
        GL30C.glFramebufferTexture2D((int)target, (int)attachment, (int)textarget, (int)texture, (int)level);
    }

    @Override
    public void glEnable(int cap) {
        GL11C.glEnable((int)cap);
    }

    @Override
    public void glDisable(int cap) {
        GL11C.glDisable((int)cap);
    }

    @Override
    public void glBlendFunc(int sfactor, int dfactor) {
        GL11C.glBlendFunc((int)sfactor, (int)dfactor);
    }

    @Override
    public void glBlendFuncSeparate(int srcRGB, int dstRGB, int srcAlpha, int dstAlpha) {
        GL14C.glBlendFuncSeparate((int)srcRGB, (int)dstRGB, (int)srcAlpha, (int)dstAlpha);
    }

    @Override
    public void glDepthFunc(int func) {
        GL11C.glDepthFunc((int)func);
    }

    @Override
    public void glDepthMask(boolean flag) {
        GL11C.glDepthMask((boolean)flag);
    }

    @Override
    public void glColorMask(boolean red, boolean green, boolean blue, boolean alpha) {
        GL11C.glColorMask((boolean)red, (boolean)green, (boolean)blue, (boolean)alpha);
    }

    @Override
    public void glViewport(int x, int y, int width, int height) {
        GL11C.glViewport((int)x, (int)y, (int)width, (int)height);
    }

    @Override
    public void glClear(int mask) {
        GL11C.glClear((int)mask);
    }

    @Override
    public void glClearColor(float red, float green, float blue, float alpha) {
        GL11C.glClearColor((float)red, (float)green, (float)blue, (float)alpha);
    }

    @Override
    public int glGetError() {
        return GL11C.glGetError();
    }

    @Override
    public void glMatrixMode(int mode) {
        GL11.glMatrixMode((int)mode);
    }

    @Override
    public void glLoadMatrixf(FloatBuffer m) {
        GL11.glLoadMatrixf((FloatBuffer)m);
    }

    @Override
    public int glGetInteger(int pname) {
        return GL11C.glGetInteger((int)pname);
    }

    @Override
    public void glGetIntegerv(int pname, int[] params) {
        GL11C.glGetIntegerv((int)pname, (int[])params);
    }

    @Override
    public boolean glGetBoolean(int pname) {
        return GL11C.glGetBoolean((int)pname);
    }

    @Override
    public String glGetString(int pname) {
        return GL11C.glGetString((int)pname);
    }

    @Override
    public int glGetAttribLocation(int program, CharSequence name) {
        return GL20C.glGetAttribLocation((int)program, (CharSequence)name);
    }

    @Override
    public MemoryStack stackPush() {
        return new LWJGL3MemoryStack(org.lwjgl.system.MemoryStack.stackPush());
    }

    @Override
    public long nmemAlloc(long size) {
        return MemoryUtil.nmemAlloc((long)size);
    }

    @Override
    public long nmemCalloc(long count, long size) {
        return MemoryUtil.nmemCalloc((long)count, (long)size);
    }

    @Override
    public long nmemAlignedAlloc(long alignment, long size) {
        return MemoryUtil.nmemAlignedAlloc((long)alignment, (long)size);
    }

    @Override
    public long nmemRealloc(long ptr, long size) {
        return MemoryUtil.nmemRealloc((long)ptr, (long)size);
    }

    @Override
    public void nmemFree(long ptr) {
        MemoryUtil.nmemFree((long)ptr);
    }

    @Override
    public void nmemAlignedFree(long ptr) {
        MemoryUtil.nmemAlignedFree((long)ptr);
    }

    @Override
    public ByteBuffer memAlloc(int size) {
        return MemoryUtil.memAlloc((int)size);
    }

    @Override
    public ByteBuffer memCalloc(int size) {
        return MemoryUtil.memCalloc((int)size);
    }

    @Override
    public ByteBuffer memRealloc(ByteBuffer buffer, int size) {
        return MemoryUtil.memRealloc((ByteBuffer)buffer, (int)size);
    }

    @Override
    public void memFree(Buffer buffer) {
        MemoryUtil.memFree((Buffer)buffer);
    }

    @Override
    public ByteBuffer memByteBuffer(long address, int capacity) {
        return MemoryUtil.memByteBuffer((long)address, (int)capacity);
    }

    @Override
    public long memAddress(Buffer buffer) {
        return MemoryUtil.memAddress((Buffer)buffer);
    }

    @Override
    public long memAddress(Buffer buffer, int position) {
        int elementSize;
        long base = MemoryUtil.memAddress((Buffer)buffer);
        if (buffer instanceof ByteBuffer) {
            elementSize = 1;
        } else if (buffer instanceof ShortBuffer || buffer instanceof CharBuffer) {
            elementSize = 2;
        } else if (buffer instanceof IntBuffer || buffer instanceof FloatBuffer) {
            elementSize = 4;
        } else if (buffer instanceof LongBuffer || buffer instanceof DoubleBuffer) {
            elementSize = 8;
        } else {
            throw new IllegalArgumentException("Unsupported buffer type: " + String.valueOf(buffer.getClass()));
        }
        return base + (long)position * (long)elementSize;
    }

    @Override
    public void memSet(long address, int value, long bytes) {
        MemoryUtil.memSet((long)address, (int)value, (long)bytes);
    }

    @Override
    public void memCopy(long src, long dst, long bytes) {
        MemoryUtil.memCopy((long)src, (long)dst, (long)bytes);
    }

    @Override
    public void memPutByte(long address, byte value) {
        MemoryUtil.memPutByte((long)address, (byte)value);
    }

    @Override
    public void memPutShort(long address, short value) {
        MemoryUtil.memPutShort((long)address, (short)value);
    }

    @Override
    public void memPutInt(long address, int value) {
        MemoryUtil.memPutInt((long)address, (int)value);
    }

    @Override
    public void memPutFloat(long address, float value) {
        MemoryUtil.memPutFloat((long)address, (float)value);
    }

    @Override
    public void memPutLong(long address, long value) {
        MemoryUtil.memPutLong((long)address, (long)value);
    }

    @Override
    public void memPutAddress(long address, long value) {
        MemoryUtil.memPutAddress((long)address, (long)value);
    }

    @Override
    public byte memGetByte(long address) {
        return MemoryUtil.memGetByte((long)address);
    }

    @Override
    public short memGetShort(long address) {
        return MemoryUtil.memGetShort((long)address);
    }

    @Override
    public int memGetInt(long address) {
        return MemoryUtil.memGetInt((long)address);
    }

    @Override
    public float memGetFloat(long address) {
        return MemoryUtil.memGetFloat((long)address);
    }

    @Override
    public long memGetLong(long address) {
        return MemoryUtil.memGetLong((long)address);
    }

    @Override
    public long memGetAddress(long address) {
        return MemoryUtil.memGetAddress((long)address);
    }

    @Override
    public ByteBuffer memSlice(ByteBuffer buffer, int offset, int capacity) {
        return MemoryUtil.memSlice((ByteBuffer)buffer, (int)offset, (int)capacity);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static enum VAOMode {
        CORE,
        ARB,
        APPLE,
        NONE;

    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static enum TimerQueryMode {
        CORE,
        ARB,
        NONE;

    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static enum DebugMode {
        KHR,
        NONE;

    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static enum VertexAttribIMode {
        CORE,
        EXT,
        NONE;

    }
}

