/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.glsm;

import com.mitchej123.glsm.RenderSystemService;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class RenderSystemServiceProvider {
    private static final Logger LOGGER = LogManager.getLogger((String)"Celeritas/RenderSystem");
    public static final RenderSystemService RENDER_SYSTEM = RenderSystemServiceProvider.loadService();

    private RenderSystemServiceProvider() {
    }

    private static RenderSystemService loadService() {
        ServiceLoader<RenderSystemService> loader = ServiceLoader.load(RenderSystemService.class, RenderSystemService.class.getClassLoader());
        Object best = null;
        Iterator providers = loader.stream().iterator();
        while (providers.hasNext()) {
            ServiceLoader.Provider provider = (ServiceLoader.Provider)providers.next();
            try {
                RenderSystemService service = (RenderSystemService)provider.get();
                LOGGER.debug("Found RenderSystemService: {} (priority {})", new Object[]{service.getClass().getName(), service.getPriority()});
                if (best != null && service.getPriority() <= best.getPriority()) continue;
                best = service;
            }
            catch (LinkageError | ServiceConfigurationError e) {
                LOGGER.debug("Skipping unavailable service {}: {}", new Object[]{provider.type().getName(), e.getMessage()});
            }
        }
        if (best != null) {
            LOGGER.info("Using RenderSystemService: {} (priority {})", new Object[]{best.getClass().getName(), best.getPriority()});
            return best;
        }
        throw new IllegalStateException("No RenderSystemService implementation found.");
    }
}

