/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.glsm;

import com.mitchej123.glsm.GLStateManagerService;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class GLStateManagerServiceProvider {
    private static final Logger LOGGER = LogManager.getLogger((String)"Celeritas/GLStateManager");
    public static final GLStateManagerService GL_STATE_MANAGER = GLStateManagerServiceProvider.loadService();

    private GLStateManagerServiceProvider() {
    }

    private static GLStateManagerService loadService() {
        ServiceLoader<GLStateManagerService> loader = ServiceLoader.load(GLStateManagerService.class, GLStateManagerService.class.getClassLoader());
        Object best = null;
        Iterator providers = loader.stream().iterator();
        while (providers.hasNext()) {
            ServiceLoader.Provider provider = (ServiceLoader.Provider)providers.next();
            try {
                GLStateManagerService service = (GLStateManagerService)provider.get();
                LOGGER.debug("Found GLStateManagerService: {} (priority {})", new Object[]{service.getClass().getName(), service.getPriority()});
                if (best != null && service.getPriority() <= best.getPriority()) continue;
                best = service;
            }
            catch (LinkageError | ServiceConfigurationError e) {
                LOGGER.debug("Skipping unavailable service {}: {}", new Object[]{provider.type().getName(), e.getMessage()});
            }
        }
        if (best != null) {
            LOGGER.info("Using GLStateManagerService: {} (priority {})", new Object[]{best.getClass().getName(), best.getPriority()});
            return best;
        }
        throw new IllegalStateException("No GLStateManagerService implementation found.");
    }
}

