/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.rendering.celeritas.world.cloned;

import com.falsepattern.endlessids.mixin.helpers.ChunkBiomeHook;
import com.gtnewhorizons.angelica.compat.ExtendedBlockStorageExt;
import com.gtnewhorizons.angelica.compat.ModStatus;
import com.gtnewhorizons.angelica.compat.mojang.ChunkSectionPos;
import com.gtnewhorizons.angelica.mixins.interfaces.IChunkTileEntityMapHolder;
import com.gtnewhorizons.angelica.rendering.celeritas.world.cloned.ClonedChunkSectionCache;
import com.gtnewhorizons.angelica.utils.ConcurrentTileEntityMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectOpenHashMap;
import mega.fluidlogged.internal.mixin.hook.FLSubChunk;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.NibbleArray;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraftforge.fluids.Fluid;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class ClonedChunkSection {
    private static final ExtendedBlockStorage EMPTY_SECTION = new ExtendedBlockStorage(0, false);
    private final ClonedChunkSectionCache backingCache;
    private final World world;
    private ChunkSectionPos pos;
    private ExtendedBlockStorageExt data;
    private BiomeGenBase[] biomeData;
    private final Short2ObjectOpenHashMap<TileEntity> tileEntities;
    private long lastUsedTimestamp = Long.MAX_VALUE;

    ClonedChunkSection(ClonedChunkSectionCache backingCache, World world) {
        this.backingCache = backingCache;
        this.world = world;
        this.tileEntities = new Short2ObjectOpenHashMap();
    }

    public void init(ChunkSectionPos pos) {
        Chunk chunk = this.world.func_72964_e(pos.x, pos.z);
        if (chunk == null) {
            throw new RuntimeException("Couldn't retrieve chunk at " + String.valueOf(pos.toChunkPos()));
        }
        ExtendedBlockStorage section = ClonedChunkSection.getChunkSection(chunk, pos);
        if (section == null) {
            section = EMPTY_SECTION;
        }
        this.pos = pos;
        this.data = new ExtendedBlockStorageExt(chunk, section);
        int bArrLength = ModStatus.isEIDBiomeLoaded ? ((ChunkBiomeHook)chunk).getBiomeShortArray().length : chunk.func_76605_m().length;
        this.biomeData = new BiomeGenBase[bArrLength];
        this.copyBlockEntities(chunk, pos);
        for (int z = pos.getMinZ(); z <= pos.getMaxZ(); ++z) {
            for (int x = pos.getMinX(); x <= pos.getMaxX(); ++x) {
                this.biomeData[x & 0xF | (z & 0xF) << 4] = this.world.func_72807_a(x, z);
            }
        }
    }

    private void copyBlockEntities(Chunk chunk, ChunkSectionPos pos) {
        this.tileEntities.clear();
        ConcurrentTileEntityMap map = ((IChunkTileEntityMapHolder)chunk).angelica$getConcurrentTEMap();
        map.withReadLock(() -> {
            Object2ObjectOpenHashMap<ChunkPosition, TileEntity> delegate = map.getDelegate();
            if (delegate.isEmpty()) {
                return;
            }
            int minY = pos.getMinY();
            int maxY = pos.getMaxY();
            for (Object2ObjectMap.Entry entry : Object2ObjectMaps.fastIterable(delegate)) {
                TileEntity te;
                ChunkPosition tePos = (ChunkPosition)entry.getKey();
                if (tePos.field_151327_b < minY || tePos.field_151327_b > maxY || (te = (TileEntity)entry.getValue()) == null || te.func_145837_r()) continue;
                this.tileEntities.put(ChunkSectionPos.packLocal(tePos.field_151329_a & 0xF, tePos.field_151327_b & 0xF, tePos.field_151328_c & 0xF), (Object)te);
            }
        });
        this.tileEntities.trim();
    }

    public Block getBlock(int x, int y, int z) {
        return this.data.func_150819_a(x, y, z);
    }

    public int getBlockMetadata(int x, int y, int z) {
        return this.data.func_76665_b(x, y, z);
    }

    public Fluid getFluid(int x, int y, int z) {
        if (ModStatus.isFluidLoggedLoaded) {
            return ((FLSubChunk)this.data).fl$getFluid(x, y, z);
        }
        return null;
    }

    public NibbleArray getLightArray(EnumSkyBlock type) {
        if (type == EnumSkyBlock.Sky) {
            return !this.world.field_73011_w.field_76576_e && this.data.hasSky ? this.data.func_76671_l() : null;
        }
        return this.data.func_76661_k();
    }

    public BiomeGenBase[] getBiomeData() {
        return this.biomeData;
    }

    public BiomeGenBase getBiomeForNoiseGen(int x, int z) {
        return this.biomeData[x & 0xF | (z & 0xF) << 4];
    }

    public TileEntity getBlockEntity(int x, int y, int z) {
        return (TileEntity)this.tileEntities.get(ChunkSectionPos.packLocal(x, y, z));
    }

    public ChunkSectionPos getPosition() {
        return this.pos;
    }

    public ExtendedBlockStorageExt getData() {
        return this.data;
    }

    public ClonedChunkSectionCache getBackingCache() {
        return this.backingCache;
    }

    public long getLastUsedTimestamp() {
        return this.lastUsedTimestamp;
    }

    public void setLastUsedTimestamp(long timestamp) {
        this.lastUsedTimestamp = timestamp;
    }

    public static boolean isOutOfBuildLimitVertically(int y) {
        return y < 0 || y >= 256;
    }

    private static ExtendedBlockStorage getChunkSection(Chunk chunk, ChunkSectionPos pos) {
        if (!ClonedChunkSection.isOutOfBuildLimitVertically(ChunkSectionPos.getBlockCoord(pos.y))) {
            return chunk.func_76587_i()[pos.y];
        }
        return null;
    }
}

