/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.rendering.celeritas.light;

import org.embeddedt.embeddium.api.util.ColorABGR;
import org.embeddedt.embeddium.impl.model.light.DiffuseProvider;
import org.embeddedt.embeddium.impl.model.quad.properties.ModelQuadFacing;
import xyz.wagyourtail.jvmdg.j21.stub.java_base.J_L_MatchException;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public enum VanillaDiffuseProvider implements DiffuseProvider
{
    INSTANCE;

    private static final float DOWN = 0.5f;
    private static final float UP = 1.0f;
    private static final float NORTH_SOUTH = 0.8f;
    private static final float EAST_WEST = 0.6f;
    private static final float INV_DOWN = 2.0f;
    private static final float INV_UP = 1.0f;
    private static final float INV_NORTH_SOUTH = 1.25f;
    private static final float INV_EAST_WEST = 1.6666666f;

    @Override
    public float getDiffuse(float normalX, float normalY, float normalZ, boolean shade) {
        if (!shade) {
            return 1.0f;
        }
        return Math.min(normalX * normalX * 0.6f + normalY * normalY * (normalY >= 0.0f ? 1.0f : 0.5f) + normalZ * normalZ * 0.8f, 1.0f);
    }

    @Override
    public float getDiffuse(ModelQuadFacing lightFace, boolean shade) {
        if (!shade) {
            return 1.0f;
        }
        return switch (lightFace) {
            default -> throw new J_L_MatchException(null, null);
            case ModelQuadFacing.NEG_Y -> 0.5f;
            case ModelQuadFacing.POS_Y -> 1.0f;
            case ModelQuadFacing.NEG_Z, ModelQuadFacing.POS_Z -> 0.8f;
            case ModelQuadFacing.NEG_X, ModelQuadFacing.POS_X -> 0.6f;
            case ModelQuadFacing.UNASSIGNED -> 1.0f;
        };
    }

    public float getInverseDiffuse(ModelQuadFacing lightFace) {
        return switch (lightFace) {
            default -> throw new J_L_MatchException(null, null);
            case ModelQuadFacing.NEG_Y -> 2.0f;
            case ModelQuadFacing.POS_Y -> 1.0f;
            case ModelQuadFacing.NEG_Z, ModelQuadFacing.POS_Z -> 1.25f;
            case ModelQuadFacing.NEG_X, ModelQuadFacing.POS_X -> 1.6666666f;
            case ModelQuadFacing.UNASSIGNED -> 1.0f;
        };
    }

    public static int multiplyColor(int color, float factor) {
        if (factor == 1.0f) {
            return color;
        }
        int r = Math.min(255, (int)((float)ColorABGR.unpackRed(color) * factor));
        int g = Math.min(255, (int)((float)ColorABGR.unpackGreen(color) * factor));
        int b = Math.min(255, (int)((float)ColorABGR.unpackBlue(color) * factor));
        int a = ColorABGR.unpackAlpha(color);
        return ColorABGR.pack(r, g, b, a);
    }
}

