/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.rendering.celeritas;

import com.mitchej123.lwjgl.LWJGLServiceProvider;
import org.embeddedt.embeddium.impl.gl.device.CommandList;
import org.embeddedt.embeddium.impl.gl.device.DrawCommandList;
import org.embeddedt.embeddium.impl.gl.device.MultiDrawBatch;
import org.embeddedt.embeddium.impl.gl.tessellation.GlIndexType;
import org.embeddedt.embeddium.impl.gl.tessellation.GlPrimitiveType;
import org.embeddedt.embeddium.impl.gl.tessellation.GlTessellation;
import org.embeddedt.embeddium.impl.model.quad.properties.ModelQuadFacing;
import org.embeddedt.embeddium.impl.render.chunk.data.SectionRenderDataUnsafe;
import org.embeddedt.embeddium.impl.render.chunk.multidraw.MultiDrawEmitter;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public record IndividualDrawEmitter(MultiDrawBatch batch) implements MultiDrawEmitter
{
    public IndividualDrawEmitter() {
        this(new MultiDrawBatch(MAX_COMMAND_COUNT));
    }

    @Override
    public void addDrawCommands(long pMeshData, int mask, int indexPointerMask) {
        MultiDrawBatch batch = this.batch;
        long pBaseVertex = batch.pBaseVertex;
        long pElementCount = batch.pElementCount;
        long pElementPointer = batch.pElementPointer;
        int size = batch.size;
        for (int facing = 0; facing < ModelQuadFacing.COUNT; ++facing) {
            LWJGLServiceProvider.LWJGL.memPutInt(pBaseVertex + (long)(size << 2), SectionRenderDataUnsafe.getVertexOffset(pMeshData, facing));
            LWJGLServiceProvider.LWJGL.memPutInt(pElementCount + (long)(size << 2), SectionRenderDataUnsafe.getElementCount(pMeshData, facing));
            LWJGLServiceProvider.LWJGL.memPutAddress(pElementPointer + (long)(size << 3), SectionRenderDataUnsafe.getIndexOffset(pMeshData, facing) & indexPointerMask);
            size += mask >> facing & 1;
        }
        batch.size = size;
    }

    @Override
    public void executeBatch(CommandList commandList, GlTessellation tessellation, GlPrimitiveType primitiveType) {
        try (DrawCommandList drawCommandList = commandList.beginTessellating(tessellation);){
            int mode = primitiveType.getId();
            int type = GlIndexType.UNSIGNED_INT.getFormatId();
            for (int i = 0; i < this.batch.size; ++i) {
                int count = LWJGLServiceProvider.LWJGL.memGetInt(this.batch.pElementCount + (long)i * 4L);
                if (count <= 0) continue;
                LWJGLServiceProvider.LWJGL.glDrawElementsBaseVertex(mode, count, type, LWJGLServiceProvider.LWJGL.memGetAddress(this.batch.pElementPointer + (long)i * (long)LWJGLServiceProvider.POINTER_SIZE), LWJGLServiceProvider.LWJGL.memGetInt(this.batch.pBaseVertex + (long)i * 4L));
            }
        }
    }

    @Override
    public int getIndexBufferSize() {
        return this.batch.getIndexBufferSize();
    }

    @Override
    public boolean isEmpty() {
        return this.batch.isEmpty();
    }

    @Override
    public void clear() {
        this.batch.clear();
    }

    @Override
    public void delete() {
        this.batch.delete();
    }
}

