/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.rendering.celeritas;

import com.gtnewhorizons.angelica.AngelicaMod;
import com.gtnewhorizons.angelica.dynamiclights.DynamicLights;
import com.gtnewhorizons.angelica.dynamiclights.IDynamicLightWorldRenderer;
import com.gtnewhorizons.angelica.glsm.GLStateManager;
import com.gtnewhorizons.angelica.mixins.interfaces.ITileEntityBoundingBoxCache;
import com.gtnewhorizons.angelica.rendering.RenderingState;
import com.gtnewhorizons.angelica.rendering.TileEntityRenderBoundsRegistry;
import com.gtnewhorizons.angelica.rendering.celeritas.AngelicaRenderSectionManager;
import com.gtnewhorizons.angelica.rendering.celeritas.BlockRenderLayer;
import com.gtnewhorizons.angelica.rendering.celeritas.api.IrisShaderProvider;
import com.gtnewhorizons.angelica.rendering.celeritas.api.IrisShaderProviderHolder;
import java.util.Iterator;
import java.util.List;
import net.coderbot.iris.pipeline.ShadowRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.client.MinecraftForgeClient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.embeddedt.embeddium.impl.gl.device.CommandList;
import org.embeddedt.embeddium.impl.render.chunk.ChunkRenderMatrices;
import org.embeddedt.embeddium.impl.render.chunk.RenderSection;
import org.embeddedt.embeddium.impl.render.chunk.data.BuiltRenderSectionData;
import org.embeddedt.embeddium.impl.render.chunk.data.MinecraftBuiltRenderSectionData;
import org.embeddedt.embeddium.impl.render.chunk.lists.ChunkRenderList;
import org.embeddedt.embeddium.impl.render.chunk.lists.SortedRenderLists;
import org.embeddedt.embeddium.impl.render.chunk.region.RenderRegion;
import org.embeddedt.embeddium.impl.render.chunk.vertex.format.ChunkMeshFormats;
import org.embeddedt.embeddium.impl.render.chunk.vertex.format.ChunkVertexType;
import org.embeddedt.embeddium.impl.render.terrain.SimpleWorldRenderer;
import org.embeddedt.embeddium.impl.render.viewport.CameraTransform;
import org.embeddedt.embeddium.impl.render.viewport.Viewport;
import org.embeddedt.embeddium.impl.util.iterator.ByteIterator;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.lwjgl.opengl.GL11;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class CeleritasWorldRenderer
extends SimpleWorldRenderer<WorldClient, AngelicaRenderSectionManager, BlockRenderLayer, TileEntity, TileEntityRenderContext>
implements IDynamicLightWorldRenderer {
    private static final Logger LOGGER = LogManager.getLogger((String)"Angelica");
    private final Minecraft mc;
    private static CeleritasWorldRenderer instance;
    public static boolean DEBUG_WIREFRAME_MODE;
    private final TileEntityRenderContext teRenderContext = new TileEntityRenderContext();
    private boolean useEntityCulling = true;
    private static final double MAX_ENTITY_CHECK_VOLUME = 61440.0;

    private CeleritasWorldRenderer(Minecraft mc) {
        this.mc = mc;
    }

    public static CeleritasWorldRenderer create(Minecraft mc) {
        instance = new CeleritasWorldRenderer(mc);
        return instance;
    }

    public static CeleritasWorldRenderer getInstance() {
        if (instance == null) {
            throw new IllegalStateException("CeleritasWorldRenderer not initialized");
        }
        return instance;
    }

    @Override
    public AngelicaRenderSectionManager getRenderSectionManager() {
        return (AngelicaRenderSectionManager)this.renderSectionManager;
    }

    @Override
    public boolean isActive() {
        return this.world != null;
    }

    @Override
    protected void loadWorld(WorldClient world) {
        super.loadWorld(world);
        DynamicLights.setActiveRenderer(this);
    }

    @Override
    protected void unloadWorld() {
        DynamicLights.setActiveRenderer(null);
        super.unloadWorld();
    }

    @Override
    public int getEffectiveRenderDistance() {
        return this.mc.field_71474_y.field_151451_c;
    }

    @Override
    public int getMinimumBuildHeight() {
        return 0;
    }

    @Override
    public int getMaximumBuildHeight() {
        return 256;
    }

    @Override
    protected ChunkRenderMatrices createChunkRenderMatrices() {
        boolean shadowPass = ((AngelicaRenderSectionManager)this.renderSectionManager).isInShadowPass();
        Matrix4f projection = shadowPass ? ShadowRenderer.PROJECTION : RenderingState.INSTANCE.getProjectionMatrix();
        Matrix4f modelView = shadowPass ? ShadowRenderer.MODELVIEW : RenderingState.INSTANCE.getModelViewMatrix();
        return new ChunkRenderMatrices((Matrix4fc)projection, (Matrix4fc)modelView);
    }

    private ChunkVertexType chooseVertexType() {
        ChunkVertexType extended;
        IrisShaderProvider provider = IrisShaderProviderHolder.getProvider();
        if (provider != null && provider.isShadersEnabled() && (extended = provider.getVertexType(ChunkMeshFormats.VANILLA_LIKE)) != ChunkMeshFormats.VANILLA_LIKE) {
            return extended;
        }
        if (AngelicaMod.options().performance.useCompactVertexFormat) {
            return ChunkMeshFormats.COMPACT;
        }
        return ChunkMeshFormats.VANILLA_LIKE;
    }

    @Override
    protected AngelicaRenderSectionManager createRenderSectionManager(CommandList commandList) {
        return AngelicaRenderSectionManager.create(this.chooseVertexType(), (WorldClient)this.world, this.renderDistance, commandList);
    }

    @Override
    protected void renderBlockEntityList(List<TileEntity> list, TileEntityRenderContext context) {
        for (TileEntity tileEntity : list) {
            this.renderTE(tileEntity, context.pass, context.partialTicks);
        }
    }

    @Override
    public void setupTerrain(Viewport viewport, SimpleWorldRenderer.CameraState cameraState, int frame, boolean spectator, boolean updateChunksImmediately) {
        CameraTransform transform = viewport.getTransform();
        if (transform.x == 0.0 && transform.y == 0.0 && transform.z == 0.0) {
            return;
        }
        ((AngelicaRenderSectionManager)this.renderSectionManager).setCameraPosition(transform.x, transform.y, transform.z);
        this.useEntityCulling = AngelicaMod.options().performance.useEntityCulling;
        super.setupTerrain(viewport, cameraState, frame, spectator, updateChunksImmediately);
        if (DynamicLights.isEnabled() && DynamicLights.FrustumCullingEnabled) {
            DynamicLights.get().processChunkRebuilds(viewport);
        }
        if (((AngelicaRenderSectionManager)this.renderSectionManager).isInShadowPass() && IrisShaderProviderHolder.isActive()) {
            this.collectTileEntitiesForShadow();
        }
    }

    public void setCurrentViewport(Viewport viewport) {
        this.currentViewport = viewport;
    }

    private void collectTileEntitiesForShadow() {
        SortedRenderLists renderLists = ((AngelicaRenderSectionManager)this.renderSectionManager).getRenderLists();
        Iterator<ChunkRenderList> renderListIterator = renderLists.iterator();
        while (renderListIterator.hasNext()) {
            ChunkRenderList renderList = renderListIterator.next();
            RenderRegion renderRegion = renderList.getRegion();
            ByteIterator renderSectionIterator = renderList.sectionsWithEntitiesIterator();
            if (renderSectionIterator == null) continue;
            while (renderSectionIterator.hasNext()) {
                BuiltRenderSectionData context;
                int renderSectionId = renderSectionIterator.nextByteAsInt();
                RenderSection renderSection = renderRegion.getSection(renderSectionId);
                if (renderSection == null || !((context = renderSection.getBuiltContext()) instanceof MinecraftBuiltRenderSectionData)) continue;
                MinecraftBuiltRenderSectionData mcData = (MinecraftBuiltRenderSectionData)context;
                List culledEntities = mcData.culledBlockEntities;
                ShadowRenderer.visibleTileEntities.addAll(culledEntities);
            }
        }
        for (RenderSection renderSection : ((AngelicaRenderSectionManager)this.renderSectionManager).getSectionsWithGlobalEntities()) {
            BuiltRenderSectionData context = renderSection.getBuiltContext();
            if (!(context instanceof MinecraftBuiltRenderSectionData)) continue;
            MinecraftBuiltRenderSectionData mcData = (MinecraftBuiltRenderSectionData)context;
            List globalEntities = mcData.globalBlockEntities;
            ShadowRenderer.globalTileEntities.addAll(globalEntities);
        }
    }

    @Override
    public void drawChunkLayer(BlockRenderLayer renderLayer, double x, double y, double z) {
        if (DEBUG_WIREFRAME_MODE) {
            GL11.glPolygonMode((int)1032, (int)6913);
        }
        super.drawChunkLayer(renderLayer, x, y, z);
        if (DEBUG_WIREFRAME_MODE) {
            GL11.glPolygonMode((int)1032, (int)6914);
        }
        GLStateManager.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
    }

    @Override
    public int renderBlockEntities(float partialTicks) {
        int pass = MinecraftForgeClient.getRenderPass();
        return super.renderBlockEntities(this.teRenderContext.set(partialTicks, pass));
    }

    private void renderTE(TileEntity tileEntity, int pass, float partialTicks) {
        AxisAlignedBB aabb;
        if (!tileEntity.shouldRenderInPass(pass)) {
            return;
        }
        ITileEntityBoundingBoxCache teCache = (ITileEntityBoundingBoxCache)tileEntity;
        if (!teCache.angelica$isInfiniteExtent() && (aabb = teCache.angelica$getCachedRenderBoundingBox()) != null && !this.currentViewport.isBoxVisible(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c, aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f)) {
            return;
        }
        try {
            TileEntityRendererDispatcher.field_147556_a.func_147544_a(tileEntity, partialTicks);
        }
        catch (RuntimeException e) {
            if (tileEntity.func_145837_r()) {
                LOGGER.warn("Suppressed exception rendering invalid TileEntity {} at ({}, {}, {})", new Object[]{tileEntity.getClass().getName(), tileEntity.field_145851_c, tileEntity.field_145848_d, tileEntity.field_145849_e, e});
            }
            throw e;
        }
    }

    public boolean isEntityVisible(Entity entity) {
        if (!this.useEntityCulling || ((AngelicaRenderSectionManager)this.renderSectionManager).isInShadowPass()) {
            return true;
        }
        AxisAlignedBB box = entity.func_70046_E();
        if (box == null) {
            box = entity.field_70121_D;
        }
        if (TileEntityRenderBoundsRegistry.isInfiniteExtentsBox(box)) {
            return true;
        }
        double entityVolume = (box.field_72336_d - box.field_72340_a) * (box.field_72337_e - box.field_72338_b) * (box.field_72334_f - box.field_72339_c);
        if (entityVolume > 61440.0) {
            return true;
        }
        return this.isBoxVisible(box.field_72340_a, box.field_72338_b, box.field_72339_c, box.field_72336_d, box.field_72337_e, box.field_72334_f);
    }

    static {
        DEBUG_WIREFRAME_MODE = false;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static class TileEntityRenderContext {
        public float partialTicks;
        public int pass;

        public TileEntityRenderContext set(float partialTicks, int pass) {
            this.partialTicks = partialTicks;
            this.pass = pass;
            return this;
        }
    }
}

