/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.rendering.celeritas;

import com.gtnewhorizons.angelica.config.AngelicaConfig;
import com.gtnewhorizons.angelica.dynamiclights.DynamicLights;
import com.gtnewhorizons.angelica.glsm.GLStateManager;
import com.gtnewhorizons.angelica.glsm.stacks.FogStateStack;
import com.gtnewhorizons.angelica.rendering.celeritas.CeleritasWorldRenderer;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import net.minecraft.client.Minecraft;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.client.event.RenderGameOverlayEvent;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class CeleritasDebugScreenHandler {
    public static final CeleritasDebugScreenHandler INSTANCE = new CeleritasDebugScreenHandler();
    public static boolean showFogDebug = false;

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onRenderGameOverlayTextEvent(RenderGameOverlayEvent.Text event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (!mc.field_71474_y.field_74330_P || AngelicaConfig.disableF3Additions) {
            return;
        }
        CeleritasWorldRenderer renderer = CeleritasWorldRenderer.getInstance();
        if (renderer == null) {
            return;
        }
        if (showFogDebug) {
            event.left.add(CeleritasDebugScreenHandler.getFogDebugString());
        }
        if (DynamicLights.configEnabled && DynamicLights.isEnabled()) {
            event.left.add(CeleritasDebugScreenHandler.getDynamicLightsDebugString());
        }
        event.right.add("");
        event.right.add(String.valueOf(EnumChatFormatting.GREEN) + "Angelica 2.0.0-alpha20 [Celeritas Renderer]");
        event.right.addAll(renderer.getDebugStrings());
        event.right.add("");
    }

    public static String getFogDebugString() {
        boolean enabled = GLStateManager.getFogMode().isEnabled();
        FogStateStack fog = GLStateManager.getFogState();
        String modeName = switch (fog.getFogMode()) {
            case 9729 -> "LINEAR";
            case 2048 -> "EXP";
            case 2049 -> "EXP2";
            default -> "?";
        };
        return String.format("Fog: %s %s %.0f-%.0f d=%.2f (%.2f, %.2f, %.2f)", enabled ? "ON" : "OFF", modeName, Float.valueOf(fog.getStart()), Float.valueOf(fog.getEnd()), Float.valueOf(fog.getDensity()), fog.getFogColor().x, fog.getFogColor().y, fog.getFogColor().z);
    }

    public static String getDynamicLightsDebugString() {
        DynamicLights dl = DynamicLights.get();
        int sources = dl.getLightSourcesCount();
        int updated = dl.getLastUpdateCount();
        if (DynamicLights.FrustumCullingEnabled) {
            int pending = dl.getChunkRebuildManager().getPendingCount();
            return String.format("DynLights: %d src, %d upd, %d pending", sources, updated, pending);
        }
        return String.format("DynLights: %d sources, %d updated", sources, updated);
    }
}

