/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.rendering.celeritas;

import com.google.common.collect.ImmutableListMultimap;
import com.gtnewhorizons.angelica.rendering.celeritas.BlockRenderLayer;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.util.Collection;
import java.util.Map;
import org.embeddedt.embeddium.impl.render.chunk.RenderPassConfiguration;
import org.embeddedt.embeddium.impl.render.chunk.compile.sorting.QuadPrimitiveType;
import org.embeddedt.embeddium.impl.render.chunk.terrain.TerrainRenderPass;
import org.embeddedt.embeddium.impl.render.chunk.terrain.material.Material;
import org.embeddedt.embeddium.impl.render.chunk.terrain.material.parameters.AlphaCutoffParameter;
import org.embeddedt.embeddium.impl.render.chunk.vertex.format.ChunkVertexType;
import org.lwjgl.opengl.GL11;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class AngelicaRenderPassConfiguration {
    public static TerrainRenderPass SOLID_PASS;
    public static TerrainRenderPass CUTOUT_MIPPED_PASS;
    public static TerrainRenderPass TRANSLUCENT_PASS;
    public static Material SOLID_MATERIAL;
    public static Material CUTOUT_MIPPED_MATERIAL;
    public static Material TRANSLUCENT_MATERIAL;

    private static TerrainRenderPass.TerrainRenderPassBuilder builderForRenderType(int pass, boolean disableAlphaTest, ChunkVertexType vertexType) {
        return TerrainRenderPass.builder().pipelineState(new AngelicaPipelineState(pass, disableAlphaTest)).vertexType(vertexType).primitiveType(QuadPrimitiveType.DIRECT);
    }

    public static RenderPassConfiguration<BlockRenderLayer> build(ChunkVertexType vertexType) {
        SOLID_PASS = AngelicaRenderPassConfiguration.builderForRenderType(0, true, vertexType).name("solid").fragmentDiscard(false).useReverseOrder(false).build();
        CUTOUT_MIPPED_PASS = AngelicaRenderPassConfiguration.builderForRenderType(0, false, vertexType).name("cutout_mipped").fragmentDiscard(true).useReverseOrder(false).build();
        TRANSLUCENT_PASS = AngelicaRenderPassConfiguration.builderForRenderType(1, false, vertexType).name("translucent").fragmentDiscard(false).useReverseOrder(true).useTranslucencySorting(true).build();
        TRANSLUCENT_MATERIAL = new Material(TRANSLUCENT_PASS, AlphaCutoffParameter.ZERO, true);
        SOLID_MATERIAL = new Material(SOLID_PASS, AlphaCutoffParameter.ZERO, true);
        CUTOUT_MIPPED_MATERIAL = new Material(CUTOUT_MIPPED_PASS, AlphaCutoffParameter.ONE_TENTH, true);
        ImmutableListMultimap.Builder vanillaRenderStages = ImmutableListMultimap.builder();
        vanillaRenderStages.put((Object)BlockRenderLayer.SOLID, (Object)SOLID_PASS);
        vanillaRenderStages.put((Object)BlockRenderLayer.CUTOUT, (Object)CUTOUT_MIPPED_PASS);
        vanillaRenderStages.put((Object)BlockRenderLayer.CUTOUT_MIPPED, (Object)CUTOUT_MIPPED_PASS);
        vanillaRenderStages.put((Object)BlockRenderLayer.TRANSLUCENT, (Object)TRANSLUCENT_PASS);
        Reference2ReferenceOpenHashMap renderTypeToMaterialMap = new Reference2ReferenceOpenHashMap(4, 0.25f);
        renderTypeToMaterialMap.put(BlockRenderLayer.SOLID, SOLID_MATERIAL);
        renderTypeToMaterialMap.put(BlockRenderLayer.CUTOUT, CUTOUT_MIPPED_MATERIAL);
        renderTypeToMaterialMap.put(BlockRenderLayer.CUTOUT_MIPPED, CUTOUT_MIPPED_MATERIAL);
        renderTypeToMaterialMap.put(BlockRenderLayer.TRANSLUCENT, TRANSLUCENT_MATERIAL);
        return new RenderPassConfiguration<BlockRenderLayer>((Map<BlockRenderLayer, Material>)renderTypeToMaterialMap, (Map<BlockRenderLayer, Collection<TerrainRenderPass>>)vanillaRenderStages.build().asMap(), CUTOUT_MIPPED_MATERIAL, CUTOUT_MIPPED_MATERIAL, TRANSLUCENT_MATERIAL);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private record AngelicaPipelineState(int pass, boolean disableAlphaTest) implements TerrainRenderPass.PipelineState
    {
        @Override
        public void setup() {
            if (this.pass == 0) {
                GL11.glAlphaFunc((int)516, (float)0.1f);
            }
            if (this.disableAlphaTest) {
                GL11.glDisable((int)3008);
            }
        }

        @Override
        public void clear() {
            if (this.disableAlphaTest) {
                GL11.glEnable((int)3008);
            }
        }
    }
}

