/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.mixins.early.rendering;

import com.gtnewhorizons.angelica.AngelicaMod;
import com.gtnewhorizons.angelica.common.BlockError;
import com.gtnewhorizons.angelica.loading.AngelicaTweaker;
import cpw.mods.fml.client.registry.RenderingRegistry;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import net.coderbot.iris.Iris;
import net.coderbot.iris.block_rendering.BlockRenderingSettings;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.world.IBlockAccess;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@Mixin(value={RenderBlocks.class})
public abstract class MixinRenderBlocks {
    @Unique
    private static final ObjectOpenHashSet<String> isbrhExceptionCache = new ObjectOpenHashSet();
    @Unique
    private static final Object2IntOpenHashMap<Class<? extends Exception>> exceptionErrorBlockMap = new Object2IntOpenHashMap();
    @Unique
    private boolean isRenderingByType = false;

    @Inject(method={"renderBlockByRenderType"}, at={@At(value="HEAD")})
    private void renderingByTypeEnable(CallbackInfoReturnable<Boolean> ci) {
        this.isRenderingByType = true;
    }

    @Inject(method={"renderBlockByRenderType"}, at={@At(value="TAIL")})
    private void renderingByTypeDisable(CallbackInfoReturnable<Boolean> ci) {
        this.isRenderingByType = false;
    }

    @Redirect(method={"renderBlockByRenderType"}, at=@At(value="INVOKE", target="LFMLRenderAccessLibrary;renderWorldBlock(Lnet/minecraft/client/renderer/RenderBlocks;Lnet/minecraft/world/IBlockAccess;IIILnet/minecraft/block/Block;I)Z", remap=false), expect=0)
    private boolean wrapRenderWorldBlockObfuscated(RenderBlocks rb, IBlockAccess world, int x, int y, int z, Block block, int modelId) {
        return this.handleISBRHException(rb, world, x, y, z, block, modelId);
    }

    @Redirect(method={"renderBlockByRenderType"}, at=@At(value="INVOKE", target="Lnet/minecraft/src/FMLRenderAccessLibrary;renderWorldBlock(Lnet/minecraft/client/renderer/RenderBlocks;Lnet/minecraft/world/IBlockAccess;IIILnet/minecraft/block/Block;I)Z", remap=false), expect=0)
    private boolean wrapRenderWorldBlockDeobfuscated(RenderBlocks rb, IBlockAccess world, int x, int y, int z, Block block, int modelId) {
        return this.handleISBRHException(rb, world, x, y, z, block, modelId);
    }

    @Redirect(method={"renderStandardBlock"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/Minecraft;isAmbientOcclusionEnabled()Z"))
    private boolean checkAOEnabled() {
        if (this.isRenderingByType && Minecraft.func_71379_u() && AngelicaMod.options().quality.useCeleritasSmoothLighting || Iris.enabled && BlockRenderingSettings.INSTANCE.shouldUseSeparateAo()) {
            return false;
        }
        return Minecraft.func_71379_u();
    }

    private boolean handleISBRHException(RenderBlocks rb, IBlockAccess world, int x, int y, int z, Block block, int modelId) {
        try {
            return RenderingRegistry.instance().renderWorldBlock(rb, world, x, y, z, block, modelId);
        }
        catch (ArrayIndexOutOfBoundsException | NullPointerException e) {
            int meta = exceptionErrorBlockMap.getOrDefault(e.getClass(), 0);
            rb.field_147840_d = BlockError.icons[exceptionErrorBlockMap.getOrDefault(e.getClass(), 0)];
            rb.func_147784_q((Block)AngelicaMod.blockError, x, y, z);
            rb.field_147840_d = null;
            String key = block.func_149739_a() + ":" + meta;
            if (isbrhExceptionCache.add((Object)key)) {
                AngelicaTweaker.LOGGER.warn("Caught an exception during ISBRH rendering for {} at position {}, {}, {} with renderer ID {}", new Object[]{block.func_149739_a(), x, y, z, modelId, e});
            }
            return false;
        }
    }

    static {
        exceptionErrorBlockMap.put(NullPointerException.class, 0);
        exceptionErrorBlockMap.put(ArrayIndexOutOfBoundsException.class, 1);
    }
}

