/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.mixins.early.angelica.bugfixes;

import com.gtnewhorizons.angelica.config.AngelicaConfig;
import com.gtnewhorizons.angelica.loading.AngelicaTweaker;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.common.util.ForgeDirection;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@Mixin(value={RenderBlocks.class})
public class MixinRenderBlocks_CrackFix {
    @Unique
    private static String[] angelica$currentCrackFixBlacklistArr;
    @Unique
    private static String[] angelica$currentCrackFixWhitelistArr;
    @Unique
    private static Class<?>[] angelica$currentCrackFixBlacklistClasses;
    @Unique
    private static Class<?>[] angelica$currentCrackFixWhitelistClasses;
    @Shadow
    public double field_147859_h;
    @Shadow
    public double field_147855_j;
    @Shadow
    public double field_147851_l;
    @Shadow
    public double field_147861_i;
    @Shadow
    public double field_147857_k;
    @Shadow
    public double field_147853_m;
    @Unique
    private double[] angelica$bounds;
    @Unique
    private boolean angelica$disableCrackFix;
    @Unique
    private boolean angelica$bypassRenderPassCheck;

    @ModifyExpressionValue(method={"renderFaceXNeg"}, at={@At(value="FIELD", target="Lnet/minecraft/client/renderer/RenderBlocks;renderMinX:D", ordinal=0)}, require=1)
    private double xNegBounds(double original) {
        this.angelica$preBounds(ForgeDirection.WEST);
        return this.field_147859_h;
    }

    @ModifyExpressionValue(method={"renderFaceXPos"}, at={@At(value="FIELD", target="Lnet/minecraft/client/renderer/RenderBlocks;renderMaxX:D", ordinal=0)}, require=1)
    private double xPosBounds(double original) {
        this.angelica$preBounds(ForgeDirection.EAST);
        return this.field_147861_i;
    }

    @ModifyExpressionValue(method={"renderFaceYNeg"}, at={@At(value="FIELD", target="Lnet/minecraft/client/renderer/RenderBlocks;renderMinX:D", ordinal=5)}, require=1)
    private double yNegBounds(double original) {
        this.angelica$preBounds(ForgeDirection.DOWN);
        return this.field_147859_h;
    }

    @ModifyExpressionValue(method={"renderFaceYPos"}, at={@At(value="FIELD", target="Lnet/minecraft/client/renderer/RenderBlocks;renderMinX:D", ordinal=5)}, require=1)
    private double yPosBounds(double original) {
        this.angelica$preBounds(ForgeDirection.UP);
        return this.field_147859_h;
    }

    @ModifyExpressionValue(method={"renderFaceZNeg"}, at={@At(value="FIELD", target="Lnet/minecraft/client/renderer/RenderBlocks;renderMinX:D", ordinal=6)}, require=1)
    private double zNegBounds(double original) {
        this.angelica$preBounds(ForgeDirection.NORTH);
        return this.field_147859_h;
    }

    @ModifyExpressionValue(method={"renderFaceZPos"}, at={@At(value="FIELD", target="Lnet/minecraft/client/renderer/RenderBlocks;renderMinX:D", ordinal=5)}, require=1)
    private double zPosBounds(double original) {
        this.angelica$preBounds(ForgeDirection.SOUTH);
        return this.field_147859_h;
    }

    @Unique
    private void angelica$preBounds(ForgeDirection skipDir) {
        if (this.angelica$crackFixOff()) {
            return;
        }
        if (this.angelica$bounds == null) {
            this.angelica$bounds = new double[6];
        }
        this.angelica$bounds[0] = this.field_147859_h;
        this.angelica$bounds[1] = this.field_147855_j;
        this.angelica$bounds[2] = this.field_147851_l;
        this.angelica$bounds[3] = this.field_147861_i;
        this.angelica$bounds[4] = this.field_147857_k;
        this.angelica$bounds[5] = this.field_147853_m;
        if (ForgeHooksClient.getWorldRenderPass() != 0 && !this.angelica$bypassRenderPassCheck) {
            return;
        }
        if (this.field_147859_h != 0.0 || this.field_147855_j != 0.0 || this.field_147851_l != 0.0 || this.field_147861_i != 1.0 || this.field_147857_k != 1.0 || this.field_147853_m != 1.0) {
            return;
        }
        double EPSILON = AngelicaConfig.blockCrackFixEpsilon;
        this.field_147859_h -= EPSILON;
        this.field_147855_j -= EPSILON;
        this.field_147851_l -= EPSILON;
        this.field_147861_i += EPSILON;
        this.field_147857_k += EPSILON;
        this.field_147853_m += EPSILON;
        switch (skipDir) {
            case WEST: {
                this.field_147859_h = this.angelica$bounds[0];
                break;
            }
            case DOWN: {
                this.field_147855_j = this.angelica$bounds[1];
                break;
            }
            case NORTH: {
                this.field_147851_l = this.angelica$bounds[2];
                break;
            }
            case EAST: {
                this.field_147861_i = this.angelica$bounds[3];
                break;
            }
            case UP: {
                this.field_147857_k = this.angelica$bounds[4];
                break;
            }
            case SOUTH: {
                this.field_147853_m = this.angelica$bounds[5];
            }
        }
    }

    @Inject(method={"renderFaceXNeg", "renderFaceXPos", "renderFaceYNeg", "renderFaceYPos", "renderFaceZNeg", "renderFaceZPos"}, at={@At(value="RETURN")}, require=6)
    private void postBounds(Block p_147798_1_, double p_147798_2_, double p_147798_4_, double p_147798_6_, IIcon p_147798_8_, CallbackInfo ci) {
        if (this.angelica$crackFixOff() || this.angelica$bounds == null) {
            return;
        }
        this.field_147859_h = this.angelica$bounds[0];
        this.field_147855_j = this.angelica$bounds[1];
        this.field_147851_l = this.angelica$bounds[2];
        this.field_147861_i = this.angelica$bounds[3];
        this.field_147857_k = this.angelica$bounds[4];
        this.field_147853_m = this.angelica$bounds[5];
    }

    @Inject(method={"renderBlockByRenderType"}, at={@At(value="HEAD")}, require=1)
    private void exclusion(Block block, int x, int y, int z, CallbackInfoReturnable<Boolean> cir) {
        this.angelica$disableCrackFix = MixinRenderBlocks_CrackFix.angelica$isListed(block.getClass(), false);
        this.angelica$bypassRenderPassCheck = MixinRenderBlocks_CrackFix.angelica$isListed(block.getClass(), true);
    }

    @Inject(method={"renderBlockByRenderType"}, at={@At(value="RETURN")}, require=1)
    private void endExclusion(Block p_147805_1_, int p_147805_2_, int p_147805_3_, int p_147805_4_, CallbackInfoReturnable<Boolean> cir) {
        this.angelica$disableCrackFix = false;
        this.angelica$bypassRenderPassCheck = false;
    }

    @Unique
    private static boolean angelica$isListed(Class<?> clazz, boolean whitelist) {
        Class<?>[] list;
        Class<?>[] classArray = list = whitelist ? MixinRenderBlocks_CrackFix.angelica$getCrackFixRenderPassWhitelist() : MixinRenderBlocks_CrackFix.angelica$getCrackFixBlacklist();
        if (list == null) {
            return false;
        }
        for (Class<?> element : list) {
            if (!element.isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }

    @Unique
    private static Class<?>[] angelica$getCrackFixBlacklist() {
        if (angelica$currentCrackFixBlacklistArr != AngelicaConfig.blockCrackFixBlacklist) {
            angelica$currentCrackFixBlacklistArr = AngelicaConfig.blockCrackFixBlacklist;
            angelica$currentCrackFixBlacklistClasses = (Class[])Arrays.stream(angelica$currentCrackFixBlacklistArr).map(name -> {
                try {
                    return Class.forName(name);
                }
                catch (ClassNotFoundException e) {
                    AngelicaTweaker.LOGGER.debug("Could not find class " + name + " for crack fix blacklist!");
                    return null;
                }
            }).filter(Objects::nonNull).toArray(Class[]::new);
        }
        return angelica$currentCrackFixBlacklistClasses;
    }

    @Unique
    private static Class<?>[] angelica$getCrackFixRenderPassWhitelist() {
        if (angelica$currentCrackFixWhitelistArr != AngelicaConfig.blockCrackFixRenderPassWhitelist__) {
            angelica$currentCrackFixWhitelistArr = AngelicaConfig.blockCrackFixRenderPassWhitelist__;
            angelica$currentCrackFixWhitelistClasses = (Class[])Arrays.stream(angelica$currentCrackFixWhitelistArr).map(name -> {
                try {
                    return Class.forName(name);
                }
                catch (ClassNotFoundException e) {
                    AngelicaTweaker.LOGGER.debug("Could not find class " + name + " for crack fix whitelist!");
                    return null;
                }
            }).filter(Objects::nonNull).toArray(Class[]::new);
        }
        return angelica$currentCrackFixWhitelistClasses;
    }

    @Unique
    private boolean angelica$crackFixOff() {
        return !AngelicaConfig.fixBlockCrack || this.angelica$disableCrackFix;
    }
}

