/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.mixins.early.angelica.archaic;

import com.gtnewhorizons.angelica.config.AngelicaConfig;
import com.gtnewhorizons.angelica.mixins.early.angelica.archaic.AccessorSplashProgress;
import cpw.mods.fml.client.SplashProgress;
import org.apache.commons.lang3.StringUtils;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@Mixin(targets={"cpw/mods/fml/client/SplashProgress$3"})
public class MixinSplashProgress$3 {
    private static final int MEMORY_GOOD_COLOR = 7916340;
    private static final int MEMORY_WARN_COLOR = 15132746;
    private static final int MEMORY_LOW_COLOR = 14954287;
    private static float memoryColorPercent;
    private static long memoryColorChangeTime;
    @Unique
    private static Boolean angelica$isArchaicFixPresent;
    @Final
    @Shadow(remap=false)
    private int barWidth;
    @Final
    @Shadow(remap=false)
    private int barHeight;
    @Final
    @Shadow(remap=false)
    private int textHeight2;

    @Inject(method={"run"}, at={@At(value="INVOKE", target="Lorg/lwjgl/opengl/GL11;glDisable(I)V", ordinal=1, remap=false, shift=At.Shift.AFTER)}, remap=false, require=0)
    private void injectDrawMemoryBar(CallbackInfo ci) {
        if (angelica$isArchaicFixPresent == null) {
            try {
                Class.forName("org.embeddedt.archaicfix.ArchaicCore");
                angelica$isArchaicFixPresent = true;
            }
            catch (Exception e) {
                angelica$isArchaicFixPresent = false;
            }
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(320 - Display.getWidth() / 2 + 4), (float)(240 + Display.getHeight() / 2 - this.textHeight2), (float)0.0f);
        GL11.glScalef((float)2.0f, (float)2.0f, (float)1.0f);
        GL11.glEnable((int)3553);
        AccessorSplashProgress.getFontRenderer().func_78276_b("Angelica 2.0.0-alpha20", 0, angelica$isArchaicFixPresent != false ? -10 : 0, 0);
        GL11.glDisable((int)3553);
        GL11.glPopMatrix();
        if (AngelicaConfig.showSplashMemoryBar) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)(320.0f - (float)this.barWidth / 2.0f), (float)20.0f, (float)0.0f);
            this.drawMemoryBar();
            GL11.glPopMatrix();
        }
    }

    @Shadow(remap=false)
    private void setColor(int color) {
    }

    @Shadow(remap=false)
    private void drawBox(int w, int h) {
    }

    private void drawMemoryBar() {
        int maxMemory = MixinSplashProgress$3.bytesToMb(Runtime.getRuntime().maxMemory());
        int totalMemory = MixinSplashProgress$3.bytesToMb(Runtime.getRuntime().totalMemory());
        int freeMemory = MixinSplashProgress$3.bytesToMb(Runtime.getRuntime().freeMemory());
        int usedMemory = totalMemory - freeMemory;
        float usedMemoryPercent = (float)usedMemory / (float)maxMemory;
        SplashProgress.SplashFontRenderer fontRenderer = AccessorSplashProgress.getFontRenderer();
        GL11.glPushMatrix();
        this.setColor(AccessorSplashProgress.getFontColor());
        GL11.glScalef((float)2.0f, (float)2.0f, (float)1.0f);
        GL11.glEnable((int)3553);
        fontRenderer.func_78276_b("Memory Used / Total", 0, 0, 0);
        GL11.glDisable((int)3553);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)this.textHeight2, (float)0.0f);
        this.setColor(AccessorSplashProgress.getBarBorderColor());
        this.drawBox(this.barWidth, this.barHeight);
        this.setColor(AccessorSplashProgress.getBarBackgroundColor());
        GL11.glTranslatef((float)1.0f, (float)1.0f, (float)0.0f);
        this.drawBox(this.barWidth - 2, this.barHeight - 2);
        long time = System.currentTimeMillis();
        if (usedMemoryPercent > memoryColorPercent || time - memoryColorChangeTime > 1000L) {
            memoryColorChangeTime = time;
            memoryColorPercent = usedMemoryPercent;
        }
        int memoryBarColor = memoryColorPercent < 0.75f ? 7916340 : (memoryColorPercent < 0.85f ? 15132746 : 14954287);
        this.setColor(14954287);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((this.barWidth - 2) * totalMemory / maxMemory - 2), (float)0.0f, (float)0.0f);
        this.drawBox(2, this.barHeight - 2);
        GL11.glPopMatrix();
        this.setColor(memoryBarColor);
        this.drawBox((this.barWidth - 2) * usedMemory / maxMemory, this.barHeight - 2);
        String progress = this.getMemoryString(usedMemory) + " / " + this.getMemoryString(maxMemory);
        GL11.glTranslatef((float)(((float)this.barWidth - 2.0f) / 2.0f - (float)fontRenderer.func_78256_a(progress)), (float)2.0f, (float)0.0f);
        this.setColor(AccessorSplashProgress.getFontColor());
        GL11.glScalef((float)2.0f, (float)2.0f, (float)1.0f);
        GL11.glEnable((int)3553);
        fontRenderer.func_78276_b(progress, 0, 0, 0);
        GL11.glPopMatrix();
    }

    private String getMemoryString(int memory) {
        return StringUtils.leftPad((String)Integer.toString(memory), (int)4, (char)' ') + " MB";
    }

    private static int bytesToMb(long bytes) {
        return (int)(bytes / 1024L / 1024L);
    }

    static {
        angelica$isArchaicFixPresent = null;
    }
}

