/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.mixins;

import com.gtnewhorizon.gtnhmixins.builders.IBaseTransformer;
import com.gtnewhorizon.gtnhmixins.builders.IMixins;
import com.gtnewhorizon.gtnhmixins.builders.ITargetMod;
import com.gtnewhorizon.gtnhmixins.builders.MixinBuilder;
import com.gtnewhorizons.angelica.AngelicaMod;
import com.gtnewhorizons.angelica.config.AngelicaConfig;
import com.gtnewhorizons.angelica.config.CompatConfig;
import com.gtnewhorizons.angelica.mixins.TargetedMod;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import jss.notfine.config.MCPatcherForgeConfig;
import jss.notfine.config.NotFineConfig;
import lombok.Generated;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public enum Mixins implements IMixins
{
    ANGELICA_STARTUP(new MixinBuilder().setPhase(IBaseTransformer.Phase.EARLY).addClientMixins(new String[]{"angelica.startup.MixinInitGLStateManager"})),
    ANGELICA(new MixinBuilder().setPhase(IBaseTransformer.Phase.EARLY).addClientMixins(new String[]{"angelica.MixinActiveRenderInfo", "angelica.MixinEntityRenderer", "angelica.MixinGameSettings", "angelica.MixinMinecraft", "angelica.MixinMinecraftServer", "angelica.optimizations.MixinRendererLivingEntity", "angelica.MixinFMLClientHandler", "angelica.bugfixes.MixinRenderGlobal_DestroyBlock", "angelica.glsm.MixinSplashProgressCaching", "angelica.debug.MixinMinecraft_FPSCap"})),
    ANGELICA_VBO_CLOUDS(new MixinBuilder().setApplyIf(() -> AngelicaConfig.enableVBOClouds).setPhase(IBaseTransformer.Phase.EARLY).addClientMixins(new String[]{"angelica.vbo.MixinRenderGlobal"})),
    ANGELICA_FONT_RENDERER(new MixinBuilder().setPhase(IBaseTransformer.Phase.EARLY).setApplyIf(() -> AngelicaConfig.enableFontRenderer).addClientMixins(new String[]{"angelica.fontrenderer.MixinGuiIngameForge", "angelica.fontrenderer.MixinFontRenderer", "angelica.fontrenderer.MixinMCResourceAccessor"})),
    ANGELICA_ENABLE_DEBUG(new MixinBuilder().setPhase(IBaseTransformer.Phase.EARLY).setApplyIf(() -> AngelicaMod.lwjglDebug).addClientMixins(new String[]{"angelica.debug.MixinProfiler", "angelica.debug.MixinSplashProgress", "angelica.debug.MixinTextureManager"})),
    ANGELICA_DYNAMIC_LIGHTS(new MixinBuilder().setPhase(IBaseTransformer.Phase.EARLY).setApplyIf(() -> AngelicaConfig.enableDynamicLights).addClientMixins(new String[]{"angelica.dynamiclights.MixinEntityRenderer", "angelica.dynamiclights.MixinEntity", "angelica.dynamiclights.MixinWorld", "angelica.dynamiclights.MixinItemRenderer", "angelica.dynamiclights.MixinEntityCreeper", "angelica.dynamiclights.MixinEntityTNTPrimed"})),
    ANGELICA_FIX_BLOCK_CRACK(new MixinBuilder("Block corners and edges between chunks might have \"cracks\" in them. This option fixes it").setPhase(IBaseTransformer.Phase.EARLY).addClientMixins(new String[]{"angelica.bugfixes.MixinRenderBlocks_CrackFix"}).addExcludedMod((ITargetMod)TargetedMod.FALSETWEAKS).setApplyIf(() -> AngelicaConfig.fixBlockCrack)),
    ANGELICA_FIX_FLUID_RENDERER_CHECKING_BLOCK_AGAIN(new MixinBuilder("Fix RenderBlockFluid reading the block type from the world access multiple times").setPhase(IBaseTransformer.Phase.EARLY).addClientMixins(new String[]{"angelica.bugfixes.MixinRenderBlockFluid"}).setApplyIf(() -> AngelicaConfig.fixFluidRendererCheckingBlockAgain)),
    ANGELICA_LIMIT_DROPPED_ITEM_ENTITIES(new MixinBuilder().setPhase(IBaseTransformer.Phase.EARLY).addClientMixins(new String[]{"angelica.optimizations.MixinRenderGlobal_ItemRenderDist"}).setApplyIf(() -> AngelicaConfig.dynamicItemRenderDistance)),
    ANGELICA_ITEM_RENDERER_OPTIMIZATION(new MixinBuilder("Optimizes in-world item rendering").setPhase(IBaseTransformer.Phase.EARLY).addClientMixins(new String[]{"angelica.itemrenderer.MixinItemRenderer"}).setApplyIf(() -> AngelicaConfig.optimizeInWorldItemRendering)),
    ANGELICA_OPTIMIZE_GLALLOCATION(new MixinBuilder("Replace HashMap with fastutil Int2IntMap in GLAllocation").setPhase(IBaseTransformer.Phase.EARLY).addClientMixins(new String[]{"angelica.optimizations.MixinGLAllocation"})),
    ARCHAIC_SPLASH(new MixinBuilder().setPhase(IBaseTransformer.Phase.EARLY).setApplyIf(() -> AngelicaConfig.showSplashMemoryBar && !AngelicaMod.lwjglDebug).addClientMixins(new String[]{"angelica.archaic.MixinSplashProgress$3", "angelica.archaic.AccessorSplashProgress"})),
    ARCHAIC_CORE(new MixinBuilder().addExcludedMod((ITargetMod)TargetedMod.ARCHAICFIX).setPhase(IBaseTransformer.Phase.EARLY).addClientMixins(new String[]{"angelica.archaic.MixinBlockFence", "angelica.archaic.MixinFMLClientHandler", "angelica.archaic.MixinGuiIngameForge", "angelica.archaic.MixinNetHandlerPlayClient", "angelica.archaic.MixinThreadDownloadImageData"})),
    IRIS_STARTUP(new MixinBuilder().setPhase(IBaseTransformer.Phase.EARLY).setApplyIf(() -> AngelicaConfig.enableIris).addClientMixins(new String[]{"shaders.startup.MixinGameSettings", "shaders.startup.MixinMinecraft", "shaders.startup.MixinInitRenderer", "shaders.startup.MixinAbstractTexture", "shaders.startup.MixinTextureAtlasSprite", "shaders.startup.MixinTextureMap"})),
    RENDERING_INFRASTRUCTURE(new MixinBuilder().setPhase(IBaseTransformer.Phase.EARLY).setApplyIf(() -> AngelicaConfig.enableCeleritas).addClientMixins(new String[]{"rendering.MixinBlock", "rendering.MixinBlockFluidBase", "rendering.AccessorBiomeColorEvent", "rendering.MixinBiomeGenBase", "rendering.MixinChunk", "rendering.MixinChunkProviderServer", "rendering.MixinClientRegistry", "rendering.MixinEntity_RenderDist", "rendering.MixinEntityItem_RenderDist", "rendering.MixinEntityRenderer", "rendering.MixinFMLClientHandler", "rendering.MixinGameSettings", "rendering.MixinLongHashMap", "rendering.MixinMinecraft", "rendering.MixinPlayerManager", "rendering.MixinRenderBlocks", "rendering.MixinRenderingRegistry", "rendering.MixinTileEntity", "rendering.MixinTileEntityMobSpawner", "rendering.MixinTileEntityRendererDispatcher"})),
    CELERITAS(new MixinBuilder().setPhase(IBaseTransformer.Phase.EARLY).setApplyIf(() -> AngelicaConfig.enableCeleritas).addClientMixins(new String[]{"celeritas.terrain.ChunkTrackerAccessor", "celeritas.terrain.MixinChunkProviderClient", "celeritas.terrain.MixinMinecraft_ChunkUpdates", "celeritas.terrain.MixinRenderGlobal", "celeritas.terrain.MixinRenderSectionManager", "celeritas.terrain.MixinWorldClient", "celeritas.frustum.MixinFrustrum", "celeritas.features.culling.MixinEffectRenderer", "celeritas.features.mipmaps.MixinTextureAtlasSprite", "celeritas.features.mipmaps.MixinTextureUtil", "celeritas.features.textures.MixinTextureMap", "celeritas.features.textures.MixinTextureAtlasSprite", "celeritas.biome_blending.MixinBlockGrass", "celeritas.biome_blending.MixinBlockLeaves", "celeritas.biome_blending.MixinBlockLiquid", "celeritas.threading.MixinForgeHooksClient", "celeritas.terrain.MixinChunk"})),
    IRIS_SHADERS(new MixinBuilder().setPhase(IBaseTransformer.Phase.EARLY).setApplyIf(() -> AngelicaConfig.enableIris).addClientMixins(new String[]{"shaders.MixinDroppedItemGlintEdges", "shaders.MixinEntityPickupFX", "shaders.MixinEntityRenderer", "shaders.MixinGuiIngameForge", "shaders.MixinFramebuffer", "shaders.MixinItem", "shaders.MixinLocale", "shaders.MixinRender", "shaders.MixinRenderBiped", "shaders.MixinRenderDragon", "shaders.MixinRenderEntityFlame", "shaders.MixinRendererLivingEntity", "shaders.MixinRenderGlobal", "shaders.MixinRenderHorse", "shaders.MixinRenderItem", "shaders.MixinRenderManager", "shaders.MixinRenderNameTag", "shaders.MixinRenderPlayerArmor", "shaders.MixinTileEntityBeaconRenderer", "shaders.MixinRenderEndPortal", "shaders.MixinTileEntityRendererDispatcher"})),
    IRIS_RENDERING_NOBACKHAND(new MixinBuilder("Iris Hand Shaders").setPhase(IBaseTransformer.Phase.EARLY).setApplyIf(() -> AngelicaConfig.enableIris).addExcludedMod((ITargetMod)TargetedMod.BACKHAND).addClientMixins(new String[]{"shaders.MixinItemRenderer"})),
    IRIS_RENDERING_BACKHAND(new MixinBuilder("Iris Hand Shaders (Backhand)").addRequiredMod((ITargetMod)TargetedMod.BACKHAND).setPhase(IBaseTransformer.Phase.EARLY).setApplyIf(() -> AngelicaConfig.enableIris).addClientMixins(new String[]{"shaders.MixinItemRendererBackhand"})),
    ANGELICA_TEXTURE(new MixinBuilder().setPhase(IBaseTransformer.Phase.EARLY).setApplyIf(() -> AngelicaConfig.enableIris || AngelicaConfig.enableCeleritas).addClientMixins(new String[]{"angelica.textures.MixinTextureAtlasSprite", "angelica.textures.MixinTextureUtil"})),
    ANGELICA_ZOOM(new MixinBuilder().setPhase(IBaseTransformer.Phase.EARLY).setApplyIf(() -> AngelicaConfig.enableZoom).addClientMixins(new String[]{"angelica.zoom.MixinEntityRenderer_Zoom", "angelica.zoom.MixinMinecraft_Zoom", "angelica.zoom.MixinMouseFilter"})),
    HUD_CACHING(new MixinBuilder().setPhase(IBaseTransformer.Phase.EARLY).setApplyIf(() -> AngelicaConfig.enableHudCaching).addClientMixins(new String[]{"angelica.hudcaching.MixinGuiIngame", "angelica.hudcaching.MixinGuiIngameForge", "angelica.hudcaching.MixinRenderGameOverlayEvent", "angelica.hudcaching.MixinEntityRenderer_HUDCaching", "angelica.hudcaching.MixinFramebuffer_HUDCaching", "angelica.hudcaching.MixinGuiIngame_HUDCaching", "angelica.hudcaching.MixinGuiIngameForge_HUDCaching", "angelica.hudcaching.MixinRenderItem"})),
    OPTIMIZE_WORLD_UPDATE_LIGHT(new MixinBuilder().setPhase(IBaseTransformer.Phase.EARLY).addExcludedMod((ITargetMod)TargetedMod.ARCHAICFIX).setApplyIf(() -> AngelicaConfig.optimizeWorldUpdateLight).addCommonMixins(new String[]{"angelica.lighting.MixinWorld_FixLightUpdateLag"})),
    SPEEDUP_VANILLA_ANIMATIONS(new MixinBuilder().setPhase(IBaseTransformer.Phase.EARLY).setApplyIf(() -> AngelicaConfig.speedupAnimations).addClientMixins(new String[]{"angelica.animation.MixinTextureAtlasSprite", "angelica.animation.MixinTextureMap", "angelica.animation.MixinChunkCache", "angelica.animation.MixinRenderBlocks"})),
    SCALED_RESOUTION_UNICODE_FIX(new MixinBuilder("Removes unicode languages gui scaling being forced to even values").setPhase(IBaseTransformer.Phase.EARLY).setApplyIf(() -> AngelicaConfig.removeUnicodeEvenScaling).addClientMixins(new String[]{"angelica.bugfixes.MixinScaledResolution_UnicodeFix"})),
    SECURITYCRAFT_COMPAT(new MixinBuilder("Fix reflection in SecurityCraft for compat with Angelica").setPhase(IBaseTransformer.Phase.LATE).addRequiredMod((ITargetMod)TargetedMod.SECURITYCRAFT).setApplyIf(() -> CompatConfig.fixSecurityCraft).addClientMixins(new String[]{"client.securitycraft.MixinBlockReinforcedFenceGate", "client.securitycraft.MixinBlockReinforcedIronBars"})),
    EXTRA_UTILITIES_THREAD_SAFETY(new MixinBuilder("Enable thread safety fixes in Extra Utilities").setPhase(IBaseTransformer.Phase.LATE).addRequiredMod((ITargetMod)TargetedMod.EXTRAUTILS).setApplyIf(() -> CompatConfig.fixExtraUtils).addClientMixins(new String[]{"client.extrautils.MixinRenderBlockConnectedTextures", "client.extrautils.MixinRenderBlockConnectedTexturesEthereal", "client.extrautils.MixinIconConnectedTexture"})),
    MFR_THREAD_SAFETY(new MixinBuilder("Enable thread safety fixes for MineFactory Reloaded").setPhase(IBaseTransformer.Phase.LATE).addRequiredMod((ITargetMod)TargetedMod.MINEFACTORY_RELOADED).setApplyIf(() -> CompatConfig.fixMinefactoryReloaded).addClientMixins(new String[]{"client.minefactoryreloaded.MixinRedNetCableRenderer"})),
    NTM_SPACE_TWEAKS(new MixinBuilder("Support for 'Disable Horizon' & 'disableAltitudePlanetRenderer' options in NTM:Space").setPhase(IBaseTransformer.Phase.LATE).addRequiredMod((ITargetMod)TargetedMod.NTM_SPACE).setApplyIf(() -> CompatConfig.tweakNTMSpace).addClientMixins(new String[]{"client.ntmSpace.MixinSkyProviderCelestial_Tweaks"})),
    NTM_SPACE_SHADER_COMPAT(new MixinBuilder("Multiple shader fixes for NTM:Space").setPhase(IBaseTransformer.Phase.LATE).addRequiredMod((ITargetMod)TargetedMod.NTM_SPACE).setApplyIf(() -> CompatConfig.fixNTMSpace && AngelicaConfig.enableIris).addClientMixins(new String[]{"client.ntmSpace.MixinSkyProviderCelestial_ShaderCompat", "client.ntmSpace.MixinSkyProviderLaytheSunset"})),
    SPEEDUP_CAMPFIRE_BACKPORT_ANIMATIONS(new MixinBuilder("Add animation speedup support to Campfire Backport").setPhase(IBaseTransformer.Phase.LATE).addRequiredMod((ITargetMod)TargetedMod.CAMPFIRE_BACKPORT).setApplyIf(() -> AngelicaConfig.speedupAnimations).addClientMixins(new String[]{"client.campfirebackport.MixinRenderBlockCampfire"})),
    IC2_FLUID_RENDER_FIX(new MixinBuilder().setPhase(IBaseTransformer.Phase.EARLY).addRequiredMod((ITargetMod)TargetedMod.IC2).setApplyIf(() -> AngelicaConfig.speedupAnimations).addClientMixins(new String[]{"angelica.textures.ic2.MixinRenderLiquidCell"})),
    OPTIMIZE_TEXTURE_LOADING(new MixinBuilder().setPhase(IBaseTransformer.Phase.EARLY).addClientMixins(new String[]{"angelica.textures.MixinTextureUtil_OptimizeMipmap"}).setApplyIf(() -> AngelicaConfig.optimizeTextureLoading)),
    NOTFINE_BASE_MOD(new MixinBuilder().setPhase(IBaseTransformer.Phase.EARLY).setApplyIf(() -> AngelicaConfig.enableNotFineFeatures).addClientMixins(Mixins.addPrefix("notfine.", "clouds.MixinEntityRenderer", "clouds.MixinGameSettings", "clouds.MixinWorldType", "fix.MixinRenderItem", "gui.MixinGuiSlot", "glint.MixinRenderBiped", "glint.MixinRenderPlayer", "optimization.MixinRenderItemFrame", "leaves.MixinBlockLeaves", "leaves.MixinBlockLeavesBase", "particles.MixinBlockEnchantmentTable", "particles.MixinEffectRenderer", "particles.MixinWorldClient", "renderer.MixinRenderGlobal", "toggle.MixinEntityRenderer", "toggle.MixinGuiIngame", "toggle.MixinRender", "toggle.MixinRenderItem", "interpolatedtexturemap.MixinTextureMap"))),
    BETTER_FACE_CULLING(new MixinBuilder().setPhase(IBaseTransformer.Phase.EARLY).setApplyIf(() -> NotFineConfig.betterBlockFaceCulling).addClientMixins(Mixins.addPrefix("notfine.faceculling.", "MixinBlock", "MixinBlockCactus", "MixinBlockCarpet", "MixinBlockEnchantmentTable", "MixinBlockFarmland", "MixinBlockSlab", "MixinBlockSnow", "MixinBlockStairs", "MixinRenderBlocks"))),
    NOTFINE_NO_DYNAMIC_SURROUNDINGS(new MixinBuilder().setPhase(IBaseTransformer.Phase.EARLY).addExcludedMod((ITargetMod)TargetedMod.DYNAMIC_SURROUNDINGS_MIST).addExcludedMod((ITargetMod)TargetedMod.DYNAMIC_SURROUNDINGS_ORIGINAL).addClientMixins(new String[]{"notfine.toggle.MixinEntityRenderer$RenderRainSnow"})),
    NOTFINE_NO_CUSTOM_ITEM_TEXTURES(new MixinBuilder().setPhase(IBaseTransformer.Phase.EARLY).addExcludedMod((ITargetMod)TargetedMod.DRAGON_API).setApplyIf(() -> !AngelicaConfig.enableMCPatcherForgeFeatures || !MCPatcherForgeConfig.CustomItemTextures.enabled).addClientMixins(Mixins.addPrefix("notfine.glint.", "MixinItemRenderer", "MixinRenderItem"))),
    NOTFINE_NATURA_COMPAT(new MixinBuilder().setPhase(IBaseTransformer.Phase.LATE).setApplyIf(() -> AngelicaConfig.enableNotFineFeatures).addRequiredMod((ITargetMod)TargetedMod.NATURA).addClientMixins(Mixins.addPrefix("notfine.leaves.natura.", "MixinBerryBush", "MixinNetherBerryBush"))),
    NOTFINE_THAUMCRAFT_COMPAT(new MixinBuilder().setPhase(IBaseTransformer.Phase.LATE).setApplyIf(() -> AngelicaConfig.enableNotFineFeatures).addRequiredMod((ITargetMod)TargetedMod.THAUMCRAFT).addClientMixins(new String[]{"notfine.leaves.thaumcraft.MixinBlockMagicalLeaves"})),
    THAUMCRAFT_BETTER_FACE_CULLING(new MixinBuilder().setPhase(IBaseTransformer.Phase.LATE).setApplyIf(() -> NotFineConfig.betterBlockFaceCulling).addRequiredMod((ITargetMod)TargetedMod.THAUMCRAFT).addClientMixins(Mixins.addPrefix("notfine.faceculling.thaumcraft.", "MixinBlockWoodenDevice", "MixinBlockStoneDevice", "MixinBlockTable"))),
    NOTFINE_TINKERS_CONSTRUCT_COMPAT(new MixinBuilder().setPhase(IBaseTransformer.Phase.LATE).setApplyIf(() -> AngelicaConfig.enableNotFineFeatures).addRequiredMod((ITargetMod)TargetedMod.TINKERS_CONSTRUCT).addClientMixins(new String[]{"notfine.leaves.tconstruct.MixinOreberryBush"})),
    NOTFINE_WITCHERY_COMPAT(new MixinBuilder().setPhase(IBaseTransformer.Phase.LATE).setApplyIf(() -> AngelicaConfig.enableNotFineFeatures).addRequiredMod((ITargetMod)TargetedMod.WITCHERY).addClientMixins(new String[]{"notfine.leaves.witchery.MixinBlockWitchLeaves"})),
    NOTFINE_TWILIGHT_FOREST_COMPAT(new MixinBuilder().setPhase(IBaseTransformer.Phase.LATE).setApplyIf(() -> AngelicaConfig.enableNotFineFeatures).addRequiredMod((ITargetMod)TargetedMod.TWILIGHT_FOREST).addClientMixins(Mixins.addPrefix("notfine.leaves.twilightforest.", "MixinBlockTFLeaves", "MixinBlockTFLeaves3", "MixinBlockTFMagicLeaves"))),
    ET_FUTURUM_ELYTRA_CAPE(new MixinBuilder("Set custom item ID for elytra with cape texture").setPhase(IBaseTransformer.Phase.LATE).addRequiredMod((ITargetMod)TargetedMod.ET_FUTURUM_REQUIEM).setApplyIf(() -> AngelicaConfig.enableIris).addClientMixins(new String[]{"client.etfuturum.MixinLayerBetterElytra"})),
    MCPATCHER_FORGE(new MixinBuilder().setPhase(IBaseTransformer.Phase.EARLY).setApplyIf(() -> AngelicaConfig.enableMCPatcherForgeFeatures).addClientMixins(Mixins.addPrefix("mcpatcherforge.", "base.MixinBlockGrass", "base.MixinBlockMycelium", "base.MixinAbstractTexture", "base.MixinTextureAtlasSprite", "base.MixinSimpleReloadableResourceManager", "base.MixinMinecraft"))),
    MCPATCHER_FORGE_RENDERPASS_BASE(new MixinBuilder().setPhase(IBaseTransformer.Phase.EARLY).setApplyIf(() -> NotFineConfig.renderPass).addClientMixins(Mixins.addPrefix("mcpatcherforge.renderpass.", "MixinEntityRenderer", "MixinRenderBlocks", "MixinWorldRenderer"))),
    MCPATCHER_FORGE_RENDERPASS_DISPLAYLIST(new MixinBuilder("RenderPass display list allocation increase").setPhase(IBaseTransformer.Phase.EARLY).setApplyIf(() -> NotFineConfig.renderPass && !AngelicaConfig.enableCeleritas).addClientMixins(new String[]{"mcpatcherforge.renderpass.MixinRenderGlobal_DisplayLists"})),
    MCPATCHER_FORGE_RENDERPASS_FEATURES(new MixinBuilder("RenderPass rendering features").setPhase(IBaseTransformer.Phase.EARLY).setApplyIf(() -> NotFineConfig.renderPass && !AngelicaConfig.enableCeleritas).addClientMixins(new String[]{"mcpatcherforge.renderpass.MixinRenderGlobal_Features"})),
    MCPATCHER_FORGE_CUSTOM_COLORS(new MixinBuilder().setPhase(IBaseTransformer.Phase.EARLY).setApplyIf(() -> AngelicaConfig.enableMCPatcherForgeFeatures && MCPatcherForgeConfig.CustomColors.enabled).addClientMixins(Mixins.addPrefix("mcpatcherforge.cc.", "block.material.MixinMapColor", "block.MixinBlock", "block.MixinBlockDoublePlant", "block.MixinBlockGrass", "block.MixinBlockLeaves", "block.MixinBlockLilyPad", "block.MixinBlockLiquid", "block.MixinBlockOldLeaf", "block.MixinBlockRedstoneWire", "block.MixinBlockReed", "block.MixinBlockStem", "block.MixinBlockTallGrass", "block.MixinBlockVine", "client.particle.MixinEntityAuraFX", "client.particle.MixinEntityBubbleFX", "client.particle.MixinEntityDropParticleFX", "client.particle.MixinEntityPortalFX", "client.particle.MixinEntityRainFX", "client.particle.MixinEntityRedDustFX", "client.particle.MixinEntitySplashFX", "client.particle.MixinEntitySuspendFX", "client.renderer.entity.MixinRenderWolf", "client.renderer.entity.MixinRenderXPOrb", "client.renderer.tileentity.MixinTileEntitySignRenderer", "client.renderer.MixinEntityRenderer", "client.renderer.MixinItemRenderer", "client.renderer.MixinRenderBlocks", "client.renderer.MixinRenderGlobal", "entity.MixinEntityList", "item.crafting.MixinRecipesArmorDyes", "item.MixinItemArmor", "item.MixinItemBlock", "item.MixinItemMonsterPlacer", "potion.MixinPotion", "potion.MixinPotionHelper", "world.MixinWorld", "world.MixinWorldProvider", "world.MixinWorldProviderEnd", "world.MixinWorldProviderHell"))),
    MCPATCHER_FORGE_CUSTOM_ITEM_TEXTURES(new MixinBuilder().setPhase(IBaseTransformer.Phase.EARLY).addExcludedMod((ITargetMod)TargetedMod.DRAGON_API).setApplyIf(() -> AngelicaConfig.enableMCPatcherForgeFeatures && MCPatcherForgeConfig.CustomItemTextures.enabled).addClientMixins(Mixins.addPrefix("mcpatcherforge.cit.", "client.renderer.entity.MixinRenderBiped", "client.renderer.entity.MixinRenderEntityLiving", "client.renderer.entity.MixinRenderItem", "client.renderer.entity.MixinRenderPlayer", "client.renderer.entity.MixinRenderSnowball", "client.renderer.MixinItemRenderer", "client.renderer.MixinRenderGlobal", "entity.MixinEntityLivingBase", "item.MixinItem", "nbt.MixinNBTTagCompound", "nbt.MixinNBTTagList", "world.MixinWorld"))),
    MCPATCHER_FORGE_CONNECTED_TEXTURES(new MixinBuilder().setPhase(IBaseTransformer.Phase.EARLY).setApplyIf(() -> AngelicaConfig.enableMCPatcherForgeFeatures && MCPatcherForgeConfig.ConnectedTextures.enabled).addClientMixins(new String[]{"mcpatcherforge.ctm.MixinRenderBlocks"})),
    MCPATCHER_FORGE_EXTENDED_HD(new MixinBuilder().setPhase(IBaseTransformer.Phase.EARLY).setApplyIf(() -> AngelicaConfig.enableMCPatcherForgeFeatures && MCPatcherForgeConfig.ExtendedHD.enabled).addClientMixins(Mixins.addPrefix("mcpatcherforge.hd.", "MixinTextureClock", "MixinTextureCompass", "MixinTextureManager"))),
    MCPATCHER_FORGE_EXTENDED_HD_FONT(new MixinBuilder().setPhase(IBaseTransformer.Phase.EARLY).setApplyIf(() -> AngelicaConfig.enableMCPatcherForgeFeatures && MCPatcherForgeConfig.ExtendedHD.enabled && MCPatcherForgeConfig.ExtendedHD.hdFont).addExcludedMod((ITargetMod)TargetedMod.COFHCORE).addClientMixins(new String[]{"mcpatcherforge.hd.MixinFontRenderer"})),
    MCPATCHER_FORGE_RANDOM_MOBS(new MixinBuilder().setPhase(IBaseTransformer.Phase.EARLY).setApplyIf(() -> AngelicaConfig.enableMCPatcherForgeFeatures && MCPatcherForgeConfig.RandomMobs.enabled).addClientMixins(Mixins.addPrefix("mcpatcherforge.mob.", "MixinRender", "MixinRenderEnderman", "MixinRenderFish", "MixinRenderLiving", "MixinRenderMooshroom", "MixinRenderSheep", "MixinRenderSnowMan", "MixinRenderSpider", "MixinRenderWolf", "MixinEntityLivingBase"))),
    MCPATCHER_FORGE_SKY(new MixinBuilder().setPhase(IBaseTransformer.Phase.EARLY).setApplyIf(() -> AngelicaConfig.enableMCPatcherForgeFeatures && MCPatcherForgeConfig.BetterSkies.enabled).addClientMixins(Mixins.addPrefix("mcpatcherforge.sky.", "MixinEffectRenderer", "MixinRenderGlobal"))),
    MCPATCHER_FORGE_CC_NO_CTM(new MixinBuilder("MCP:F Custom Colors, no Connected Textures").setPhase(IBaseTransformer.Phase.EARLY).setApplyIf(() -> AngelicaConfig.enableMCPatcherForgeFeatures && !MCPatcherForgeConfig.ConnectedTextures.enabled && MCPatcherForgeConfig.CustomColors.enabled).addClientMixins(new String[]{"mcpatcherforge.ctm_cc.MixinRenderBlocksNoCTM"})),
    MCPATCHER_FORGE_CTM_NO_CC(new MixinBuilder("MCP:F Connected Textures, no Custom Colours").setPhase(IBaseTransformer.Phase.EARLY).setApplyIf(() -> AngelicaConfig.enableMCPatcherForgeFeatures && MCPatcherForgeConfig.ConnectedTextures.enabled && !MCPatcherForgeConfig.CustomColors.enabled).addClientMixins(new String[]{"mcpatcherforge.ctm_cc.MixinRenderBlocksNoCC"})),
    MCPATCHER_FORGE_CTM_AND_CC(new MixinBuilder("MCP:F Connected Textures and Custom Colors").setPhase(IBaseTransformer.Phase.EARLY).setApplyIf(() -> AngelicaConfig.enableMCPatcherForgeFeatures && MCPatcherForgeConfig.ConnectedTextures.enabled && MCPatcherForgeConfig.CustomColors.enabled).addClientMixins(new String[]{"mcpatcherforge.ctm_cc.MixinRenderBlocks"})),
    MCPATCHER_FORGE_CTM_OR_CC(new MixinBuilder("MCP:F Connected Textures or Custom Colors").setPhase(IBaseTransformer.Phase.EARLY).setApplyIf(() -> AngelicaConfig.enableMCPatcherForgeFeatures && MCPatcherForgeConfig.ConnectedTextures.enabled || MCPatcherForgeConfig.CustomColors.enabled).addClientMixins(new String[]{"mcpatcherforge.ctm_cc.MixinTextureMap"}));

    private final MixinBuilder builder;

    private static String[] addPrefix(String prefix, String ... values) {
        ArrayList<CallSite> list = new ArrayList<CallSite>(values.length);
        for (String s : values) {
            list.add((CallSite)((Object)(prefix + s)));
        }
        return list.toArray(new String[values.length]);
    }

    @Generated
    public MixinBuilder getBuilder() {
        return this.builder;
    }

    @Generated
    private Mixins(MixinBuilder builder) {
        this.builder = builder;
    }
}

