/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.loading.fml.compat.transformers.generic;

import com.gtnewhorizons.angelica.loading.AngelicaTweaker;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import org.spongepowered.asm.lib.tree.AbstractInsnNode;
import org.spongepowered.asm.lib.tree.ClassNode;
import org.spongepowered.asm.lib.tree.FieldInsnNode;
import org.spongepowered.asm.lib.tree.InsnList;
import org.spongepowered.asm.lib.tree.LabelNode;
import org.spongepowered.asm.lib.tree.LocalVariableNode;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.lib.tree.VarInsnNode;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class FieldLevelTessellatorTransformer {
    public static void transform(ClassNode cn, List<String> patchMethods) {
        for (MethodNode method : cn.methods) {
            if (!patchMethods.contains(method.name)) continue;
            FieldLevelTessellatorTransformer.injectLocalTessellatorAndReplaceFieldUsage(method);
        }
    }

    private static void injectLocalTessellatorAndReplaceFieldUsage(MethodNode mn) {
        ArrayList<CallSite> fields = new ArrayList<CallSite>();
        for (int i = 0; i < mn.instructions.size(); ++i) {
            FieldInsnNode fin;
            AbstractInsnNode in = mn.instructions.get(i);
            if (!(in instanceof FieldInsnNode) || (fin = (FieldInsnNode)in).getOpcode() != 178 && fin.getOpcode() != 180 || !fin.desc.equals("Lnet/minecraft/client/renderer/Tessellator;") || fin.owner.equals("net/minecraft/client/renderer/Tessellator")) continue;
            fields.add((CallSite)((Object)(fin.owner + ";" + fin.name)));
        }
        if (fields.isEmpty()) {
            return;
        }
        int localIndex = mn.maxLocals;
        LabelNode startLabel = new LabelNode();
        LabelNode endLabel = new LabelNode();
        LocalVariableNode tesNode = new LocalVariableNode("tes", "Lnet/minecraft/client/renderer/Tessellator;", null, startLabel, endLabel, localIndex);
        mn.localVariables.add(tesNode);
        InsnList list = new InsnList();
        list.add((AbstractInsnNode)startLabel);
        list.add((AbstractInsnNode)new FieldInsnNode(178, "net/minecraft/client/renderer/Tessellator", AngelicaTweaker.obf("instance", "field_78398_a"), "Lnet/minecraft/client/renderer/Tessellator;"));
        list.add((AbstractInsnNode)new VarInsnNode(58, localIndex));
        mn.instructions.insert(list);
        for (int i = 0; i < mn.instructions.size(); ++i) {
            AbstractInsnNode in = mn.instructions.get(i);
            if (!(in instanceof FieldInsnNode)) continue;
            FieldInsnNode fin = (FieldInsnNode)in;
            String hash = fin.owner + ";" + fin.name;
            if (fin.getOpcode() != 178 && fin.getOpcode() != 180 || !fin.desc.equals("Lnet/minecraft/client/renderer/Tessellator;") || !fields.contains(hash)) continue;
            mn.instructions.insertBefore(in, (AbstractInsnNode)new VarInsnNode(25, localIndex));
            mn.instructions.remove(in);
        }
        mn.instructions.add((AbstractInsnNode)endLabel);
    }
}

