/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.glsm.recording.commands;

import com.gtnewhorizons.angelica.glsm.GLDebug;
import com.gtnewhorizons.angelica.glsm.GLStateManager;
import com.gtnewhorizons.angelica.glsm.recording.commands.DisplayListCommand;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public record TexImage2DCmd(int target, int level, int internalformat, int width, int height, int border, int format, int type, @Nullable byte[] pixelData) implements DisplayListCommand
{
    public static TexImage2DCmd fromIntBuffer(int target, int level, int internalformat, int width, int height, int border, int format, int type, @Nullable IntBuffer pixels) {
        byte[] data = null;
        if (pixels != null) {
            int pos = pixels.position();
            int limit = pixels.limit();
            int size = (limit - pos) * 4;
            data = new byte[size];
            ByteBuffer bb = ByteBuffer.wrap(data).order(ByteOrder.nativeOrder());
            bb.asIntBuffer().put(pixels);
            pixels.position(pos);
        }
        return new TexImage2DCmd(target, level, internalformat, width, height, border, format, type, data);
    }

    public static TexImage2DCmd fromFloatBuffer(int target, int level, int internalformat, int width, int height, int border, int format, int type, @Nullable FloatBuffer pixels) {
        byte[] data = null;
        if (pixels != null) {
            int pos = pixels.position();
            int limit = pixels.limit();
            int size = (limit - pos) * 4;
            data = new byte[size];
            ByteBuffer bb = ByteBuffer.wrap(data).order(ByteOrder.nativeOrder());
            bb.asFloatBuffer().put(pixels);
            pixels.position(pos);
        }
        return new TexImage2DCmd(target, level, internalformat, width, height, border, format, type, data);
    }

    public static TexImage2DCmd fromDoubleBuffer(int target, int level, int internalformat, int width, int height, int border, int format, int type, @Nullable DoubleBuffer pixels) {
        byte[] data = null;
        if (pixels != null) {
            int pos = pixels.position();
            int limit = pixels.limit();
            int size = (limit - pos) * 8;
            data = new byte[size];
            ByteBuffer bb = ByteBuffer.wrap(data).order(ByteOrder.nativeOrder());
            bb.asDoubleBuffer().put(pixels);
            pixels.position(pos);
        }
        return new TexImage2DCmd(target, level, internalformat, width, height, border, format, type, data);
    }

    public static TexImage2DCmd fromByteBuffer(int target, int level, int internalformat, int width, int height, int border, int format, int type, @Nullable ByteBuffer pixels) {
        byte[] data = null;
        if (pixels != null) {
            int pos = pixels.position();
            int limit = pixels.limit();
            int size = limit - pos;
            data = new byte[size];
            pixels.get(data);
            pixels.position(pos);
        }
        return new TexImage2DCmd(target, level, internalformat, width, height, border, format, type, data);
    }

    @Override
    public void execute() {
        ByteBuffer buffer = null;
        if (this.pixelData != null) {
            buffer = ByteBuffer.allocateDirect(this.pixelData.length).order(ByteOrder.nativeOrder());
            buffer.put(this.pixelData);
            buffer.flip();
        }
        GLStateManager.glTexImage2D(this.target, this.level, this.internalformat, this.width, this.height, this.border, this.format, this.type, buffer);
    }

    @Override
    @NotNull
    public String toString() {
        String dataStr = this.pixelData != null ? this.pixelData.length + " bytes" : "null";
        return String.format("TexImage2D(target=%s, level=%d, internalformat=%s, %dx%d, border=%d, format=%s, type=%s, data=%s)", GLDebug.getTextureTargetName(this.target), this.level, GLDebug.getTextureFormatName(this.internalformat), this.width, this.height, this.border, GLDebug.getTextureFormatName(this.format), GLDebug.getDataTypeName(this.type), dataStr);
    }
}

