/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.glsm.recording;

import com.gtnewhorizon.gtnhlib.bytebuf.MemoryUtilities;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class GLCommand {
    public static final int ENABLE = 1;
    public static final int DISABLE = 2;
    public static final int CLEAR = 3;
    public static final int CLEAR_STENCIL = 4;
    public static final int CULL_FACE = 5;
    public static final int DEPTH_FUNC = 6;
    public static final int SHADE_MODEL = 7;
    public static final int LOGIC_OP = 8;
    public static final int MATRIX_MODE = 9;
    public static final int ACTIVE_TEXTURE = 10;
    public static final int USE_PROGRAM = 11;
    public static final int PUSH_ATTRIB = 12;
    public static final int POP_ATTRIB = 13;
    public static final int LOAD_IDENTITY = 14;
    public static final int PUSH_MATRIX = 15;
    public static final int POP_MATRIX = 16;
    public static final int STENCIL_MASK = 17;
    public static final int DEPTH_MASK = 18;
    public static final int FRONT_FACE = 19;
    public static final int BIND_TEXTURE = 20;
    public static final int POLYGON_MODE = 21;
    public static final int COLOR_MATERIAL = 22;
    public static final int LINE_STIPPLE = 23;
    public static final int STENCIL_MASK_SEPARATE = 24;
    public static final int FOGI = 25;
    public static final int HINT = 26;
    public static final int STENCIL_FUNC = 30;
    public static final int STENCIL_OP = 31;
    public static final int TEX_PARAMETERI = 32;
    public static final int VIEWPORT = 40;
    public static final int BLEND_FUNC = 41;
    public static final int COLOR_MASK = 42;
    public static final int STENCIL_FUNC_SEPARATE = 43;
    public static final int STENCIL_OP_SEPARATE = 44;
    public static final int POINT_SIZE = 50;
    public static final int LINE_WIDTH = 51;
    public static final int POLYGON_OFFSET = 52;
    public static final int NORMAL = 53;
    public static final int COLOR = 54;
    public static final int CLEAR_COLOR = 55;
    public static final int BLEND_COLOR = 56;
    public static final int ALPHA_FUNC = 60;
    public static final int FOGF = 61;
    public static final int LIGHTF = 62;
    public static final int LIGHT_MODELF = 63;
    public static final int LIGHTI = 64;
    public static final int LIGHT_MODELI = 65;
    public static final int MATERIALF = 66;
    public static final int TEX_PARAMETERF = 67;
    public static final int TRANSLATE = 70;
    public static final int ROTATE = 71;
    public static final int SCALE = 72;
    public static final int ORTHO = 73;
    public static final int FRUSTUM = 74;
    public static final int CLEAR_DEPTH = 75;
    public static final int MULT_MATRIX = 80;
    public static final int LOAD_MATRIX = 81;
    public static final int FOG = 90;
    public static final int LIGHT = 91;
    public static final int LIGHT_MODEL = 92;
    public static final int MATERIAL = 93;
    public static final int DRAW_RANGE = 100;
    public static final int DRAW_RANGE_RESTORE = 101;
    public static final int CALL_LIST = 102;
    public static final int DRAW_ARRAYS = 110;
    public static final int DRAW_ELEMENTS = 111;
    public static final int DRAW_BUFFER = 112;
    public static final int DRAW_BUFFERS = 113;
    public static final int BIND_VBO = 120;
    public static final int BIND_VAO = 121;
    public static final int COMPLEX_REF = 255;

    private GLCommand() {
    }

    public static String getName(int opcode) {
        return switch (opcode) {
            case 1 -> "ENABLE";
            case 2 -> "DISABLE";
            case 3 -> "CLEAR";
            case 4 -> "CLEAR_STENCIL";
            case 5 -> "CULL_FACE";
            case 6 -> "DEPTH_FUNC";
            case 7 -> "SHADE_MODEL";
            case 8 -> "LOGIC_OP";
            case 9 -> "MATRIX_MODE";
            case 10 -> "ACTIVE_TEXTURE";
            case 11 -> "USE_PROGRAM";
            case 12 -> "PUSH_ATTRIB";
            case 13 -> "POP_ATTRIB";
            case 14 -> "LOAD_IDENTITY";
            case 15 -> "PUSH_MATRIX";
            case 16 -> "POP_MATRIX";
            case 17 -> "STENCIL_MASK";
            case 18 -> "DEPTH_MASK";
            case 19 -> "FRONT_FACE";
            case 20 -> "BIND_TEXTURE";
            case 21 -> "POLYGON_MODE";
            case 22 -> "COLOR_MATERIAL";
            case 23 -> "LINE_STIPPLE";
            case 24 -> "STENCIL_MASK_SEPARATE";
            case 25 -> "FOGI";
            case 26 -> "HINT";
            case 30 -> "STENCIL_FUNC";
            case 31 -> "STENCIL_OP";
            case 32 -> "TEX_PARAMETERI";
            case 40 -> "VIEWPORT";
            case 41 -> "BLEND_FUNC";
            case 42 -> "COLOR_MASK";
            case 43 -> "STENCIL_FUNC_SEPARATE";
            case 44 -> "STENCIL_OP_SEPARATE";
            case 50 -> "POINT_SIZE";
            case 51 -> "LINE_WIDTH";
            case 52 -> "POLYGON_OFFSET";
            case 54 -> "COLOR";
            case 55 -> "CLEAR_COLOR";
            case 56 -> "BLEND_COLOR";
            case 60 -> "ALPHA_FUNC";
            case 61 -> "FOGF";
            case 62 -> "LIGHTF";
            case 63 -> "LIGHT_MODELF";
            case 64 -> "LIGHTI";
            case 65 -> "LIGHT_MODELI";
            case 66 -> "MATERIALF";
            case 67 -> "TEX_PARAMETERF";
            case 70 -> "TRANSLATE";
            case 71 -> "ROTATE";
            case 72 -> "SCALE";
            case 73 -> "ORTHO";
            case 74 -> "FRUSTUM";
            case 75 -> "CLEAR_DEPTH";
            case 80 -> "MULT_MATRIX";
            case 81 -> "LOAD_MATRIX";
            case 90 -> "FOG";
            case 91 -> "LIGHT";
            case 92 -> "LIGHT_MODEL";
            case 93 -> "MATERIAL";
            case 100 -> "DRAW_RANGE";
            case 102 -> "CALL_LIST";
            case 112 -> "DRAW_BUFFER";
            case 113 -> "DRAW_BUFFERS";
            case 255 -> "COMPLEX_REF";
            case 101 -> "DRAW_RANGE_RESTORE";
            case 121 -> "BIND_VAO";
            case 120 -> "BIND_VBO";
            default -> "UNKNOWN(" + opcode + ")";
        };
    }

    public static int getCommandSize(int cmd, long ptr) {
        return switch (cmd) {
            case 14, 15, 16 -> 4;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 17, 18, 19, 50, 51, 100, 102, 120, 121, 255 -> 8;
            case 20, 21, 22, 23, 24, 25, 26, 52, 60, 61, 63, 65 -> 12;
            case 30, 31, 32, 62, 64, 66, 67, 110 -> 16;
            case 40, 41, 42, 43, 44, 54, 55, 56 -> 20;
            case 111 -> 24;
            case 101 -> 28;
            case 112 -> 8;
            case 113 -> 40;
            case 70, 72 -> 28;
            case 75 -> 12;
            case 71 -> 36;
            case 73, 74 -> 52;
            case 80, 81 -> 68;
            case 90, 92 -> {
                int count = MemoryUtilities.memGetInt((long)(ptr + 8L));
                yield 12 + count * 4;
            }
            case 91, 93 -> {
                int count = MemoryUtilities.memGetInt((long)(ptr + 12L));
                yield 16 + count * 4;
            }
            default -> throw new IllegalStateException("Unknown command: " + cmd);
        };
    }
}

