/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.glsm.recording;

import com.gtnewhorizons.angelica.glsm.recording.CommandBuffer;
import com.gtnewhorizons.angelica.glsm.recording.commands.DisplayListCommand;
import java.nio.FloatBuffer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joml.Matrix4f;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class CommandBufferProcessor {
    private static final Logger LOGGER = LogManager.getLogger((String)"CommandBufferProcessor");
    private static final Matrix4f tempMatrix = new Matrix4f();

    private CommandBufferProcessor() {
    }

    public static void copyCommand(CommandBuffer raw, CommandBuffer out) {
        int opcode = raw.readInt();
        CommandBufferProcessor.copyCommandData(opcode, raw, out);
    }

    public static void copyCommandData(int opcode, CommandBuffer raw, CommandBuffer out) {
        switch (opcode) {
            case 1: {
                out.writeEnable(raw.readInt());
                break;
            }
            case 2: {
                out.writeDisable(raw.readInt());
                break;
            }
            case 3: {
                out.writeClear(raw.readInt());
                break;
            }
            case 4: {
                out.writeClearStencil(raw.readInt());
                break;
            }
            case 5: {
                out.writeCullFace(raw.readInt());
                break;
            }
            case 6: {
                out.writeDepthFunc(raw.readInt());
                break;
            }
            case 7: {
                out.writeShadeModel(raw.readInt());
                break;
            }
            case 8: {
                out.writeLogicOp(raw.readInt());
                break;
            }
            case 9: {
                out.writeMatrixMode(raw.readInt());
                break;
            }
            case 10: {
                out.writeActiveTexture(raw.readInt());
                break;
            }
            case 11: {
                out.writeUseProgram(raw.readInt());
                break;
            }
            case 12: {
                out.writePushAttrib(raw.readInt());
                break;
            }
            case 13: {
                raw.readInt();
                out.writePopAttrib();
                break;
            }
            case 14: {
                out.writeLoadIdentity();
                break;
            }
            case 15: {
                out.writePushMatrix();
                break;
            }
            case 16: {
                out.writePopMatrix();
                break;
            }
            case 17: {
                out.writeStencilMask(raw.readInt());
                break;
            }
            case 18: {
                out.writeDepthMask(raw.readInt() != 0);
                break;
            }
            case 19: {
                out.writeFrontFace(raw.readInt());
                break;
            }
            case 20: {
                out.writeBindTexture(raw.readInt(), raw.readInt());
                break;
            }
            case 21: {
                out.writePolygonMode(raw.readInt(), raw.readInt());
                break;
            }
            case 22: {
                out.writeColorMaterial(raw.readInt(), raw.readInt());
                break;
            }
            case 23: {
                out.writeLineStipple(raw.readInt(), raw.readInt());
                break;
            }
            case 24: {
                out.writeStencilMaskSeparate(raw.readInt(), raw.readInt());
                break;
            }
            case 25: {
                out.writeFogi(raw.readInt(), raw.readInt());
                break;
            }
            case 26: {
                out.writeHint(raw.readInt(), raw.readInt());
                break;
            }
            case 30: {
                out.writeStencilFunc(raw.readInt(), raw.readInt(), raw.readInt());
                break;
            }
            case 31: {
                out.writeStencilOp(raw.readInt(), raw.readInt(), raw.readInt());
                break;
            }
            case 32: {
                out.writeTexParameteri(raw.readInt(), raw.readInt(), raw.readInt());
                break;
            }
            case 40: {
                out.writeViewport(raw.readInt(), raw.readInt(), raw.readInt(), raw.readInt());
                break;
            }
            case 41: {
                out.writeBlendFunc(raw.readInt(), raw.readInt(), raw.readInt(), raw.readInt());
                break;
            }
            case 42: {
                out.writeColorMask(raw.readInt() != 0, raw.readInt() != 0, raw.readInt() != 0, raw.readInt() != 0);
                break;
            }
            case 43: {
                out.writeStencilFuncSeparate(raw.readInt(), raw.readInt(), raw.readInt(), raw.readInt());
                break;
            }
            case 44: {
                out.writeStencilOpSeparate(raw.readInt(), raw.readInt(), raw.readInt(), raw.readInt());
                break;
            }
            case 50: {
                out.writePointSize(raw.readFloat());
                break;
            }
            case 51: {
                out.writeLineWidth(raw.readFloat());
                break;
            }
            case 52: {
                out.writePolygonOffset(raw.readFloat(), raw.readFloat());
                break;
            }
            case 54: {
                out.writeColor(raw.readFloat(), raw.readFloat(), raw.readFloat(), raw.readFloat());
                break;
            }
            case 55: {
                out.writeClearColor(raw.readFloat(), raw.readFloat(), raw.readFloat(), raw.readFloat());
                break;
            }
            case 75: {
                out.writeClearDepth(raw.readDouble());
                break;
            }
            case 56: {
                out.writeBlendColor(raw.readFloat(), raw.readFloat(), raw.readFloat(), raw.readFloat());
                break;
            }
            case 60: {
                out.writeAlphaFunc(raw.readInt(), raw.readFloat());
                break;
            }
            case 61: {
                out.writeFogf(raw.readInt(), raw.readFloat());
                break;
            }
            case 62: {
                out.writeLightf(raw.readInt(), raw.readInt(), raw.readFloat());
                break;
            }
            case 63: {
                out.writeLightModelf(raw.readInt(), raw.readFloat());
                break;
            }
            case 64: {
                out.writeLighti(raw.readInt(), raw.readInt(), raw.readInt());
                break;
            }
            case 65: {
                out.writeLightModeli(raw.readInt(), raw.readInt());
                break;
            }
            case 66: {
                out.writeMaterialf(raw.readInt(), raw.readInt(), raw.readFloat());
                break;
            }
            case 67: {
                out.writeTexParameterf(raw.readInt(), raw.readInt(), raw.readFloat());
                break;
            }
            case 70: {
                out.writeTranslate(raw.readDouble(), raw.readDouble(), raw.readDouble());
                break;
            }
            case 71: {
                out.writeRotate(raw.readDouble(), raw.readDouble(), raw.readDouble(), raw.readDouble());
                break;
            }
            case 72: {
                out.writeScale(raw.readDouble(), raw.readDouble(), raw.readDouble());
                break;
            }
            case 73: {
                out.writeOrtho(raw.readDouble(), raw.readDouble(), raw.readDouble(), raw.readDouble(), raw.readDouble(), raw.readDouble());
                break;
            }
            case 74: {
                out.writeFrustum(raw.readDouble(), raw.readDouble(), raw.readDouble(), raw.readDouble(), raw.readDouble(), raw.readDouble());
                break;
            }
            case 80: {
                out.writeMultMatrix(raw.readMatrix4f(tempMatrix));
                break;
            }
            case 81: {
                out.writeLoadMatrix(raw.readMatrix4f(tempMatrix));
                break;
            }
            case 90: {
                int pname = raw.readInt();
                int count = raw.readInt();
                FloatBuffer fb = FloatBuffer.allocate(count);
                for (int i = 0; i < count; ++i) {
                    fb.put(raw.readFloat());
                }
                fb.flip();
                out.writeFog(pname, fb);
                break;
            }
            case 91: {
                int light = raw.readInt();
                int pname = raw.readInt();
                int count = raw.readInt();
                FloatBuffer fb = FloatBuffer.allocate(count);
                for (int i = 0; i < count; ++i) {
                    fb.put(raw.readFloat());
                }
                fb.flip();
                out.writeLight(light, pname, fb);
                break;
            }
            case 92: {
                int pname = raw.readInt();
                int count = raw.readInt();
                FloatBuffer fb = FloatBuffer.allocate(count);
                for (int i = 0; i < count; ++i) {
                    fb.put(raw.readFloat());
                }
                fb.flip();
                out.writeLightModel(pname, fb);
                break;
            }
            case 93: {
                int face = raw.readInt();
                int pname = raw.readInt();
                int count = raw.readInt();
                FloatBuffer fb = FloatBuffer.allocate(count);
                for (int i = 0; i < count; ++i) {
                    fb.put(raw.readFloat());
                }
                fb.flip();
                out.writeMaterial(face, pname, fb);
                break;
            }
            case 100: {
                out.writeDrawRange(raw.readInt());
                break;
            }
            case 102: {
                out.writeCallList(raw.readInt());
                break;
            }
            case 110: {
                out.writeDrawArrays(raw.readInt(), raw.readInt(), raw.readInt());
                break;
            }
            case 111: {
                out.writeDrawElements(raw.readInt(), raw.readInt(), raw.readInt(), raw.readLong());
                break;
            }
            case 120: {
                out.writeBindVBO(raw.readInt());
                break;
            }
            case 121: {
                out.writeBindVAO(raw.readInt());
                break;
            }
            case 255: {
                int index = raw.readInt();
                Object obj = raw.getComplexObject(index);
                out.writeComplexRef((DisplayListCommand)obj);
                break;
            }
            default: {
                LOGGER.warn("[CommandBufferProcessor] Unknown opcode in buffer copy: {}", new Object[]{opcode});
            }
        }
    }
}

