/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.glsm.recording;

import com.gtnewhorizon.gtnhlib.bytebuf.MemoryUtilities;
import com.gtnewhorizon.gtnhlib.client.opengl.UniversalVAO;
import com.gtnewhorizons.angelica.glsm.DisplayListManager;
import com.gtnewhorizons.angelica.glsm.GLStateManager;
import com.gtnewhorizons.angelica.glsm.recording.DisplayListVBO;
import com.gtnewhorizons.angelica.glsm.recording.commands.DisplayListCommand;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class CommandBufferExecutor {
    private static final FloatBuffer MATRIX_BUFFER = BufferUtils.createFloatBuffer((int)16);
    private static final FloatBuffer PARAMS_BUFFER = BufferUtils.createFloatBuffer((int)4);
    private static final int MAX_DRAW_BUFFERS = 8;
    private static final IntBuffer DRAW_BUFFERS_BUFFER = BufferUtils.createIntBuffer((int)8);

    private CommandBufferExecutor() {
    }

    public static void execute(ByteBuffer buffer, Object[] complexObjects, DisplayListVBO ownedVbos) {
        long ptr = MemoryUtilities.memAddress((ByteBuffer)buffer);
        long end = ptr + (long)buffer.limit();
        while (ptr < end) {
            int cmd = MemoryUtilities.memGetInt((long)ptr);
            ptr += 4L;
            switch (cmd) {
                case 1: {
                    GLStateManager.glEnable(MemoryUtilities.memGetInt((long)ptr));
                    ptr += 4L;
                    break;
                }
                case 2: {
                    GLStateManager.glDisable(MemoryUtilities.memGetInt((long)ptr));
                    ptr += 4L;
                    break;
                }
                case 3: {
                    GLStateManager.glClear(MemoryUtilities.memGetInt((long)ptr));
                    ptr += 4L;
                    break;
                }
                case 4: {
                    GLStateManager.glClearStencil(MemoryUtilities.memGetInt((long)ptr));
                    ptr += 4L;
                    break;
                }
                case 5: {
                    GLStateManager.glCullFace(MemoryUtilities.memGetInt((long)ptr));
                    ptr += 4L;
                    break;
                }
                case 6: {
                    GLStateManager.glDepthFunc(MemoryUtilities.memGetInt((long)ptr));
                    ptr += 4L;
                    break;
                }
                case 7: {
                    GLStateManager.glShadeModel(MemoryUtilities.memGetInt((long)ptr));
                    ptr += 4L;
                    break;
                }
                case 8: {
                    GLStateManager.glLogicOp(MemoryUtilities.memGetInt((long)ptr));
                    ptr += 4L;
                    break;
                }
                case 9: {
                    GLStateManager.glMatrixMode(MemoryUtilities.memGetInt((long)ptr));
                    ptr += 4L;
                    break;
                }
                case 10: {
                    GLStateManager.glActiveTexture(MemoryUtilities.memGetInt((long)ptr));
                    ptr += 4L;
                    break;
                }
                case 11: {
                    GLStateManager.glUseProgram(MemoryUtilities.memGetInt((long)ptr));
                    ptr += 4L;
                    break;
                }
                case 12: {
                    GLStateManager.glPushAttrib(MemoryUtilities.memGetInt((long)ptr));
                    ptr += 4L;
                    break;
                }
                case 13: {
                    GLStateManager.glPopAttrib();
                    ptr += 4L;
                    break;
                }
                case 14: {
                    GLStateManager.glLoadIdentity();
                    break;
                }
                case 15: {
                    GLStateManager.glPushMatrix();
                    break;
                }
                case 16: {
                    GLStateManager.glPopMatrix();
                    break;
                }
                case 17: {
                    GLStateManager.glStencilMask(MemoryUtilities.memGetInt((long)ptr));
                    ptr += 4L;
                    break;
                }
                case 18: {
                    GLStateManager.glDepthMask(MemoryUtilities.memGetInt((long)ptr) != 0);
                    ptr += 4L;
                    break;
                }
                case 19: {
                    GLStateManager.glFrontFace(MemoryUtilities.memGetInt((long)ptr));
                    ptr += 4L;
                    break;
                }
                case 20: {
                    int target = MemoryUtilities.memGetInt((long)ptr);
                    int texture = MemoryUtilities.memGetInt((long)(ptr + 4L));
                    ptr += 8L;
                    GLStateManager.glBindTexture(target, texture);
                    break;
                }
                case 21: {
                    int face = MemoryUtilities.memGetInt((long)ptr);
                    int mode = MemoryUtilities.memGetInt((long)(ptr + 4L));
                    ptr += 8L;
                    GLStateManager.glPolygonMode(face, mode);
                    break;
                }
                case 22: {
                    int face = MemoryUtilities.memGetInt((long)ptr);
                    int mode = MemoryUtilities.memGetInt((long)(ptr + 4L));
                    ptr += 8L;
                    GLStateManager.glColorMaterial(face, mode);
                    break;
                }
                case 23: {
                    int factor = MemoryUtilities.memGetInt((long)ptr);
                    int pattern = MemoryUtilities.memGetInt((long)(ptr + 4L));
                    ptr += 8L;
                    GLStateManager.glLineStipple(factor, (short)pattern);
                    break;
                }
                case 24: {
                    int face = MemoryUtilities.memGetInt((long)ptr);
                    int mask = MemoryUtilities.memGetInt((long)(ptr + 4L));
                    ptr += 8L;
                    GLStateManager.glStencilMaskSeparate(face, mask);
                    break;
                }
                case 25: {
                    int pname = MemoryUtilities.memGetInt((long)ptr);
                    int param = MemoryUtilities.memGetInt((long)(ptr + 4L));
                    ptr += 8L;
                    GLStateManager.glFogi(pname, param);
                    break;
                }
                case 26: {
                    int target = MemoryUtilities.memGetInt((long)ptr);
                    int mode = MemoryUtilities.memGetInt((long)(ptr + 4L));
                    ptr += 8L;
                    GLStateManager.glHint(target, mode);
                    break;
                }
                case 30: {
                    int func = MemoryUtilities.memGetInt((long)ptr);
                    int ref = MemoryUtilities.memGetInt((long)(ptr + 4L));
                    int mask = MemoryUtilities.memGetInt((long)(ptr + 8L));
                    ptr += 12L;
                    GLStateManager.glStencilFunc(func, ref, mask);
                    break;
                }
                case 31: {
                    int fail = MemoryUtilities.memGetInt((long)ptr);
                    int zfail = MemoryUtilities.memGetInt((long)(ptr + 4L));
                    int zpass = MemoryUtilities.memGetInt((long)(ptr + 8L));
                    ptr += 12L;
                    GLStateManager.glStencilOp(fail, zfail, zpass);
                    break;
                }
                case 32: {
                    int target = MemoryUtilities.memGetInt((long)ptr);
                    int pname = MemoryUtilities.memGetInt((long)(ptr + 4L));
                    int param = MemoryUtilities.memGetInt((long)(ptr + 8L));
                    ptr += 12L;
                    GLStateManager.glTexParameteri(target, pname, param);
                    break;
                }
                case 40: {
                    int x = MemoryUtilities.memGetInt((long)ptr);
                    int y = MemoryUtilities.memGetInt((long)(ptr + 4L));
                    int width = MemoryUtilities.memGetInt((long)(ptr + 8L));
                    int height = MemoryUtilities.memGetInt((long)(ptr + 12L));
                    ptr += 16L;
                    GLStateManager.glViewport(x, y, width, height);
                    break;
                }
                case 41: {
                    int srcRgb = MemoryUtilities.memGetInt((long)ptr);
                    int dstRgb = MemoryUtilities.memGetInt((long)(ptr + 4L));
                    int srcAlpha = MemoryUtilities.memGetInt((long)(ptr + 8L));
                    int dstAlpha = MemoryUtilities.memGetInt((long)(ptr + 12L));
                    ptr += 16L;
                    if (srcRgb == srcAlpha && dstRgb == dstAlpha) {
                        GLStateManager.glBlendFunc(srcRgb, dstRgb);
                        break;
                    }
                    GLStateManager.tryBlendFuncSeparate(srcRgb, dstRgb, srcAlpha, dstAlpha);
                    break;
                }
                case 42: {
                    boolean r = MemoryUtilities.memGetInt((long)ptr) != 0;
                    boolean g = MemoryUtilities.memGetInt((long)(ptr + 4L)) != 0;
                    boolean b = MemoryUtilities.memGetInt((long)(ptr + 8L)) != 0;
                    boolean a = MemoryUtilities.memGetInt((long)(ptr + 12L)) != 0;
                    ptr += 16L;
                    GLStateManager.glColorMask(r, g, b, a);
                    break;
                }
                case 43: {
                    int face = MemoryUtilities.memGetInt((long)ptr);
                    int func = MemoryUtilities.memGetInt((long)(ptr + 4L));
                    int ref = MemoryUtilities.memGetInt((long)(ptr + 8L));
                    int mask = MemoryUtilities.memGetInt((long)(ptr + 12L));
                    ptr += 16L;
                    GLStateManager.glStencilFuncSeparate(face, func, ref, mask);
                    break;
                }
                case 44: {
                    int face = MemoryUtilities.memGetInt((long)ptr);
                    int sfail = MemoryUtilities.memGetInt((long)(ptr + 4L));
                    int dpfail = MemoryUtilities.memGetInt((long)(ptr + 8L));
                    int dppass = MemoryUtilities.memGetInt((long)(ptr + 12L));
                    ptr += 16L;
                    GLStateManager.glStencilOpSeparate(face, sfail, dpfail, dppass);
                    break;
                }
                case 50: {
                    GLStateManager.glPointSize(MemoryUtilities.memGetFloat((long)ptr));
                    ptr += 4L;
                    break;
                }
                case 51: {
                    GLStateManager.glLineWidth(MemoryUtilities.memGetFloat((long)ptr));
                    ptr += 4L;
                    break;
                }
                case 52: {
                    float factor = MemoryUtilities.memGetFloat((long)ptr);
                    float units = MemoryUtilities.memGetFloat((long)(ptr + 4L));
                    ptr += 8L;
                    GLStateManager.glPolygonOffset(factor, units);
                    break;
                }
                case 54: {
                    float r = MemoryUtilities.memGetFloat((long)ptr);
                    float g = MemoryUtilities.memGetFloat((long)(ptr + 4L));
                    float b = MemoryUtilities.memGetFloat((long)(ptr + 8L));
                    float a = MemoryUtilities.memGetFloat((long)(ptr + 12L));
                    ptr += 16L;
                    GLStateManager.glColor4f(r, g, b, a);
                    break;
                }
                case 55: {
                    float r = MemoryUtilities.memGetFloat((long)ptr);
                    float g = MemoryUtilities.memGetFloat((long)(ptr + 4L));
                    float b = MemoryUtilities.memGetFloat((long)(ptr + 8L));
                    float a = MemoryUtilities.memGetFloat((long)(ptr + 12L));
                    ptr += 16L;
                    GLStateManager.glClearColor(r, g, b, a);
                    break;
                }
                case 75: {
                    double depth = MemoryUtilities.memGetDouble((long)ptr);
                    ptr += 8L;
                    GLStateManager.glClearDepth(depth);
                    break;
                }
                case 56: {
                    float r = MemoryUtilities.memGetFloat((long)ptr);
                    float g = MemoryUtilities.memGetFloat((long)(ptr + 4L));
                    float b = MemoryUtilities.memGetFloat((long)(ptr + 8L));
                    float a = MemoryUtilities.memGetFloat((long)(ptr + 12L));
                    ptr += 16L;
                    GLStateManager.glBlendColor(r, g, b, a);
                    break;
                }
                case 60: {
                    int func = MemoryUtilities.memGetInt((long)ptr);
                    float ref = MemoryUtilities.memGetFloat((long)(ptr + 4L));
                    ptr += 8L;
                    GLStateManager.glAlphaFunc(func, ref);
                    break;
                }
                case 61: {
                    int pname = MemoryUtilities.memGetInt((long)ptr);
                    float param = MemoryUtilities.memGetFloat((long)(ptr + 4L));
                    ptr += 8L;
                    GLStateManager.glFogf(pname, param);
                    break;
                }
                case 62: {
                    int light = MemoryUtilities.memGetInt((long)ptr);
                    int pname = MemoryUtilities.memGetInt((long)(ptr + 4L));
                    float param = MemoryUtilities.memGetFloat((long)(ptr + 8L));
                    ptr += 12L;
                    GLStateManager.glLightf(light, pname, param);
                    break;
                }
                case 63: {
                    int pname = MemoryUtilities.memGetInt((long)ptr);
                    float param = MemoryUtilities.memGetFloat((long)(ptr + 4L));
                    ptr += 8L;
                    GLStateManager.glLightModelf(pname, param);
                    break;
                }
                case 64: {
                    int light = MemoryUtilities.memGetInt((long)ptr);
                    int pname = MemoryUtilities.memGetInt((long)(ptr + 4L));
                    int param = MemoryUtilities.memGetInt((long)(ptr + 8L));
                    ptr += 12L;
                    GLStateManager.glLighti(light, pname, param);
                    break;
                }
                case 65: {
                    int pname = MemoryUtilities.memGetInt((long)ptr);
                    int param = MemoryUtilities.memGetInt((long)(ptr + 4L));
                    ptr += 8L;
                    GLStateManager.glLightModeli(pname, param);
                    break;
                }
                case 66: {
                    int face = MemoryUtilities.memGetInt((long)ptr);
                    int pname = MemoryUtilities.memGetInt((long)(ptr + 4L));
                    float param = MemoryUtilities.memGetFloat((long)(ptr + 8L));
                    ptr += 12L;
                    GLStateManager.glMaterialf(face, pname, param);
                    break;
                }
                case 67: {
                    int target = MemoryUtilities.memGetInt((long)ptr);
                    int pname = MemoryUtilities.memGetInt((long)(ptr + 4L));
                    float param = MemoryUtilities.memGetFloat((long)(ptr + 8L));
                    ptr += 12L;
                    GLStateManager.glTexParameterf(target, pname, param);
                    break;
                }
                case 70: {
                    double x = MemoryUtilities.memGetDouble((long)ptr);
                    double y = MemoryUtilities.memGetDouble((long)(ptr + 8L));
                    double z = MemoryUtilities.memGetDouble((long)(ptr + 16L));
                    ptr += 24L;
                    GLStateManager.glTranslated(x, y, z);
                    break;
                }
                case 71: {
                    double angle = MemoryUtilities.memGetDouble((long)ptr);
                    double x = MemoryUtilities.memGetDouble((long)(ptr + 8L));
                    double y = MemoryUtilities.memGetDouble((long)(ptr + 16L));
                    double z = MemoryUtilities.memGetDouble((long)(ptr + 24L));
                    ptr += 32L;
                    GLStateManager.glRotated(angle, x, y, z);
                    break;
                }
                case 72: {
                    double x = MemoryUtilities.memGetDouble((long)ptr);
                    double y = MemoryUtilities.memGetDouble((long)(ptr + 8L));
                    double z = MemoryUtilities.memGetDouble((long)(ptr + 16L));
                    ptr += 24L;
                    GLStateManager.glScaled(x, y, z);
                    break;
                }
                case 73: {
                    double left = MemoryUtilities.memGetDouble((long)ptr);
                    double right = MemoryUtilities.memGetDouble((long)(ptr + 8L));
                    double bottom = MemoryUtilities.memGetDouble((long)(ptr + 16L));
                    double top = MemoryUtilities.memGetDouble((long)(ptr + 24L));
                    double zNear = MemoryUtilities.memGetDouble((long)(ptr + 32L));
                    double zFar = MemoryUtilities.memGetDouble((long)(ptr + 40L));
                    ptr += 48L;
                    GLStateManager.glOrtho(left, right, bottom, top, zNear, zFar);
                    break;
                }
                case 74: {
                    double left = MemoryUtilities.memGetDouble((long)ptr);
                    double right = MemoryUtilities.memGetDouble((long)(ptr + 8L));
                    double bottom = MemoryUtilities.memGetDouble((long)(ptr + 16L));
                    double top = MemoryUtilities.memGetDouble((long)(ptr + 24L));
                    double zNear = MemoryUtilities.memGetDouble((long)(ptr + 32L));
                    double zFar = MemoryUtilities.memGetDouble((long)(ptr + 40L));
                    ptr += 48L;
                    GLStateManager.glFrustum(left, right, bottom, top, zNear, zFar);
                    break;
                }
                case 80: {
                    MATRIX_BUFFER.clear();
                    for (int i = 0; i < 16; ++i) {
                        MATRIX_BUFFER.put(MemoryUtilities.memGetFloat((long)ptr));
                        ptr += 4L;
                    }
                    MATRIX_BUFFER.flip();
                    GLStateManager.glMultMatrix(MATRIX_BUFFER);
                    break;
                }
                case 81: {
                    MATRIX_BUFFER.clear();
                    for (int i = 0; i < 16; ++i) {
                        MATRIX_BUFFER.put(MemoryUtilities.memGetFloat((long)ptr));
                        ptr += 4L;
                    }
                    MATRIX_BUFFER.flip();
                    GLStateManager.glLoadMatrix(MATRIX_BUFFER);
                    break;
                }
                case 90: {
                    int pname = MemoryUtilities.memGetInt((long)ptr);
                    int count = MemoryUtilities.memGetInt((long)(ptr + 4L));
                    ptr += 8L;
                    PARAMS_BUFFER.clear();
                    for (int i = 0; i < count; ++i) {
                        PARAMS_BUFFER.put(MemoryUtilities.memGetFloat((long)ptr));
                        ptr += 4L;
                    }
                    PARAMS_BUFFER.flip();
                    GLStateManager.glFog(pname, PARAMS_BUFFER);
                    break;
                }
                case 91: {
                    int light = MemoryUtilities.memGetInt((long)ptr);
                    int pname = MemoryUtilities.memGetInt((long)(ptr + 4L));
                    int count = MemoryUtilities.memGetInt((long)(ptr + 8L));
                    ptr += 12L;
                    PARAMS_BUFFER.clear();
                    for (int i = 0; i < count; ++i) {
                        PARAMS_BUFFER.put(MemoryUtilities.memGetFloat((long)ptr));
                        ptr += 4L;
                    }
                    PARAMS_BUFFER.flip();
                    GLStateManager.glLight(light, pname, PARAMS_BUFFER);
                    break;
                }
                case 92: {
                    int pname = MemoryUtilities.memGetInt((long)ptr);
                    int count = MemoryUtilities.memGetInt((long)(ptr + 4L));
                    ptr += 8L;
                    PARAMS_BUFFER.clear();
                    for (int i = 0; i < count; ++i) {
                        PARAMS_BUFFER.put(MemoryUtilities.memGetFloat((long)ptr));
                        ptr += 4L;
                    }
                    PARAMS_BUFFER.flip();
                    GLStateManager.glLightModel(pname, PARAMS_BUFFER);
                    break;
                }
                case 93: {
                    int face = MemoryUtilities.memGetInt((long)ptr);
                    int pname = MemoryUtilities.memGetInt((long)(ptr + 4L));
                    int count = MemoryUtilities.memGetInt((long)(ptr + 8L));
                    ptr += 12L;
                    PARAMS_BUFFER.clear();
                    for (int i = 0; i < count; ++i) {
                        PARAMS_BUFFER.put(MemoryUtilities.memGetFloat((long)ptr));
                        ptr += 4L;
                    }
                    PARAMS_BUFFER.flip();
                    GLStateManager.glMaterial(face, pname, PARAMS_BUFFER);
                    break;
                }
                case 100: {
                    int vboIndex = MemoryUtilities.memGetInt((long)ptr);
                    ptr += 4L;
                    ownedVbos.render(vboIndex);
                    break;
                }
                case 101: {
                    int vboIndex = MemoryUtilities.memGetInt((long)ptr);
                    int flags = MemoryUtilities.memGetInt((long)(ptr + 4L));
                    ownedVbos.render(vboIndex);
                    if ((flags & 2) != 0) {
                        int color = MemoryUtilities.memGetInt((long)(ptr + 8L));
                        byte a = (byte)(color >> 24 & 0xFF);
                        byte r = (byte)(color >> 16 & 0xFF);
                        byte g = (byte)(color >> 8 & 0xFF);
                        byte b = (byte)(color & 0xFF);
                        GLStateManager.glColor4ub(r, g, b, a);
                    }
                    if ((flags & 4) != 0) {
                        int normal = MemoryUtilities.memGetInt((long)(ptr + 12L));
                        float nx = (float)((byte)normal) / 127.0f;
                        float ny = (float)((byte)(normal >> 8)) / 127.0f;
                        float nz = (float)((byte)(normal >> 16)) / 127.0f;
                        GLStateManager.glNormal3f(nx, ny, nz);
                    }
                    if ((flags & 1) != 0) {
                        float s = MemoryUtilities.memGetFloat((long)(ptr + 16L));
                        float t = MemoryUtilities.memGetFloat((long)(ptr + 20L));
                        GLStateManager.glTexCoord2f(s, t);
                    }
                    ptr += 24L;
                    break;
                }
                case 102: {
                    int listId = MemoryUtilities.memGetInt((long)ptr);
                    ptr += 4L;
                    DisplayListManager.glCallList(listId);
                    break;
                }
                case 112: {
                    GLStateManager.glDrawBuffer(MemoryUtilities.memGetInt((long)ptr));
                    ptr += 4L;
                    break;
                }
                case 113: {
                    int count = MemoryUtilities.memGetInt((long)ptr);
                    ptr += 4L;
                    DRAW_BUFFERS_BUFFER.clear();
                    for (int i = 0; i < count; ++i) {
                        DRAW_BUFFERS_BUFFER.put(MemoryUtilities.memGetInt((long)(ptr + (long)(i * 4))));
                    }
                    DRAW_BUFFERS_BUFFER.flip();
                    ptr += 32L;
                    GLStateManager.glDrawBuffers(DRAW_BUFFERS_BUFFER);
                    break;
                }
                case 110: {
                    GLStateManager.glDrawArrays(MemoryUtilities.memGetInt((long)ptr), MemoryUtilities.memGetInt((long)(ptr + 4L)), MemoryUtilities.memGetInt((long)(ptr + 8L)));
                    ptr += 12L;
                    break;
                }
                case 111: {
                    GLStateManager.glDrawElements(MemoryUtilities.memGetInt((long)ptr), MemoryUtilities.memGetInt((long)(ptr + 4L)), MemoryUtilities.memGetInt((long)(ptr + 8L)), MemoryUtilities.memGetLong((long)(ptr + 12L)));
                    ptr += 20L;
                    break;
                }
                case 120: {
                    GLStateManager.glBindBuffer(34962, MemoryUtilities.memGetInt((long)ptr));
                    ptr += 4L;
                    break;
                }
                case 121: {
                    UniversalVAO.bindVertexArray((int)MemoryUtilities.memGetInt((long)ptr));
                    ptr += 4L;
                    break;
                }
                case 255: {
                    int index = MemoryUtilities.memGetInt((long)ptr);
                    ptr += 4L;
                    ((DisplayListCommand)complexObjects[index]).execute();
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown command opcode: " + cmd);
                }
            }
        }
    }
}

