/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.glsm;

import com.gtnewhorizons.angelica.glsm.GLStateManager;
import com.gtnewhorizons.angelica.loading.AngelicaTweaker;
import org.lwjgl.opengl.AMDDebugOutput;
import org.lwjgl.opengl.AMDDebugOutputCallback;
import org.lwjgl.opengl.ARBDebugOutput;
import org.lwjgl.opengl.ARBDebugOutputCallback;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL43;
import org.lwjgl.opengl.KHRDebug;
import org.lwjgl.opengl.KHRDebugCallback;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class GLDebug {
    private static DebugState debugState;

    public static int setupDebugMessageCallback() {
        if (Thread.currentThread() != GLStateManager.getMainThread()) {
            AngelicaTweaker.LOGGER.warn("setupDebugMessageCallback called from non-main thread!");
            return 0;
        }
        return GLDebug.setupDebugMessageCallbackImpl();
    }

    public static Throwable filterStackTrace(Throwable throwable, int offset) {
        StackTraceElement[] elems = throwable.getStackTrace();
        StackTraceElement[] filtered = new StackTraceElement[elems.length];
        int j = 0;
        for (int i = offset; i < elems.length; ++i) {
            String className = elems[i].getClassName();
            if (className == null) {
                className = "";
            }
            filtered[j++] = elems[i];
        }
        StackTraceElement[] newElems = new StackTraceElement[j];
        System.arraycopy(filtered, 0, newElems, 0, j);
        throwable.setStackTrace(newElems);
        return throwable;
    }

    private static String buildStackTrace() {
        StackTraceElement[] elems = GLDebug.filterStackTrace(new Throwable(), 4).getStackTrace();
        StringBuilder sb = new StringBuilder();
        for (StackTraceElement elem : elems) {
            sb.append("\n\t").append(elem.toString());
        }
        return sb.toString();
    }

    private static void logDebugMessage(int id, String source, String type, String severity, String message) {
        String fullMessage = String.format("[GL] %s %s (0x%X) from %s: %s%s", severity, type, id, source, message, GLDebug.buildStackTrace());
        if ("HIGH".equals(severity)) {
            AngelicaTweaker.LOGGER.error(fullMessage);
        } else if ("MEDIUM".equals(severity)) {
            AngelicaTweaker.LOGGER.warn(fullMessage);
        } else {
            AngelicaTweaker.LOGGER.info(fullMessage);
        }
    }

    private static void logDebugMessageAMD(int id, String category, String severity, String message) {
        String fullMessage = String.format("[GL] %s %s (0x%X): %s%s", severity, category, id, message, GLDebug.buildStackTrace());
        if ("HIGH".equals(severity)) {
            AngelicaTweaker.LOGGER.error(fullMessage);
        } else if ("MEDIUM".equals(severity)) {
            AngelicaTweaker.LOGGER.warn(fullMessage);
        } else {
            AngelicaTweaker.LOGGER.info(fullMessage);
        }
    }

    private static int setupDebugMessageCallbackImpl() {
        if (GLStateManager.capabilities.OpenGL43 || GLStateManager.capabilities.GL_KHR_debug) {
            AngelicaTweaker.LOGGER.info("[GL] Using OpenGL 4.3 for error logging.");
            KHRDebugCallback proc = new KHRDebugCallback((source, type, id, severity, message) -> GLDebug.logDebugMessage(id, GLDebug.getDebugSource(source), GLDebug.getDebugType(type), GLDebug.getDebugSeverity(severity), message));
            GL43.glDebugMessageControl((int)4352, (int)4352, (int)37190, null, (boolean)true);
            GL43.glDebugMessageControl((int)4352, (int)4352, (int)37191, null, (boolean)false);
            GL43.glDebugMessageControl((int)4352, (int)4352, (int)37192, null, (boolean)false);
            GL43.glDebugMessageControl((int)4352, (int)4352, (int)33387, null, (boolean)false);
            GL43.glDebugMessageCallback((KHRDebugCallback)proc);
            GL11.glEnable((int)33346);
            if ((GL11.glGetInteger((int)33310) & 2) == 0) {
                AngelicaTweaker.LOGGER.warn("[GL] Warning: A non-debug context may not produce any debug output.");
                GL11.glEnable((int)37600);
                return 2;
            }
            return 1;
        }
        if (GLStateManager.capabilities.GL_ARB_debug_output) {
            AngelicaTweaker.LOGGER.info("[GL] Using ARB_debug_output for error logging.");
            ARBDebugOutputCallback proc = new ARBDebugOutputCallback((source, type, id, severity, message) -> GLDebug.logDebugMessage(id, GLDebug.getSourceARB(source), GLDebug.getTypeARB(type), GLDebug.getSeverityARB(severity), message));
            ARBDebugOutput.glDebugMessageControlARB((int)4352, (int)4352, (int)37190, null, (boolean)true);
            ARBDebugOutput.glDebugMessageControlARB((int)4352, (int)4352, (int)37191, null, (boolean)false);
            ARBDebugOutput.glDebugMessageControlARB((int)4352, (int)4352, (int)37192, null, (boolean)false);
            ARBDebugOutput.glDebugMessageControlARB((int)4352, (int)4352, (int)33387, null, (boolean)false);
            ARBDebugOutput.glDebugMessageCallbackARB((ARBDebugOutputCallback)proc);
            GL11.glEnable((int)33346);
            return 1;
        }
        if (GLStateManager.capabilities.GL_AMD_debug_output) {
            AngelicaTweaker.LOGGER.info("[GL] Using AMD_debug_output for error logging.");
            AMDDebugOutputCallback proc = new AMDDebugOutputCallback((id, category, severity, message) -> GLDebug.logDebugMessageAMD(id, GLDebug.getCategoryAMD(category), GLDebug.getSeverityAMD(severity), message));
            AMDDebugOutput.glDebugMessageEnableAMD((int)0, (int)37190, null, (boolean)true);
            AMDDebugOutput.glDebugMessageEnableAMD((int)0, (int)37191, null, (boolean)false);
            AMDDebugOutput.glDebugMessageEnableAMD((int)0, (int)37192, null, (boolean)false);
            AMDDebugOutput.glDebugMessageEnableAMD((int)0, (int)33387, null, (boolean)false);
            AMDDebugOutput.glDebugMessageCallbackAMD((AMDDebugOutputCallback)proc);
            return 1;
        }
        AngelicaTweaker.LOGGER.info("[GL] No debug output implementation is available, cannot return debug info.");
        return 0;
    }

    public static int disableDebugMessages() {
        if (GLStateManager.capabilities.OpenGL43) {
            GL43.glDebugMessageCallback(null);
            return 1;
        }
        if (GLStateManager.capabilities.GL_KHR_debug) {
            KHRDebug.glDebugMessageCallback(null);
            if (GLStateManager.capabilities.OpenGL30 && (GL11.glGetInteger((int)33310) & 2) == 0) {
                GL11.glDisable((int)37600);
            }
            return 1;
        }
        if (GLStateManager.capabilities.GL_ARB_debug_output) {
            ARBDebugOutput.glDebugMessageCallbackARB(null);
            return 1;
        }
        if (GLStateManager.capabilities.GL_AMD_debug_output) {
            AMDDebugOutput.glDebugMessageCallbackAMD(null);
            return 1;
        }
        AngelicaTweaker.LOGGER.info("[GL] No debug output implementation is available, cannot disable debug info.");
        return 0;
    }

    private static String getDebugSource(int source) {
        return switch (source) {
            case 33350 -> "API";
            case 33351 -> "WINDOW SYSTEM";
            case 33352 -> "SHADER COMPILER";
            case 33353 -> "THIRD PARTY";
            case 33354 -> "APPLICATION";
            case 33355 -> "OTHER";
            default -> String.format("Unknown [0x%X]", source);
        };
    }

    private static String getDebugType(int type) {
        return switch (type) {
            case 33356 -> "ERROR";
            case 33357 -> "DEPRECATED BEHAVIOR";
            case 33358 -> "UNDEFINED BEHAVIOR";
            case 33359 -> "PORTABILITY";
            case 33360 -> "PERFORMANCE";
            case 33361 -> "OTHER";
            case 33384 -> "MARKER";
            default -> String.format("Unknown [0x%X]", type);
        };
    }

    private static String getDebugSeverity(int severity) {
        return switch (severity) {
            case 33387 -> "NOTIFICATION";
            case 37190 -> "HIGH";
            case 37191 -> "MEDIUM";
            case 37192 -> "LOW";
            default -> String.format("Unknown [0x%X]", severity);
        };
    }

    private static String getSourceARB(int source) {
        return switch (source) {
            case 33350 -> "API";
            case 33351 -> "WINDOW SYSTEM";
            case 33352 -> "SHADER COMPILER";
            case 33353 -> "THIRD PARTY";
            case 33354 -> "APPLICATION";
            case 33355 -> "OTHER";
            default -> String.format("Unknown [0x%X]", source);
        };
    }

    private static String getTypeARB(int type) {
        return switch (type) {
            case 33356 -> "ERROR";
            case 33357 -> "DEPRECATED BEHAVIOR";
            case 33358 -> "UNDEFINED BEHAVIOR";
            case 33359 -> "PORTABILITY";
            case 33360 -> "PERFORMANCE";
            case 33361 -> "OTHER";
            default -> String.format("Unknown [0x%X]", type);
        };
    }

    private static String getSeverityARB(int severity) {
        return switch (severity) {
            case 37190 -> "HIGH";
            case 37191 -> "MEDIUM";
            case 37192 -> "LOW";
            default -> String.format("Unknown [0x%X]", severity);
        };
    }

    private static String getCategoryAMD(int category) {
        return switch (category) {
            case 37193 -> "API ERROR";
            case 37194 -> "WINDOW SYSTEM";
            case 37195 -> "DEPRECATION";
            case 37196 -> "UNDEFINED BEHAVIOR";
            case 37197 -> "PERFORMANCE";
            case 37198 -> "SHADER COMPILER";
            case 37199 -> "APPLICATION";
            case 37200 -> "OTHER";
            default -> String.format("Unknown [0x%X]", category);
        };
    }

    private static String getSeverityAMD(int severity) {
        return switch (severity) {
            case 37190 -> "HIGH";
            case 37191 -> "MEDIUM";
            case 37192 -> "LOW";
            default -> String.format("Unknown [0x%X]", severity);
        };
    }

    public static String getMatrixModeName(int mode) {
        return switch (mode) {
            case 5888 -> "MODELVIEW";
            case 5889 -> "PROJECTION";
            case 5890 -> "TEXTURE";
            case 6144 -> "COLOR";
            default -> String.format("0x%X", mode);
        };
    }

    public static String getCapabilityName(int cap) {
        return switch (cap) {
            case 3008 -> "ALPHA_TEST";
            case 3042 -> "BLEND";
            case 2903 -> "COLOR_MATERIAL";
            case 2884 -> "CULL_FACE";
            case 2929 -> "DEPTH_TEST";
            case 2912 -> "FOG";
            case 2896 -> "LIGHTING";
            case 2848 -> "LINE_SMOOTH";
            case 2977 -> "NORMALIZE";
            case 2832 -> "POINT_SMOOTH";
            case 32823 -> "POLYGON_OFFSET_FILL";
            case 10754 -> "POLYGON_OFFSET_LINE";
            case 2881 -> "POLYGON_SMOOTH";
            case 32826 -> "RESCALE_NORMAL";
            case 3089 -> "SCISSOR_TEST";
            case 2960 -> "STENCIL_TEST";
            case 3552 -> "TEXTURE_1D";
            case 3553 -> "TEXTURE_2D";
            case 16384 -> "LIGHT0";
            case 16385 -> "LIGHT1";
            case 16386 -> "LIGHT2";
            case 16387 -> "LIGHT3";
            case 16388 -> "LIGHT4";
            case 16389 -> "LIGHT5";
            case 16390 -> "LIGHT6";
            case 16391 -> "LIGHT7";
            default -> String.format("0x%X", cap);
        };
    }

    public static String getComparisonFuncName(int func) {
        return switch (func) {
            case 512 -> "NEVER";
            case 513 -> "LESS";
            case 514 -> "EQUAL";
            case 515 -> "LEQUAL";
            case 516 -> "GREATER";
            case 517 -> "NOTEQUAL";
            case 518 -> "GEQUAL";
            case 519 -> "ALWAYS";
            default -> String.format("0x%X", func);
        };
    }

    public static String getBlendFactorName(int factor) {
        return switch (factor) {
            case 0 -> "ZERO";
            case 1 -> "ONE";
            case 768 -> "SRC_COLOR";
            case 769 -> "ONE_MINUS_SRC_COLOR";
            case 774 -> "DST_COLOR";
            case 775 -> "ONE_MINUS_DST_COLOR";
            case 770 -> "SRC_ALPHA";
            case 771 -> "ONE_MINUS_SRC_ALPHA";
            case 772 -> "DST_ALPHA";
            case 773 -> "ONE_MINUS_DST_ALPHA";
            case 32769 -> "CONSTANT_COLOR";
            case 32770 -> "ONE_MINUS_CONSTANT_COLOR";
            case 32771 -> "CONSTANT_ALPHA";
            case 32772 -> "ONE_MINUS_CONSTANT_ALPHA";
            case 776 -> "SRC_ALPHA_SATURATE";
            default -> String.format("0x%X", factor);
        };
    }

    public static String getShadeModelName(int mode) {
        return switch (mode) {
            case 7424 -> "FLAT";
            case 7425 -> "SMOOTH";
            default -> String.format("0x%X", mode);
        };
    }

    public static String getTextureTargetName(int target) {
        return switch (target) {
            case 3552 -> "TEXTURE_1D";
            case 3553 -> "TEXTURE_2D";
            case 32879 -> "TEXTURE_3D";
            case 34067 -> "TEXTURE_CUBE_MAP";
            default -> String.format("0x%X", target);
        };
    }

    public static String getTexturePnameName(int pname) {
        return switch (pname) {
            case 10241 -> "TEXTURE_MIN_FILTER";
            case 10240 -> "TEXTURE_MAG_FILTER";
            case 10242 -> "TEXTURE_WRAP_S";
            case 10243 -> "TEXTURE_WRAP_T";
            case 32882 -> "TEXTURE_WRAP_R";
            case 33082 -> "TEXTURE_MIN_LOD";
            case 33083 -> "TEXTURE_MAX_LOD";
            case 33084 -> "TEXTURE_BASE_LEVEL";
            case 33085 -> "TEXTURE_MAX_LEVEL";
            case 4100 -> "TEXTURE_BORDER_COLOR";
            case 32870 -> "TEXTURE_PRIORITY";
            case 34049 -> "TEXTURE_LOD_BIAS";
            case 33169 -> "GENERATE_MIPMAP";
            default -> String.format("0x%X", pname);
        };
    }

    public static String getTextureFormatName(int format) {
        return switch (format) {
            case 6403 -> "RED";
            case 6404 -> "GREEN";
            case 6405 -> "BLUE";
            case 6406 -> "ALPHA";
            case 6407 -> "RGB";
            case 6408 -> "RGBA";
            case 6409 -> "LUMINANCE";
            case 6410 -> "LUMINANCE_ALPHA";
            case 32992 -> "BGR";
            case 32993 -> "BGRA";
            case 6402 -> "DEPTH_COMPONENT";
            case 6401 -> "STENCIL_INDEX";
            case 34041 -> "DEPTH_STENCIL";
            case 32849 -> "RGB8";
            case 32856 -> "RGBA8";
            case 32828 -> "ALPHA8";
            case 32832 -> "LUMINANCE8";
            case 32837 -> "LUMINANCE8_ALPHA8";
            default -> String.format("0x%X", format);
        };
    }

    public static String getDataTypeName(int type) {
        return switch (type) {
            case 5121 -> "UNSIGNED_BYTE";
            case 5120 -> "BYTE";
            case 5123 -> "UNSIGNED_SHORT";
            case 5122 -> "SHORT";
            case 5125 -> "UNSIGNED_INT";
            case 5124 -> "INT";
            case 5126 -> "FLOAT";
            case 5130 -> "DOUBLE";
            case 32818 -> "UNSIGNED_BYTE_3_3_2";
            case 32819 -> "UNSIGNED_SHORT_4_4_4_4";
            case 32820 -> "UNSIGNED_SHORT_5_5_5_1";
            case 32821 -> "UNSIGNED_INT_8_8_8_8";
            case 32822 -> "UNSIGNED_INT_10_10_10_2";
            default -> String.format("0x%X", type);
        };
    }

    public static String getLightName(int light) {
        return switch (light) {
            case 16384 -> "LIGHT0";
            case 16385 -> "LIGHT1";
            case 16386 -> "LIGHT2";
            case 16387 -> "LIGHT3";
            case 16388 -> "LIGHT4";
            case 16389 -> "LIGHT5";
            case 16390 -> "LIGHT6";
            case 16391 -> "LIGHT7";
            default -> String.format("0x%X", light);
        };
    }

    public static String getLightPnameName(int pname) {
        return switch (pname) {
            case 4608 -> "AMBIENT";
            case 4609 -> "DIFFUSE";
            case 4610 -> "SPECULAR";
            case 4611 -> "POSITION";
            case 4612 -> "SPOT_DIRECTION";
            case 4613 -> "SPOT_EXPONENT";
            case 4614 -> "SPOT_CUTOFF";
            case 4615 -> "CONSTANT_ATTENUATION";
            case 4616 -> "LINEAR_ATTENUATION";
            case 4617 -> "QUADRATIC_ATTENUATION";
            default -> String.format("0x%X", pname);
        };
    }

    public static String getMaterialPnameName(int pname) {
        return switch (pname) {
            case 4608 -> "AMBIENT";
            case 4609 -> "DIFFUSE";
            case 4610 -> "SPECULAR";
            case 5632 -> "EMISSION";
            case 5633 -> "SHININESS";
            case 5634 -> "AMBIENT_AND_DIFFUSE";
            case 5635 -> "COLOR_INDEXES";
            default -> String.format("0x%X", pname);
        };
    }

    public static String getFaceName(int face) {
        return switch (face) {
            case 1028 -> "FRONT";
            case 1029 -> "BACK";
            case 1032 -> "FRONT_AND_BACK";
            default -> String.format("0x%X", face);
        };
    }

    public static String getColorMaterialModeName(int mode) {
        return switch (mode) {
            case 4608 -> "AMBIENT";
            case 4609 -> "DIFFUSE";
            case 4610 -> "SPECULAR";
            case 5632 -> "EMISSION";
            case 5634 -> "AMBIENT_AND_DIFFUSE";
            default -> String.format("0x%X", mode);
        };
    }

    public static String getFogPnameName(int pname) {
        return switch (pname) {
            case 2917 -> "FOG_MODE";
            case 2914 -> "FOG_DENSITY";
            case 2915 -> "FOG_START";
            case 2916 -> "FOG_END";
            case 2913 -> "FOG_INDEX";
            case 2918 -> "FOG_COLOR";
            default -> String.format("0x%X", pname);
        };
    }

    public static String getLightModelPnameName(int pname) {
        return switch (pname) {
            case 2899 -> "LIGHT_MODEL_AMBIENT";
            case 2897 -> "LIGHT_MODEL_LOCAL_VIEWER";
            case 2898 -> "LIGHT_MODEL_TWO_SIDE";
            case 33272 -> "LIGHT_MODEL_COLOR_CONTROL";
            default -> String.format("0x%X", pname);
        };
    }

    public static String getClearMaskString(int mask) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        if ((mask & 0x4000) != 0) {
            sb.append("COLOR");
            first = false;
        }
        if ((mask & 0x100) != 0) {
            if (!first) {
                sb.append("|");
            }
            sb.append("DEPTH");
            first = false;
        }
        if ((mask & 0x400) != 0) {
            if (!first) {
                sb.append("|");
            }
            sb.append("STENCIL");
            first = false;
        }
        if ((mask & 0x200) != 0) {
            if (!first) {
                sb.append("|");
            }
            sb.append("ACCUM");
        }
        return sb.toString();
    }

    public static String getCullFaceName(int mode) {
        return switch (mode) {
            case 1028 -> "FRONT";
            case 1029 -> "BACK";
            case 1032 -> "FRONT_AND_BACK";
            default -> String.format("0x%X", mode);
        };
    }

    public static String getLogicOpName(int opcode) {
        return switch (opcode) {
            case 5376 -> "CLEAR";
            case 5377 -> "AND";
            case 5378 -> "AND_REVERSE";
            case 5379 -> "COPY";
            case 5380 -> "AND_INVERTED";
            case 5381 -> "NOOP";
            case 5382 -> "XOR";
            case 5383 -> "OR";
            case 5384 -> "NOR";
            case 5385 -> "EQUIV";
            case 5386 -> "INVERT";
            case 5387 -> "OR_REVERSE";
            case 5388 -> "COPY_INVERTED";
            case 5389 -> "OR_INVERTED";
            case 5390 -> "NAND";
            case 5391 -> "SET";
            default -> String.format("0x%X", opcode);
        };
    }

    public static String getFramebufferStatusName(int status) {
        return switch (status) {
            case 36053 -> "COMPLETE";
            case 36054 -> "INCOMPLETE_ATTACHMENT";
            case 36055 -> "INCOMPLETE_MISSING_ATTACHMENT";
            case 36059 -> "INCOMPLETE_DRAW_BUFFER";
            case 36060 -> "INCOMPLETE_READ_BUFFER";
            case 36061 -> "UNSUPPORTED";
            case 36182 -> "INCOMPLETE_MULTISAMPLE";
            case 0 -> "NO_FRAMEBUFFER_BOUND";
            default -> String.format("UNKNOWN(0x%X)", status);
        };
    }

    public static String getInternalFormatName(int format) {
        return switch (format) {
            case 6408 -> "RGBA";
            case 6407 -> "RGB";
            case 33321 -> "R8";
            case 33323 -> "RG8";
            case 32849 -> "RGB8";
            case 32856 -> "RGBA8";
            case 36756 -> "R8_SNORM";
            case 36757 -> "RG8_SNORM";
            case 36758 -> "RGB8_SNORM";
            case 36759 -> "RGBA8_SNORM";
            case 33322 -> "R16";
            case 33324 -> "RG16";
            case 32852 -> "RGB16";
            case 32859 -> "RGBA16";
            case 33325 -> "R16F";
            case 33327 -> "RG16F";
            case 34843 -> "RGB16F";
            case 34842 -> "RGBA16F";
            case 33326 -> "R32F";
            case 33328 -> "RG32F";
            case 34837 -> "RGB32F";
            case 34836 -> "RGBA32F";
            case 35898 -> "R11F_G11F_B10F";
            case 32857 -> "RGB10_A2";
            default -> String.format("0x%X", format);
        };
    }

    public static void initDebugState() {
        debugState = GLStateManager.capabilities.GL_KHR_debug || GLStateManager.capabilities.OpenGL43 ? new KHRDebugState() : new UnsupportedDebugState();
    }

    public static void nameObject(int id, int object, String name) {
        if (debugState != null && Thread.currentThread() == GLStateManager.getMainThread()) {
            debugState.nameObject(id, object, name);
        }
    }

    public static void pushGroup(String group) {
        if (debugState != null && Thread.currentThread() == GLStateManager.getMainThread()) {
            debugState.pushGroup(group);
        }
    }

    public static void popGroup() {
        if (debugState != null && Thread.currentThread() == GLStateManager.getMainThread()) {
            debugState.popGroup();
        }
    }

    public static void debugMessage(String message) {
        if (debugState != null && Thread.currentThread() == GLStateManager.getMainThread()) {
            debugState.debugMessage(message);
        }
    }

    public static String getObjectLabel(int glProgram, int program) {
        if (debugState != null && Thread.currentThread() == GLStateManager.getMainThread()) {
            return debugState.getObjectLabel(glProgram, program);
        }
        return "";
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class KHRDebugState
    implements DebugState {
        private static final int ID = 0;
        private int depth = 0;
        private static final int maxDepth = GL11.glGetInteger((int)33388);
        private static final int maxNameLength = GL11.glGetInteger((int)33512);

        private KHRDebugState() {
        }

        @Override
        public void nameObject(int id, int object, String name) {
            KHRDebug.glObjectLabel((int)id, (int)object, (CharSequence)name);
        }

        @Override
        public void pushGroup(String name) {
            ++this.depth;
            if (this.depth > maxDepth) {
                throw new RuntimeException("Stack overflow");
            }
            KHRDebug.glPushDebugGroup((int)33354, (int)0, (CharSequence)name);
        }

        @Override
        public void popGroup() {
            --this.depth;
            if (this.depth < 0) {
                throw new RuntimeException("Stack underflow");
            }
            KHRDebug.glPopDebugGroup();
        }

        @Override
        public void debugMessage(String message) {
            KHRDebug.glDebugMessageInsert((int)33354, (int)33384, (int)0, (int)33387, (CharSequence)message);
        }

        @Override
        public String getObjectLabel(int glProgram, int program) {
            if (program == 0) {
                return "";
            }
            return KHRDebug.glGetObjectLabel((int)glProgram, (int)program, (int)maxNameLength);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static interface DebugState {
        public void nameObject(int var1, int var2, String var3);

        public void pushGroup(String var1);

        public void popGroup();

        public void debugMessage(String var1);

        public String getObjectLabel(int var1, int var2);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class UnsupportedDebugState
    implements DebugState {
        private UnsupportedDebugState() {
        }

        @Override
        public void nameObject(int id, int object, String name) {
        }

        @Override
        public void pushGroup(String name) {
        }

        @Override
        public void popGroup() {
        }

        @Override
        public void debugMessage(String name) {
        }

        @Override
        public String getObjectLabel(int glProgram, int program) {
            return "";
        }
    }
}

