/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.debug;

import com.gtnewhorizon.gtnhlib.bytebuf.MemoryStack;
import com.gtnewhorizon.gtnhlib.client.renderer.shader.ShaderProgram;
import com.gtnewhorizons.angelica.glsm.GLStateManager;
import java.nio.FloatBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class F3Graph {
    private static final int NUM_SAMPLES = 240;
    private static final int VERT_FLOATS = 2;
    private static final int VERT_COUNT = 4;
    private static final int BORDER = 1;
    private static final int HEIGHT = 60;
    private static final int WIDTH = 240;
    private static final int FONT_COLOR = -2039584;
    private final FloatBuffer sampleBuf = BufferUtils.createFloatBuffer((int)240);
    private final long[] samples = new long[240];
    private int samplesHead = 0;
    private boolean initialized = false;
    private ShaderProgram shader;
    private int aPos;
    private int uFBWidth;
    private int uFBHeight;
    private int uScaleFactor;
    private int uHeadIdx;
    private int uSamples;
    private int vertBuf;
    private final ResourceLocation texture;
    private final float pxPerNs;
    private final boolean left;
    private long sum;

    protected F3Graph(ResourceLocation texture, float pxPerNs, boolean left) {
        this.texture = texture;
        this.pxPerNs = pxPerNs;
        this.left = left;
    }

    public void putSample(long time) {
        this.sum -= this.samples[this.samplesHead];
        this.sum += time;
        this.samples[this.samplesHead] = time;
        this.sampleBuf.put(this.samplesHead, time);
        this.samplesHead = (this.samplesHead + 1) % 240;
    }

    private int getVertX(ScaledResolution sres, int idx) {
        if (this.left) {
            return switch (idx) {
                case 0, 3 -> 242;
                case 1, 2 -> 0;
                default -> throw new RuntimeException("Tried to get out-of-bounds vertex for graph!");
            };
        }
        int displayWidth = sres.func_78326_a();
        return switch (idx) {
            case 0, 3 -> displayWidth;
            case 1, 2 -> displayWidth - 240 - 2;
            default -> throw new RuntimeException("Tried to get out-of-bounds vertex for graph!");
        };
    }

    private int getVertY(ScaledResolution sres, int idx) {
        int displayHeight = sres.func_78328_b();
        return switch (idx) {
            case 0, 1 -> displayHeight - 60 - 2;
            case 2, 3 -> displayHeight;
            default -> throw new RuntimeException("Tried to get out-of-bounds vertex for graph!");
        };
    }

    private void init() {
        this.shader = new ShaderProgram("angelica", "shaders/debug_graph.vert.glsl", "shaders/debug_graph.frag.glsl");
        this.shader.use();
        this.aPos = this.shader.getAttribLocation("pos");
        this.uFBWidth = this.shader.getUniformLocation("fbWidth");
        this.uFBHeight = this.shader.getUniformLocation("fbHeight");
        this.uScaleFactor = this.shader.getUniformLocation("scaleFactor");
        this.uSamples = this.shader.getUniformLocation("samples");
        this.uHeadIdx = this.shader.getUniformLocation("headIdx");
        int uPxPerNs = this.shader.getUniformLocation("pxPerNs");
        int uLeft = this.shader.getUniformLocation("left");
        this.vertBuf = GL15.glGenBuffers();
        GLStateManager.glBindBuffer(34962, this.vertBuf);
        try (MemoryStack stack = MemoryStack.stackPush();){
            FloatBuffer vertices = stack.mallocFloat(8);
            vertices.put(new float[]{1.0f, 1.0f, 241.0f, 1.0f, 1.0f, Float.MAX_VALUE, 241.0f, Float.MAX_VALUE});
            vertices.rewind();
            GL15.glBufferData((int)34962, (FloatBuffer)vertices, (int)35044);
        }
        GLStateManager.glBindBuffer(34962, 0);
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution sr = new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d);
        GL20.glUniform1f((int)this.uFBWidth, (float)mc.field_71443_c);
        GL20.glUniform1f((int)this.uFBHeight, (float)mc.field_71440_d);
        GL20.glUniform1f((int)this.uScaleFactor, (float)sr.func_78325_e());
        GL20.glUniform1i((int)this.uHeadIdx, (int)this.samplesHead);
        GL20.glUniform1((int)this.uSamples, (FloatBuffer)this.sampleBuf);
        GL20.glUniform1f((int)uPxPerNs, (float)this.pxPerNs);
        GL20.glUniform1i((int)uLeft, (int)(this.left ? 1 : 0));
        ShaderProgram.clear();
    }

    public void render() {
        if (!this.initialized) {
            this.init();
            this.initialized = true;
        }
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution sr = new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d);
        Tessellator tess = Tessellator.field_78398_a;
        GL11.glDisable((int)2929);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)3553);
        GL11.glColor4f((float)0.3137255f, (float)0.3137255f, (float)0.3137255f, (float)0.5647059f);
        tess.func_78382_b();
        for (int i = 0; i < 4; ++i) {
            tess.func_78377_a((double)this.getVertX(sr, i), (double)this.getVertY(sr, i), 0.0);
        }
        tess.func_78381_a();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3553);
        this.shader.use();
        GL20.glUniform1f((int)this.uFBWidth, (float)mc.field_71443_c);
        GL20.glUniform1f((int)this.uFBHeight, (float)mc.field_71440_d);
        GL20.glUniform1f((int)this.uScaleFactor, (float)sr.func_78325_e());
        GL20.glUniform1i((int)this.uHeadIdx, (int)this.samplesHead);
        GL20.glUniform1((int)this.uSamples, (FloatBuffer)this.sampleBuf);
        GLStateManager.glBindBuffer(34962, this.vertBuf);
        GL20.glEnableVertexAttribArray((int)this.aPos);
        GL20.glVertexAttribPointer((int)this.aPos, (int)2, (int)5126, (boolean)false, (int)8, (long)0L);
        GL11.glEnableClientState((int)32884);
        if (!this.left) {
            GL11.glDisable((int)2884);
        }
        GL11.glDrawArrays((int)5, (int)0, (int)4);
        if (!this.left) {
            GL11.glEnable((int)2884);
        }
        GL11.glDisableClientState((int)32884);
        GL20.glDisableVertexAttribArray((int)this.aPos);
        GLStateManager.glBindBuffer(34962, 0);
        ShaderProgram.clear();
        mc.func_110434_K().func_110577_a(this.texture);
        tess.func_78382_b();
        tess.func_78374_a((double)this.getVertX(sr, 0), (double)this.getVertY(sr, 0), 0.0, 1.0, 0.0);
        tess.func_78374_a((double)this.getVertX(sr, 1), (double)this.getVertY(sr, 1), 0.0, 0.0, 0.0);
        tess.func_78374_a((double)this.getVertX(sr, 2), (double)this.getVertY(sr, 2), 0.0, 0.0, 1.0);
        tess.func_78374_a((double)this.getVertX(sr, 3), (double)this.getVertY(sr, 3), 0.0, 1.0, 1.0);
        tess.func_78381_a();
        GL11.glEnable((int)2929);
        GL11.glDisable((int)3008);
        GL11.glDisable((int)3042);
        long min = Long.MAX_VALUE;
        long max = Long.MIN_VALUE;
        for (int i = 0; i < 240; ++i) {
            min = Math.min(min, this.samples[i]);
            max = Math.max(max, this.samples[i]);
        }
        String minStr = String.format("%.1f ms min", (double)min / 1000000.0);
        String avgStr = String.format("%.1f ms avg", (double)(this.sum / 1000000L) / 240.0);
        String maxStr = String.format("%.1f ms max", (double)max / 1000000.0);
        FontRenderer fr = mc.field_71466_p;
        int top = sr.func_78328_b() - 60 - 2 - fr.field_78288_b;
        int scaledWidth = sr.func_78326_a();
        if (this.left) {
            fr.func_85187_a(minStr, 2, top, -2039584, true);
            fr.func_85187_a(avgStr, 121 - fr.func_78256_a(avgStr) / 2, top, -2039584, true);
            fr.func_85187_a(maxStr, 242 - fr.func_78256_a(maxStr), top, -2039584, true);
        } else {
            fr.func_85187_a(minStr, scaledWidth - 242, top, -2039584, true);
            fr.func_85187_a(avgStr, scaledWidth - (121 + fr.func_78256_a(avgStr) / 2), top, -2039584, true);
            fr.func_85187_a(maxStr, scaledWidth - (2 + fr.func_78256_a(maxStr)), top, -2039584, true);
        }
    }
}

