/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.compat.toremove;

import com.google.common.collect.Queues;
import java.util.Deque;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import xyz.wagyourtail.jvmdg.j21.stub.java_base.J_U_SequencedCollection;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class MatrixStack {
    private final Deque<Entry> matrixStack = Queues.newArrayDeque();

    public MatrixStack() {
        this.matrixStack.add(new Entry(new Matrix4f().identity(), new Matrix3f().identity()));
    }

    public MatrixStack(Matrix4f initial) {
        Matrix3f normal = new Matrix3f();
        this.matrixStack.add(new Entry(initial, initial.normal(normal)));
    }

    public Entry peek() {
        return (Entry)J_U_SequencedCollection.getLast(this.matrixStack);
    }

    public void push() {
        Entry lv = (Entry)J_U_SequencedCollection.getLast(this.matrixStack);
        J_U_SequencedCollection.addLast(this.matrixStack, (Object)new Entry(new Matrix4f((Matrix4fc)lv.model), new Matrix3f((Matrix3fc)lv.normal)));
    }

    public void pop() {
        J_U_SequencedCollection.removeLast(this.matrixStack);
    }

    public boolean isEmpty() {
        return this.matrixStack.size() == 1;
    }

    public void reset() {
        while (this.matrixStack.size() > 1) {
            J_U_SequencedCollection.removeLast(this.matrixStack);
        }
        this.loadIdentity();
    }

    public void translate(double d, double e, double f) {
        Entry lv = (Entry)J_U_SequencedCollection.getLast(this.matrixStack);
        lv.model.translate((float)d, (float)e, (float)f);
    }

    public void rotateX(float f) {
        Entry lv = (Entry)J_U_SequencedCollection.getLast(this.matrixStack);
        lv.model.rotateX(f);
        lv.normal.rotateX(f);
    }

    public void rotateY(float f) {
        Entry lv = (Entry)J_U_SequencedCollection.getLast(this.matrixStack);
        lv.model.rotateY(f);
        lv.normal.rotateY(f);
    }

    public void rotateZ(float f) {
        Entry lv = (Entry)J_U_SequencedCollection.getLast(this.matrixStack);
        lv.model.rotateZ(f);
        lv.normal.rotateZ(f);
    }

    public void scale(float f, float g, float h) {
        Entry lv = (Entry)J_U_SequencedCollection.getLast(this.matrixStack);
        lv.model.scale(f, g, h);
        if (f == g && g == h) {
            if (f > 0.0f) {
                return;
            }
            lv.normal.scale(-1.0f);
        }
        float i = 1.0f / f;
        float j = 1.0f / g;
        float k = 1.0f / h;
        float l = MatrixStack.invSqrt(i * j * k);
        lv.normal.scale(l * i, l * j, l * k);
    }

    public void multiply(Quaternionf quaternion) {
        Entry entry = (Entry)J_U_SequencedCollection.getLast(this.matrixStack);
        entry.model.rotate((Quaternionfc)quaternion);
        entry.normal.rotate((Quaternionfc)quaternion);
    }

    public void multiply(Quaternionf quaternion, float originX, float originY, float originZ) {
        Entry entry = (Entry)J_U_SequencedCollection.getLast(this.matrixStack);
        entry.model.rotateAround((Quaternionfc)quaternion, originX, originY, originZ);
        entry.normal.rotate((Quaternionfc)quaternion);
    }

    public void loadIdentity() {
        Entry entry = (Entry)J_U_SequencedCollection.getLast(this.matrixStack);
        entry.model.identity();
        entry.normal.identity();
    }

    public void multiplyPositionMatrix(Matrix4f matrix) {
        ((Entry)J_U_SequencedCollection.getLast(this.matrixStack)).model.mul((Matrix4fc)matrix);
    }

    private static float invSqrt(float x) {
        float xhalf = 0.5f * x;
        int i = Float.floatToIntBits(x);
        i = 1597463007 - (i >> 1);
        x = Float.intBitsToFloat(i);
        x *= 1.5f - xhalf * x * x;
        return x;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static final class Entry {
        private final Matrix4f model;
        private final Matrix3f normal;

        private Entry(Matrix4f model, Matrix3f normal) {
            this.model = model;
            this.normal = normal;
        }

        public Matrix4f getModel() {
            return this.model;
        }

        public Matrix3f getNormal() {
            return this.normal;
        }
    }
}

