/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.compat.mojang;

import com.gtnewhorizon.gtnhlib.blockpos.BlockPos;
import com.gtnewhorizons.angelica.compat.mojang.ChunkOcclusionData;
import it.unimi.dsi.fastutil.ints.IntArrayFIFOQueue;
import java.util.BitSet;
import java.util.EnumSet;
import java.util.Set;
import net.minecraftforge.common.util.ForgeDirection;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class ChunkOcclusionDataBuilder {
    private static final int STEP_X = (int)Math.pow(16.0, 0.0);
    private static final int STEP_Z = (int)Math.pow(16.0, 1.0);
    private static final int STEP_Y = (int)Math.pow(16.0, 2.0);
    private static final ForgeDirection[] DIRECTIONS = ForgeDirection.VALID_DIRECTIONS;
    private final BitSet closed = new BitSet(4096);
    private static final int[] EDGE_POINTS = new int[1352];
    private int openCount = 4096;

    public void markClosed(BlockPos pos) {
        this.closed.set(ChunkOcclusionDataBuilder.pack(pos), true);
        --this.openCount;
    }

    private static int pack(BlockPos pos) {
        return ChunkOcclusionDataBuilder.pack(pos.getX() & 0xF, pos.getY() & 0xF, pos.getZ() & 0xF);
    }

    private static int pack(int x, int y, int z) {
        return x << 0 | y << 8 | z << 4;
    }

    public ChunkOcclusionData build() {
        ChunkOcclusionData lv = new ChunkOcclusionData();
        if (4096 - this.openCount < 256) {
            lv.fill(true);
        } else if (this.openCount == 0) {
            lv.fill(false);
        } else {
            for (int i : EDGE_POINTS) {
                if (this.closed.get(i)) continue;
                lv.addOpenEdgeFaces(this.getOpenFaces(i));
            }
        }
        return lv;
    }

    private Set<ForgeDirection> getOpenFaces(int pos) {
        EnumSet<ForgeDirection> set = EnumSet.noneOf(ForgeDirection.class);
        IntArrayFIFOQueue intPriorityQueue = new IntArrayFIFOQueue();
        intPriorityQueue.enqueue(pos);
        this.closed.set(pos, true);
        while (!intPriorityQueue.isEmpty()) {
            int j = intPriorityQueue.dequeueInt();
            this.addEdgeFaces(j, set);
            for (ForgeDirection lv : DIRECTIONS) {
                int k = this.offset(j, lv);
                if (k < 0 || this.closed.get(k)) continue;
                this.closed.set(k, true);
                intPriorityQueue.enqueue(k);
            }
        }
        return set;
    }

    private void addEdgeFaces(int pos, Set<ForgeDirection> openFaces) {
        int j = pos >> 0 & 0xF;
        if (j == 0) {
            openFaces.add(ForgeDirection.WEST);
        } else if (j == 15) {
            openFaces.add(ForgeDirection.EAST);
        }
        int k = pos >> 8 & 0xF;
        if (k == 0) {
            openFaces.add(ForgeDirection.DOWN);
        } else if (k == 15) {
            openFaces.add(ForgeDirection.UP);
        }
        int l = pos >> 4 & 0xF;
        if (l == 0) {
            openFaces.add(ForgeDirection.NORTH);
        } else if (l == 15) {
            openFaces.add(ForgeDirection.SOUTH);
        }
    }

    private int offset(int pos, ForgeDirection arg) {
        return switch (arg) {
            case ForgeDirection.DOWN -> {
                if ((pos >> 8 & 0xF) == 0) {
                    yield -1;
                }
                yield pos - STEP_Y;
            }
            case ForgeDirection.UP -> {
                if ((pos >> 8 & 0xF) == 15) {
                    yield -1;
                }
                yield pos + STEP_Y;
            }
            case ForgeDirection.NORTH -> {
                if ((pos >> 4 & 0xF) == 0) {
                    yield -1;
                }
                yield pos - STEP_Z;
            }
            case ForgeDirection.SOUTH -> {
                if ((pos >> 4 & 0xF) == 15) {
                    yield -1;
                }
                yield pos + STEP_Z;
            }
            case ForgeDirection.WEST -> {
                if ((pos >> 0 & 0xF) == 0) {
                    yield -1;
                }
                yield pos - STEP_X;
            }
            case ForgeDirection.EAST -> {
                if ((pos >> 0 & 0xF) == 15) {
                    yield -1;
                }
                yield pos + STEP_X;
            }
            default -> -1;
        };
    }

    static {
        int k = 0;
        for (int l = 0; l < 16; ++l) {
            for (int m = 0; m < 16; ++m) {
                for (int n = 0; n < 16; ++n) {
                    if (l != 0 && l != 15 && m != 0 && m != 15 && n != 0 && n != 15) continue;
                    ChunkOcclusionDataBuilder.EDGE_POINTS[k++] = ChunkOcclusionDataBuilder.pack(l, m, n);
                }
            }
        }
    }
}

