/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.commands;

import com.gtnewhorizons.angelica.debug.ChunkDebugMinimap;
import com.gtnewhorizons.angelica.rendering.celeritas.CeleritasDebugScreenHandler;
import com.gtnewhorizons.angelica.rendering.celeritas.CeleritasWorldRenderer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class AngelicaCommand
extends CommandBase {
    private static final List<String> SUBCOMMANDS = Arrays.asList("wireframe", "fog", "minimap", "help");

    public String func_71517_b() {
        return "angelica";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/angelica <wireframe|fog|minimap|help>";
    }

    public int func_82362_a() {
        return 0;
    }

    public List<String> func_71516_a(ICommandSender sender, String[] args) {
        if (args.length == 1) {
            return AngelicaCommand.func_71530_a((String[])args, (String[])SUBCOMMANDS.toArray(new String[0]));
        }
        return new ArrayList<String>();
    }

    public void func_71515_b(ICommandSender sender, String[] args) {
        if (args.length == 0) {
            this.sendHelp(sender);
            return;
        }
        switch (args[0].toLowerCase()) {
            case "wireframe": {
                this.handleWireframe(sender);
                break;
            }
            case "fog": {
                this.handleFog(sender);
                break;
            }
            case "minimap": {
                this.handleMinimap(sender);
                break;
            }
            default: {
                this.sendHelp(sender);
            }
        }
    }

    private void handleWireframe(ICommandSender sender) {
        CeleritasWorldRenderer.DEBUG_WIREFRAME_MODE = !CeleritasWorldRenderer.DEBUG_WIREFRAME_MODE;
        String state = CeleritasWorldRenderer.DEBUG_WIREFRAME_MODE ? "ON" : "OFF";
        sender.func_145747_a((IChatComponent)new ChatComponentText(String.valueOf(EnumChatFormatting.AQUA) + "[Angelica] " + String.valueOf(EnumChatFormatting.WHITE) + "Wireframe mode: " + state));
    }

    private void handleFog(ICommandSender sender) {
        CeleritasDebugScreenHandler.showFogDebug = !CeleritasDebugScreenHandler.showFogDebug;
        String f3State = CeleritasDebugScreenHandler.showFogDebug ? "ON" : "OFF";
        sender.func_145747_a((IChatComponent)new ChatComponentText(String.valueOf(EnumChatFormatting.AQUA) + "[Angelica] " + String.valueOf(EnumChatFormatting.WHITE) + "Fog debug (F3): " + f3State));
        sender.func_145747_a((IChatComponent)new ChatComponentText(String.valueOf(EnumChatFormatting.GRAY) + "  " + CeleritasDebugScreenHandler.getFogDebugString()));
    }

    private void handleMinimap(ICommandSender sender) {
        ChunkDebugMinimap.toggle();
        String state = ChunkDebugMinimap.isEnabled() ? "ON" : "OFF";
        sender.func_145747_a((IChatComponent)new ChatComponentText(String.valueOf(EnumChatFormatting.AQUA) + "[Angelica] " + String.valueOf(EnumChatFormatting.WHITE) + "Chunk debug minimap: " + state));
    }

    private void sendHelp(ICommandSender sender) {
        sender.func_145747_a((IChatComponent)new ChatComponentText(String.valueOf(EnumChatFormatting.AQUA) + "[Angelica] Debug Commands:"));
        sender.func_145747_a((IChatComponent)new ChatComponentText(String.valueOf(EnumChatFormatting.GRAY) + "  /angelica wireframe" + String.valueOf(EnumChatFormatting.WHITE) + " - Toggle wireframe rendering"));
        sender.func_145747_a((IChatComponent)new ChatComponentText(String.valueOf(EnumChatFormatting.GRAY) + "  /angelica fog" + String.valueOf(EnumChatFormatting.WHITE) + " - Toggle fog debug on F3"));
        sender.func_145747_a((IChatComponent)new ChatComponentText(String.valueOf(EnumChatFormatting.GRAY) + "  /angelica minimap" + String.valueOf(EnumChatFormatting.WHITE) + " - Toggle chunk debug overlay"));
    }

    public int compareTo(Object o) {
        if (o instanceof ICommand) {
            ICommand cmd = (ICommand)o;
            return this.func_71517_b().compareTo(cmd.func_71517_b());
        }
        return 0;
    }
}

