/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.client.gui;

import com.gtnewhorizon.gtnhlib.config.ConfigException;
import com.gtnewhorizon.gtnhlib.config.ConfigurationManager;
import com.gtnewhorizons.angelica.client.font.FontStrategist;
import com.gtnewhorizons.angelica.client.gui.SliderClone;
import com.gtnewhorizons.angelica.config.FontConfig;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.coderbot.iris.gui.element.widget.IrisButton;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiSlot;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.MathHelper;
import org.lwjgl.input.Keyboard;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class FontConfigScreen
extends GuiScreen {
    private static final Font[] availableFonts = FontStrategist.getAvailableFonts();
    private final GuiScreen parent;
    private final String title;
    private final String searchPrompt;
    private final String testAreaPrompt;
    private List<String> testAreaInfo;
    private List<String> noFontsWarning;
    private String currentPrimaryFontName;
    private String currentFallbackFontName;
    private FontList fontList;
    private int selectedPrimaryFontListPos = -1;
    private int selectedFallbackFontListPos = -1;
    private ArrayList<Font> displayedFonts;
    private GuiTextField searchBox;
    private GuiTextField testArea;
    private int sliderPages = 0;
    private int displayedSliderPage = 0;
    private final int sliderWidth = 160;
    private final int sliderHeight = 20;
    private IrisButton fwdButton;
    private IrisButton backButton;
    SliderClone.Option optFontQuality = new SliderClone.Option(6.0f, 72.0f, 6.0f);
    SliderClone.Option optShadowOffset = new SliderClone.Option(0.0f, 2.0f, 0.05f);
    SliderClone.Option optShadowCopies = new SliderClone.Option(1.0f, 8.0f, 1.0f);
    SliderClone.Option optBoldCopies = new SliderClone.Option(1.0f, 8.0f, 1.0f);
    SliderClone.Option optGlyphAspect = new SliderClone.Option(-1.0f, 1.0f, 0.05f);
    SliderClone.Option optGlyphScale = new SliderClone.Option(0.1f, 3.0f, 0.05f);
    SliderClone.Option optWhitespaceScale = new SliderClone.Option(0.1f, 3.0f, 0.05f);
    SliderClone.Option optGlyphSpacing = new SliderClone.Option(-2.0f, 2.0f, 0.05f);
    SliderClone.Option optFontAAMode = new SliderClone.Option(0.0f, 2.0f, 1.0f);
    SliderClone.Option optFontAAStrength = new SliderClone.Option(1.0f, 24.0f, 1.0f);
    SliderClone.Option optCustomFontScale = new SliderClone.Option(0.1f, 3.0f, 0.05f);
    private int qualityLast = FontConfig.customFontQuality;
    private float lastMouseX = 0.0f;
    private float lastMouseY = 0.0f;
    private long lastStillTime = 0L;

    public FontConfigScreen(GuiScreen parent) {
        this.title = I18n.func_135052_a((String)"options.angelica.fontconfig.title", (Object[])new Object[0]);
        this.searchPrompt = I18n.func_135052_a((String)"options.angelica.fontconfig.searchprompt", (Object[])new Object[0]);
        this.testAreaPrompt = I18n.func_135052_a((String)"options.angelica.fontconfig.testareaprompt", (Object[])new Object[0]);
        this.parent = parent;
        this.currentPrimaryFontName = FontConfig.customFontNamePrimary;
        this.currentFallbackFontName = FontConfig.customFontNameFallback;
        this.displayedFonts = new ArrayList<Font>(Arrays.asList(availableFonts));
        for (int i = 0; i < availableFonts.length; ++i) {
            if (Objects.equals(this.currentPrimaryFontName, availableFonts[i].getFontName())) {
                this.selectedPrimaryFontListPos = i;
            }
            if (!Objects.equals(this.currentFallbackFontName, availableFonts[i].getFontName())) continue;
            this.selectedFallbackFontListPos = i;
        }
    }

    public void func_73866_w_() {
        Keyboard.enableRepeatEvents((boolean)true);
        this.searchBox = new GuiTextField(this.field_146289_q, this.field_146294_l / 2 - 120, 24, 240, 20);
        this.searchBox.func_146203_f(64);
        this.fontList = new FontList(this);
        this.testArea = new GuiTextField(this.field_146289_q, this.field_146294_l * 5 / 6 - this.field_146294_l / 7, 53, this.field_146294_l * 2 / 7, 20);
        this.testArea.func_146203_f(512);
        this.testArea.func_146180_a(I18n.func_135052_a((String)"options.angelica.fontconfig.testareaexample", (Object[])new Object[0]));
        this.initButtons();
    }

    private void initButtons() {
        int halfWidth = this.field_146294_l / 2;
        int sliderSpacing = 4;
        int x1 = halfWidth - 160 - 4;
        int x2 = halfWidth;
        int x3 = halfWidth + 160 + 4;
        int y3 = this.field_146295_m - 65 + 48;
        this.field_146292_n.add(new IrisButton(x1 - 80, y3 - 10, 160, 20, FontConfig.enableCustomFont ? I18n.func_135052_a((String)"options.angelica.fontconfig.disable_custom_font", (Object[])new Object[0]) : I18n.func_135052_a((String)"options.angelica.fontconfig.enable_custom_font", (Object[])new Object[0]), this::toggleCustomFont));
        this.field_146292_n.add(new IrisButton(x2 - 80, y3 - 10, 160, 20, I18n.func_135052_a((String)"options.angelica.fontconfig.reset_values", (Object[])new Object[0]), this::resetValues));
        this.field_146292_n.add(new IrisButton(x3 - 80, y3 - 10, 160, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]), button -> this.onClose()));
        this.backButton = new IrisButton(halfWidth - 20 - 224, this.field_146295_m - 89 - 10, 40, 20, "<", button -> this.switchPage(-1));
        this.fwdButton = new IrisButton(halfWidth - 20 + 224, this.field_146295_m - 89 - 10, 40, 20, ">", button -> this.switchPage(1));
        this.field_146292_n.add(this.fwdButton);
        this.field_146292_n.add(this.backButton);
        this.initSliders();
    }

    private void initSliders() {
        ArrayList<SliderClone> sliders = new ArrayList<SliderClone>();
        sliders.add(new SliderClone.SliderCloneBuilder().width(160).height(20).option(this.optFontQuality).initialValue(FontConfig.customFontQuality).setter(this::setFontQuality).langKey("options.angelica.fontconfig.font_quality").formatString("%2.0f").build());
        sliders.add(new SliderClone.SliderCloneBuilder().width(160).height(20).option(this.optShadowOffset).initialValue(FontConfig.fontShadowOffset).setter(value -> {
            FontConfig.fontShadowOffset = value.floatValue();
        }).langKey("options.angelica.fontconfig.shadow_offset").formatString("x%3.2f").build());
        sliders.add(new SliderClone.SliderCloneBuilder().width(160).height(20).option(this.optGlyphAspect).initialValue(FontConfig.glyphAspect).setter(value -> {
            FontConfig.glyphAspect = value.floatValue();
        }).langKey("options.angelica.fontconfig.glyph_aspect").build());
        sliders.add(new SliderClone.SliderCloneBuilder().width(160).height(20).option(this.optGlyphScale).initialValue(FontConfig.glyphScale).setter(value -> {
            FontConfig.glyphScale = value.floatValue();
        }).langKey("options.angelica.fontconfig.glyph_scale").formatString("x%3.2f").build());
        sliders.add(new SliderClone.SliderCloneBuilder().width(160).height(20).option(this.optFontAAStrength).initialValue(FontConfig.fontAAStrength).setter(value -> {
            FontConfig.fontAAStrength = value.intValue();
        }).langKey("options.angelica.fontconfig.font_aa_strength").formatString("%.0f").build());
        sliders.add(new SliderClone.SliderCloneBuilder().width(160).height(20).option(this.optFontAAMode).initialValue(FontConfig.fontAAMode).setter(value -> {
            FontConfig.fontAAMode = value.intValue();
        }).formatter(this::fontAAModeFormat).langKey("options.angelica.fontconfig.aamode").build());
        sliders.add(new SliderClone.SliderCloneBuilder().width(160).height(20).option(this.optWhitespaceScale).initialValue(FontConfig.whitespaceScale).setter(value -> {
            FontConfig.whitespaceScale = value.floatValue();
        }).langKey("options.angelica.fontconfig.whitespace_scale").formatString("x%3.2f").build());
        sliders.add(new SliderClone.SliderCloneBuilder().width(160).height(20).option(this.optGlyphSpacing).initialValue(FontConfig.glyphSpacing).setter(value -> {
            FontConfig.glyphSpacing = value.floatValue();
        }).langKey("options.angelica.fontconfig.glyph_spacing").build());
        sliders.add(new SliderClone.SliderCloneBuilder().width(160).height(20).option(this.optShadowCopies).initialValue(FontConfig.shadowCopies).setter(value -> {
            FontConfig.shadowCopies = value.intValue();
        }).langKey("options.angelica.fontconfig.shadow_copies").formatString("%.0f").build());
        sliders.add(new SliderClone.SliderCloneBuilder().width(160).height(20).option(this.optBoldCopies).initialValue(FontConfig.boldCopies).setter(value -> {
            FontConfig.boldCopies = value.intValue();
        }).langKey("options.angelica.fontconfig.bold_copies").formatString("%.0f").build());
        sliders.add(new SliderClone.SliderCloneBuilder().width(160).height(20).option(this.optCustomFontScale).initialValue(FontConfig.customFontScale).setter(value -> {
            FontConfig.customFontScale = value.floatValue();
        }).langKey("options.angelica.fontconfig.custom_font_scale").formatString("x%3.2f").build());
        int halfWidth = this.field_146294_l / 2;
        int sliderSpacing = 4;
        int x1 = halfWidth - 160 - 4;
        int x2 = halfWidth;
        int x3 = halfWidth + 160 + 4;
        int y1 = this.field_146295_m - 65;
        int y2 = this.field_146295_m - 65 + 20 + 4;
        this.sliderPages = sliders.size() / 6;
        this.displayedSliderPage = Math.min(this.displayedSliderPage, this.sliderPages);
        this.backButton.field_146124_l = this.displayedSliderPage != 0;
        this.fwdButton.field_146124_l = this.displayedSliderPage != this.sliderPages;
        int start = 6 * this.displayedSliderPage;
        int end = Math.min(6 * (this.displayedSliderPage + 1), sliders.size());
        List s = sliders.subList(start, end);
        try {
            ((SliderClone)((Object)s.get(0))).setCenterPosition(x1, y1);
            ((SliderClone)((Object)s.get(1))).setCenterPosition(x1, y2);
            ((SliderClone)((Object)s.get(2))).setCenterPosition(x2, y1);
            ((SliderClone)((Object)s.get(3))).setCenterPosition(x2, y2);
            ((SliderClone)((Object)s.get(4))).setCenterPosition(x3, y1);
            ((SliderClone)((Object)s.get(5))).setCenterPosition(x3, y2);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        this.field_146292_n.addAll(s);
    }

    private void onClose() {
        this.applyChanges(true);
        this.field_146297_k.func_147108_a(this.parent);
    }

    private void applyChanges(boolean finalApply) {
        int pos = this.selectedPrimaryFontListPos;
        if (pos >= 0 && pos < this.displayedFonts.size()) {
            FontConfig.customFontNamePrimary = this.displayedFonts.get(pos).getFontName();
        }
        if ((pos = this.selectedFallbackFontListPos) >= 0 && pos < this.displayedFonts.size()) {
            FontConfig.customFontNameFallback = this.displayedFonts.get(pos).getFontName();
        }
        FontStrategist.reloadCustomFontProviders();
        if (finalApply) {
            ConfigurationManager.save((Class[])new Class[]{FontConfig.class});
        }
    }

    private void resetValues(IrisButton button) {
        try {
            ConfigurationManager.getConfigElements(FontConfig.class).forEach(elem -> elem.set(elem.getDefault()));
        }
        catch (ConfigException e) {
            throw new RuntimeException(e);
        }
        this.currentPrimaryFontName = null;
        this.currentFallbackFontName = null;
        this.selectedPrimaryFontListPos = -1;
        this.selectedFallbackFontListPos = -1;
        this.field_146292_n.clear();
        this.initButtons();
    }

    private void toggleCustomFont(IrisButton button) {
        FontConfig.enableCustomFont = !FontConfig.enableCustomFont;
        this.applyChanges(false);
        button.field_146126_j = FontConfig.enableCustomFont ? I18n.func_135052_a((String)"options.angelica.fontconfig.disable_custom_font", (Object[])new Object[0]) : I18n.func_135052_a((String)"options.angelica.fontconfig.enable_custom_font", (Object[])new Object[0]);
    }

    private void switchPage(int offset) {
        this.displayedSliderPage = MathHelper.func_76125_a((int)(this.displayedSliderPage + offset), (int)0, (int)this.sliderPages);
        this.field_146292_n.removeIf(guiButton -> guiButton instanceof SliderClone);
        this.initSliders();
    }

    private void setFontQuality(float quality) {
        FontConfig.customFontQuality = (int)quality;
        if (this.qualityLast != (int)quality) {
            this.applyChanges(false);
        }
        this.qualityLast = (int)quality;
    }

    private String fontAAModeFormat(float AAmode) {
        return switch ((int)AAmode) {
            case 2 -> I18n.func_135052_a((String)"options.angelica.fontconfig.aamode.aa_16x", (Object[])new Object[0]);
            case 1 -> I18n.func_135052_a((String)"options.angelica.fontconfig.aamode.aa_4x", (Object[])new Object[0]);
            default -> I18n.func_135052_a((String)"options.angelica.fontconfig.aamode.aa_none", (Object[])new Object[0]);
        };
    }

    public void func_73863_a(int mouseX, int mouseY, float delta) {
        this.func_146278_c(0);
        this.fontList.func_148128_a(mouseX, mouseY, delta);
        if (availableFonts.length == 0) {
            if (this.noFontsWarning == null) {
                this.noFontsWarning = this.field_146289_q.func_78271_c(I18n.func_135052_a((String)"options.angelica.fontconfig.no_fonts_warning", (Object[])new Object[0]), this.field_146294_l / 2);
            }
            int y = 80;
            for (String s : this.noFontsWarning) {
                this.func_73732_a(this.field_146289_q, s, this.field_146294_l / 3, y, 0xFFFFFF);
                y += this.field_146289_q.field_78288_b;
            }
        }
        this.searchBox.func_146194_f();
        if (!this.searchBox.func_146206_l() && this.searchBox.func_146179_b().isEmpty()) {
            this.func_73732_a(this.field_146289_q, this.searchPrompt, this.searchBox.field_146209_f + this.field_146289_q.func_78256_a(this.searchPrompt) / 2 + 4, this.searchBox.field_146210_g + this.searchBox.field_146219_i / 2 - 4, 0xFFFFFF);
        }
        this.func_73732_a(this.field_146289_q, this.title, (int)((double)this.field_146294_l * 0.5), 8, 0xFFFFFF);
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"options.angelica.fontconfig.currentfonts", (Object[])new Object[]{FontConfig.customFontNamePrimary, FontConfig.customFontNameFallback}), (int)((double)this.field_146294_l * 0.5), this.field_146295_m - 92, 0xFFFFFF);
        if (this.testAreaInfo == null) {
            this.testAreaInfo = this.field_146289_q.func_78271_c(I18n.func_135052_a((String)"options.angelica.fontconfig.testareainfo", (Object[])new Object[0]), this.field_146294_l / 4);
        }
        int cumulativeY = 73;
        for (String s : this.testAreaInfo) {
            this.func_73732_a(this.field_146289_q, s, this.field_146294_l * 5 / 6, cumulativeY, 0xFFFFFF);
            cumulativeY += this.field_146289_q.field_78288_b;
        }
        this.testArea.field_146210_g = cumulativeY += 4;
        this.testArea.func_146194_f();
        if (!this.testArea.func_146206_l() && this.testArea.func_146179_b().isEmpty()) {
            this.func_73732_a(this.field_146289_q, this.testAreaPrompt, this.testArea.field_146209_f + this.field_146289_q.func_78256_a(this.testAreaPrompt) / 2 + 4, this.testArea.field_146210_g + this.testArea.field_146219_i / 2 - 4, 0xFFFFFF);
        }
        List testText = this.field_146289_q.func_78271_c(this.testArea.func_146179_b().replace('&', '\u00a7'), this.field_146294_l / 4);
        cumulativeY += this.testArea.field_146219_i + 4;
        for (String s : testText) {
            this.func_73732_a(this.field_146289_q, s, this.field_146294_l * 5 / 6, cumulativeY, 0xFFFFFF);
            cumulativeY += this.field_146289_q.field_78288_b;
        }
        super.func_73863_a(mouseX, mouseY, delta);
        for (GuiButton guiButton : this.field_146292_n) {
            if (!(guiButton instanceof SliderClone)) continue;
            SliderClone slider = (SliderClone)guiButton;
            int top = slider.field_146129_i;
            int bot = slider.field_146129_i + slider.field_146121_g;
            int left = slider.field_146128_h;
            int right = slider.field_146128_h + slider.field_146120_f;
            if (mouseY < top || mouseY >= bot || mouseX < left || mouseX >= right) continue;
            if ((float)mouseX == this.lastMouseX && (float)mouseY == this.lastMouseY) {
                if (this.lastStillTime == 0L) {
                    this.lastStillTime = System.currentTimeMillis();
                }
                if (this.lastStillTime + 500L >= System.currentTimeMillis()) break;
                this.displayTooltip(mouseX, mouseY, slider.tooltipKey);
                break;
            }
            this.lastStillTime = 0L;
            break;
        }
        this.lastMouseX = mouseX;
        this.lastMouseY = mouseY;
    }

    private void displayTooltip(int x, int y, String langKey) {
        List lines = this.field_146289_q.func_78271_c(I18n.func_135052_a((String)langKey, (Object[])new Object[0]), this.field_146294_l / 2);
        this.drawHoveringText(lines, x, y, this.field_146289_q);
    }

    protected void func_146284_a(GuiButton guiButton) {
        if (guiButton.field_146124_l && guiButton instanceof IrisButton) {
            IrisButton irisButton = (IrisButton)guiButton;
            irisButton.onPress();
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) {
        if (this.searchBox.func_146206_l()) {
            if (keyCode == 1) {
                this.searchBox.func_146195_b(false);
                return;
            }
            this.searchBox.func_146201_a(typedChar, keyCode);
            this.displayedFonts = this.filterFonts(this.searchBox.func_146179_b().toLowerCase());
        }
        if (this.testArea.func_146206_l()) {
            if (keyCode == 1) {
                this.testArea.func_146195_b(false);
                return;
            }
            this.testArea.func_146201_a(typedChar, keyCode);
        }
        if (keyCode == 1) {
            this.onClose();
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.searchBox.func_146192_a(mouseX, mouseY, mouseButton);
        this.testArea.func_146192_a(mouseX, mouseY, mouseButton);
        this.fontList.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public void func_73876_c() {
        this.searchBox.func_146178_a();
        this.testArea.func_146178_a();
    }

    private ArrayList<Font> filterFonts(String search) {
        ArrayList results = search == null || search.isEmpty() ? new ArrayList(Arrays.asList(availableFonts)) : Arrays.stream(availableFonts).filter(font -> font.getFontName().toLowerCase().contains(search)).collect(Collectors.toCollection(ArrayList::new));
        this.selectedPrimaryFontListPos = -1;
        this.selectedFallbackFontListPos = -1;
        for (int i = 0; i < results.size(); ++i) {
            if (Objects.equals(this.currentPrimaryFontName, ((Font)results.get(i)).getFontName())) {
                this.selectedPrimaryFontListPos = i;
            }
            if (!Objects.equals(this.currentFallbackFontName, ((Font)results.get(i)).getFontName())) continue;
            this.selectedFallbackFontListPos = i;
        }
        return results;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    class FontList
    extends GuiSlot {
        final /* synthetic */ FontConfigScreen this$0;

        public FontList(FontConfigScreen this$0) {
            FontConfigScreen fontConfigScreen = this$0;
            Objects.requireNonNull(fontConfigScreen);
            this.this$0 = fontConfigScreen;
            super(this$0.field_146297_k, this$0.field_146294_l * 2 / 3, this$0.field_146295_m, 52, this$0.field_146295_m - 102, 18);
        }

        private void mouseClicked(int mouseX, int mouseY, int mouseButton) {
            if (mouseY < this.field_148153_b || mouseY > this.field_148154_c) {
                return;
            }
            int listLeftBound = this.field_148155_a / 2 - this.func_148139_c() / 2;
            int listRightBound = this.field_148155_a / 2 + this.func_148139_c() / 2;
            if (mouseX < listLeftBound || mouseX > listRightBound) {
                return;
            }
            int mousePosInList = mouseY - this.field_148153_b - this.field_148160_j + (int)this.field_148169_q - 4;
            int slotIndex = mousePosInList / this.field_148149_f;
            if (slotIndex < 0 || slotIndex >= this.func_148127_b()) {
                return;
            }
            if (mouseButton == 0) {
                this.onElemClicked(slotIndex, false);
            } else if (mouseButton == 1) {
                this.onElemClicked(slotIndex, true);
            }
        }

        protected void onElemClicked(int index, boolean rightClick) {
            if (!rightClick) {
                this.this$0.selectedPrimaryFontListPos = index;
                this.this$0.currentPrimaryFontName = this.this$0.displayedFonts.get(index).getFontName();
            } else {
                this.this$0.selectedFallbackFontListPos = index;
                this.this$0.currentFallbackFontName = this.this$0.displayedFonts.get(index).getFontName();
            }
            this.this$0.applyChanges(false);
        }

        protected boolean func_148131_a(int index) {
            return index == this.this$0.selectedPrimaryFontListPos || index == this.this$0.selectedFallbackFontListPos;
        }

        protected int func_148127_b() {
            return this.this$0.displayedFonts.size();
        }

        protected int func_148138_e() {
            return this.func_148127_b() * 18;
        }

        protected int func_148137_d() {
            return this.field_148155_a * 15 / 16 - 5;
        }

        public int func_148139_c() {
            return this.field_148155_a * 2 / 3;
        }

        protected void func_148144_a(int index, boolean doubleClicked, int mouseX, int mouseY) {
        }

        protected void func_148123_a() {
        }

        protected void func_148126_a(int index, int x, int y, int p_148126_4_, Tessellator tessellator, int p_148126_6_, int p_148126_7_) {
            int color = 0xFFFFFF;
            if (index == this.this$0.selectedPrimaryFontListPos) {
                color &= 0xFFFF55;
            }
            if (index == this.this$0.selectedFallbackFontListPos) {
                color &= 0x55FFFF;
            }
            this.this$0.func_73732_a(this.this$0.field_146289_q, this.this$0.displayedFonts.get(index).getFontName(), this.field_148155_a / 2, y + 1, color);
        }
    }
}

