/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.client.gui;

import com.google.common.collect.ImmutableList;
import com.gtnewhorizons.angelica.dynamiclights.DynamicLights;
import com.gtnewhorizons.angelica.dynamiclights.config.EntityLightConfig;
import com.gtnewhorizons.angelica.dynamiclights.config.EntityLightConfigStorage;
import com.gtnewhorizons.angelica.dynamiclights.config.EntityTypeEntry;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jss.notfine.core.Settings;
import me.jellysquid.mods.sodium.client.gui.options.Option;
import me.jellysquid.mods.sodium.client.gui.options.OptionGroup;
import me.jellysquid.mods.sodium.client.gui.options.OptionImpact;
import me.jellysquid.mods.sodium.client.gui.options.OptionImpl;
import me.jellysquid.mods.sodium.client.gui.options.OptionPage;
import me.jellysquid.mods.sodium.client.gui.options.control.TickBoxControl;
import net.minecraft.client.resources.I18n;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class DynamicLightsOptionPages {
    public static OptionPage dynamicLights() {
        if (!DynamicLights.configEnabled) {
            return null;
        }
        ArrayList<OptionGroup> groups = new ArrayList<OptionGroup>();
        groups.add(OptionGroup.createBuilder().add(Settings.DYNAMIC_LIGHTS.option).add(Settings.DYNAMIC_LIGHTS_SHADER_FORCE.option).build());
        groups.add(OptionGroup.createBuilder().add(Settings.DYNAMIC_LIGHTS_FRUSTUM_CULLING.option).add(Settings.DYNAMIC_LIGHTS_ADAPTIVE_TICKING.option).add(Settings.DYNAMIC_LIGHTS_CULL_TIMEOUT.option).build());
        groups.add(OptionGroup.createBuilder().add(Settings.DYNAMIC_LIGHTS_SLOW_DIST.option).add(Settings.DYNAMIC_LIGHTS_SLOWER_DIST.option).add(Settings.DYNAMIC_LIGHTS_BACKGROUND_DIST.option).build());
        List<EntityTypeEntry> allEntities = EntityLightConfig.getAllEntityTypes();
        LinkedHashMap<String, List> byMod = new LinkedHashMap<String, List>();
        for (EntityTypeEntry entityTypeEntry : allEntities) {
            byMod.computeIfAbsent(entityTypeEntry.getModId(), string -> new ArrayList()).add(entityTypeEntry);
        }
        for (Map.Entry entry : byMod.entrySet()) {
            String modId = (String)entry.getKey();
            List entities = (List)entry.getValue();
            OptionGroup.Builder groupBuilder = OptionGroup.createBuilder();
            for (EntityTypeEntry entity : entities) {
                Option<Boolean> option = DynamicLightsOptionPages.createEntityOption(entity);
                if (option == null) continue;
                groupBuilder.add(option);
            }
            OptionGroup group = groupBuilder.build();
            if (group.getOptions().isEmpty()) continue;
            groups.add(group);
        }
        return new OptionPage(I18n.func_135052_a((String)"options.dynamiclights.page", (Object[])new Object[0]), (ImmutableList<OptionGroup>)ImmutableList.copyOf(groups));
    }

    private static Option<Boolean> createEntityOption(EntityTypeEntry entry) {
        Class<?> resolvedClass;
        String className = entry.getClassName();
        try {
            resolvedClass = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        Class<?> entityClass = resolvedClass;
        return OptionImpl.createBuilder(Boolean.class, EntityLightConfigStorage.INSTANCE).setName(entry.getDisplayName() + " (" + entry.getModId() + ")").setTooltip(I18n.func_135052_a((String)"options.dynamiclights.entity.tooltip", (Object[])new Object[]{entry.getDisplayName()})).setControl(TickBoxControl::new).setBinding((entityLightConfigStorage, value) -> EntityLightConfig.setEntityTypeEnabled(entityClass, value), storage -> EntityLightConfig.isEntityTypeEnabled(entityClass)).setImpact(OptionImpact.LOW).build();
    }
}

