/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.client.font;

import com.gtnewhorizons.angelica.client.font.FontProvider;
import com.gtnewhorizons.angelica.config.FontConfig;
import net.minecraft.util.ResourceLocation;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class FontProviderUnicode
implements FontProvider {
    private static final ResourceLocation[] unicodePageLocations = new ResourceLocation[256];
    public byte[] glyphWidth;

    private FontProviderUnicode() {
    }

    public static FontProviderUnicode get() {
        return InstLoader.instance;
    }

    private ResourceLocation getUnicodePageLocation(int page) {
        ResourceLocation lookup = unicodePageLocations[page];
        if (lookup == null) {
            ResourceLocation rl;
            FontProviderUnicode.unicodePageLocations[page] = rl = new ResourceLocation(String.format("textures/font/unicode_page_%02x.png", page));
            return rl;
        }
        return lookup;
    }

    @Override
    public boolean isGlyphAvailable(char chr) {
        return true;
    }

    @Override
    public char getRandomReplacement(char chr) {
        return chr;
    }

    @Override
    public float getUStart(char chr) {
        float startColumnF = this.glyphWidth[chr] >>> 4 & 0xF;
        return ((float)(chr % 16 * 16) + startColumnF + 0.21f) / 256.0f;
    }

    @Override
    public float getVStart(char chr) {
        return ((float)((chr & 0xFF) / 16 * 16) + 0.21f) / 256.0f;
    }

    @Override
    public float getXAdvance(char chr) {
        int startColumn = this.glyphWidth[chr] >>> 4 & 0xF;
        int endColumn = this.glyphWidth[chr] & 0xF;
        float startColumnF = startColumn;
        float endColumnF = endColumn + 1;
        return (endColumnF - startColumnF) / 2.0f + 1.0f;
    }

    @Override
    public float getGlyphW(char chr) {
        int startColumn = this.glyphWidth[chr] >>> 4 & 0xF;
        int endColumn = this.glyphWidth[chr] & 0xF;
        float startColumnF = startColumn;
        float endColumnF = endColumn + 1;
        float chrWidth = endColumnF - startColumnF - 0.02f;
        return chrWidth / 2.0f + 1.0f;
    }

    @Override
    public float getUSize(char chr) {
        int startColumn = this.glyphWidth[chr] >>> 4 & 0xF;
        int endColumn = this.glyphWidth[chr] & 0xF;
        float startColumnF = startColumn;
        float endColumnF = endColumn + 1;
        float chrWidth = endColumnF - startColumnF - 0.02f;
        return (chrWidth - 0.42f) / 256.0f;
    }

    @Override
    public float getVSize(char chr) {
        return 0.060859375f;
    }

    @Override
    public float getShadowOffset() {
        return FontConfig.fontShadowOffset;
    }

    @Override
    public ResourceLocation getTexture(char chr) {
        int uniPage = chr / 256;
        return this.getUnicodePageLocation(uniPage);
    }

    @Override
    public float getYScaleMultiplier() {
        return 1.0f;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class InstLoader {
        static final FontProviderUnicode instance = new FontProviderUnicode();

        private InstLoader() {
        }
    }
}

