/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.crossmod.extracells;

import appeng.api.AEApi;
import appeng.api.definitions.IItemDefinition;
import appeng.api.storage.ICellHandler;
import com.glodblock.github.common.item.ItemBaseWirelessTerminal;
import com.glodblock.github.common.item.ItemMultiFluidStorageCell;
import com.glodblock.github.crossmod.extracells.ProxyItem;
import com.glodblock.github.crossmod.extracells.ProxyPart;
import com.glodblock.github.crossmod.extracells.ProxyPartItem;
import com.glodblock.github.crossmod.extracells.parts.ProxyFluidBusIO;
import com.glodblock.github.crossmod.extracells.parts.ProxyFluidInterface;
import com.glodblock.github.crossmod.extracells.parts.ProxyFluidStorage;
import com.glodblock.github.crossmod.extracells.parts.ProxyLevelEmitter;
import com.glodblock.github.crossmod.extracells.parts.ProxyOreDictExportBus;
import com.glodblock.github.crossmod.extracells.parts.ProxyStorageMonitor;
import com.glodblock.github.crossmod.extracells.storage.ProxyExtremeStorageCell;
import com.glodblock.github.crossmod.extracells.storage.ProxyFluidStorageCell;
import com.glodblock.github.crossmod.extracells.storage.ProxyItemCellHandler;
import com.glodblock.github.crossmod.extracells.storage.ProxyItemStorageCell;
import com.glodblock.github.crossmod.extracells.storage.ProxyVoidCellHandler;
import com.glodblock.github.crossmod.extracells.storage.ProxyVoidStorageCell;
import com.glodblock.github.loader.ItemAndBlockHolder;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import li.cil.oc.api.Items;
import li.cil.oc.api.detail.ItemInfo;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ItemReplacements {
    protected static Map<String, Item> registry;

    static void postinit() {
        registry = new HashMap<String, Item>(23);
        ProxyFluidBusIO.init();
        ItemReplacements.proxyItems();
        ItemReplacements.proxyPartItems();
        if (Loader.isModLoaded((String)"OpenComputers")) {
            ItemReplacements.deprecateOC();
        }
    }

    static void proxyItems() {
        ItemReplacements.deprecateFluidStorage("storage.fluid", 0, ItemAndBlockHolder.CELL1KM, 1L, 8, 0.5);
        ItemReplacements.deprecateFluidStorage("storage.fluid", 1, ItemAndBlockHolder.CELL4KM, 4L, 32, 1.0);
        ItemReplacements.deprecateFluidStorage("storage.fluid", 2, ItemAndBlockHolder.CELL16KM, 16L, 128, 1.5);
        ItemReplacements.deprecateFluidStorage("storage.fluid", 3, ItemAndBlockHolder.CELL64KM, 64L, 512, 2.0);
        ItemReplacements.deprecateFluidStorage("storage.fluid", 4, ItemAndBlockHolder.CELL256KM, 256L, 2048, 2.5);
        ItemReplacements.deprecateFluidStorage("storage.fluid", 5, ItemAndBlockHolder.CELL1024KM, 1024L, 8192, 3.0);
        ItemReplacements.deprecateFluidStorage("storage.fluid", 6, ItemAndBlockHolder.CELL4096KM, 4096L, 32768, 3.5);
        ItemReplacements.deprecateFluidStorage("storage.fluid", 7, ItemAndBlockHolder.CELL16384KM, 16384L, 131072, 4.0);
        AEApi.instance().registries().cell().addCellHandler((ICellHandler)new ProxyItemCellHandler());
        AEApi.instance().registries().cell().addCellHandler((ICellHandler)new ProxyVoidCellHandler());
        ItemReplacements.deprecateItemStorage(0, AEApi.instance().definitions().items().cell256k(), 256L, 2048, 2.5);
        ItemReplacements.deprecateItemStorage(1, AEApi.instance().definitions().items().cell1024k(), 1024L, 8192, 3.0);
        ItemReplacements.deprecateItemStorage(2, AEApi.instance().definitions().items().cell4096k(), 4096L, 32768, 3.5);
        ItemReplacements.deprecateItemStorage(3, AEApi.instance().definitions().items().cell16384k(), 16384L, 131072, 4.0);
        ItemReplacements.deprecateItemStorage(4, AEApi.instance().definitions().items().cellContainer(), 65536L, 8, 2.0, 1);
        ItemReplacements.deprecateExtremeStorage("storage.physical.advanced.quantum", 0, AEApi.instance().definitions().items().cellQuantum(), 0x7FFFFFFL, 4096, 1000.0);
        ItemReplacements.deprecateExtremeStorage("storage.physical.advanced.singularity", 0, AEApi.instance().definitions().items().cellSingularity(), 0x7FFFFFFFFFFFFFFL, 4096, 15000.0);
        ProxyVoidStorageCell voidCell = new ProxyVoidStorageCell();
        GameRegistry.registerItem((Item)voidCell, (String)"ec2placeholder.storage.physical.void");
        registry.put("extracells:storage.physical.void", (Item)voidCell);
        ItemReplacements.deprecateItem("pattern.fluid", (Item)ItemAndBlockHolder.PATTERN);
        ItemReplacements.deprecateWireless("terminal.fluid.wireless", ItemAndBlockHolder.WIRELESS_FLUID_TERM);
        ItemReplacements.deprecateItem("storage.casing", 0, AEApi.instance().definitions().materials().emptyAdvancedStorageCell());
        ItemReplacements.deprecateItem("storage.casing", 1, ItemAndBlockHolder.CELL_HOUSING, 2);
        ItemReplacements.deprecateItem("storage.component", 0, AEApi.instance().definitions().materials().cell256kPart());
        ItemReplacements.deprecateItem("storage.component", 1, AEApi.instance().definitions().materials().cell1024kPart());
        ItemReplacements.deprecateItem("storage.component", 2, AEApi.instance().definitions().materials().cell4096kPart());
        ItemReplacements.deprecateItem("storage.component", 3, AEApi.instance().definitions().materials().cell16384kPart());
        ItemReplacements.deprecateItem("storage.component", 4, ItemAndBlockHolder.CELL_PART, 0);
        ItemReplacements.deprecateItem("storage.component", 5, ItemAndBlockHolder.CELL_PART, 1);
        ItemReplacements.deprecateItem("storage.component", 6, ItemAndBlockHolder.CELL_PART, 2);
        ItemReplacements.deprecateItem("storage.component", 7, ItemAndBlockHolder.CELL_PART, 3);
        ItemReplacements.deprecateItem("storage.component", 8, ItemAndBlockHolder.CELL_PART, 4);
        ItemReplacements.deprecateItem("storage.component", 9, ItemAndBlockHolder.CELL_PART, 5);
        ItemReplacements.deprecateItem("storage.component", 10, ItemAndBlockHolder.CELL_PART, 6);
        ItemReplacements.deprecateWireless("terminal.universal.wireless", ItemAndBlockHolder.WIRELESS_ULTRA_TERM);
    }

    @Optional.Method(modid="OpenComputers")
    static void deprecateOC() {
        ItemInfo info = Items.get((String)"me_upgrade1");
        if (info != null) {
            ItemReplacements.deprecateItem("oc.upgrade", 0, info.item(), 0);
            ItemReplacements.deprecateItem("oc.upgrade", 1, info.item(), 1);
            ItemReplacements.deprecateItem("oc.upgrade", 2, info.item(), 2);
        } else {
            System.out.println("OpenComputers detected, but could not replace items: me_upgrade1");
        }
    }

    static void proxyPartItems() {
        ItemReplacements.deprecateItemPart(0, ItemAndBlockHolder.FLUID_EXPORT_BUS, ProxyFluidBusIO::new);
        ItemReplacements.deprecateItemPart(1, ItemAndBlockHolder.FLUID_IMPORT_BUS, ProxyFluidBusIO::new);
        ItemReplacements.deprecateItemPart(2, ItemAndBlockHolder.FLUID_STORAGE_BUS, ProxyFluidStorage::new);
        ItemReplacements.deprecateItemPart(3, ItemAndBlockHolder.FLUID_TERM, ProxyPart::new);
        ItemReplacements.deprecateItemPart(4, ItemAndBlockHolder.FLUID_LEVEL_EMITTER, ProxyLevelEmitter::new);
        ItemReplacements.deprecateItemPart(9, ItemAndBlockHolder.FLUID_INTERFACE, ProxyFluidInterface::new);
        ItemReplacements.deprecateItemPart(10, ItemAndBlockHolder.FLUID_STORAGE_MONITOR, ProxyStorageMonitor::new);
        ItemReplacements.deprecateItemPart(11, ItemAndBlockHolder.FLUID_CONVERSION_MONITOR, ProxyStorageMonitor::new);
        ItemReplacements.deprecateItemPart(12, AEApi.instance().definitions().parts().exportBus(), ProxyOreDictExportBus::new);
    }

    private static ProxyItem getOrBuildItem(String srcName) {
        String fullName = "extracells:" + srcName;
        ProxyItem proxy = (ProxyItem)registry.get(fullName);
        if (proxy == null) {
            proxy = new ProxyItem(srcName);
            registry.put(fullName, proxy);
            proxy.register();
        }
        return proxy;
    }

    private static ProxyFluidStorageCell getOrBuildFluidStorage(String srcName) {
        String fullName = "extracells:" + srcName;
        ProxyFluidStorageCell proxy = (ProxyFluidStorageCell)registry.get(fullName);
        if (proxy == null) {
            proxy = new ProxyFluidStorageCell(srcName);
            registry.put(fullName, proxy);
            proxy.register();
        }
        return proxy;
    }

    private static ProxyItemStorageCell getOrBuildItemStorage() {
        String fullName = "extracells:storage.physical";
        ProxyItemStorageCell proxy = (ProxyItemStorageCell)registry.get("extracells:storage.physical");
        if (proxy == null) {
            proxy = new ProxyItemStorageCell("storage.physical");
            registry.put("extracells:storage.physical", proxy);
            proxy.register();
        }
        return proxy;
    }

    private static ProxyExtremeStorageCell getOrBuildItemStorage(String srcName) {
        String fullName = "extracells:" + srcName;
        ProxyExtremeStorageCell proxy = (ProxyExtremeStorageCell)registry.get(fullName);
        if (proxy == null) {
            proxy = new ProxyExtremeStorageCell(srcName);
            registry.put(fullName, proxy);
            proxy.register();
        }
        return proxy;
    }

    private static void deprecateItem(String srcName, int srcMeta, Item replacement, int targetMeta) {
        ItemReplacements.getOrBuildItem(srcName).addMetaReplacement(srcMeta, replacement, targetMeta);
    }

    private static void deprecateItem(String srcName, Item replacement) {
        ItemReplacements.deprecateItem(srcName, 0, replacement, 0);
    }

    private static void deprecateItem(String srcName, int srcMeta, IItemDefinition replacement) {
        if (replacement.isEnabled()) {
            ItemReplacements.deprecateItem(srcName, srcMeta, (Item)replacement.maybeItem().get(), ((ItemStack)replacement.maybeStack(1).get()).func_77960_j());
        }
    }

    private static void deprecateWireless(String srcName, ItemBaseWirelessTerminal replacement) {
        ItemReplacements.getOrBuildItem(srcName).addMetaReplacement(0, new ProxyItem.ProxyItemEntry((Item)replacement, 0){

            @Override
            NBTTagCompound replaceNBT(NBTTagCompound compound) {
                double power = compound.func_74769_h("power");
                compound.func_82580_o("power");
                compound.func_74780_a("internalCurrentPower", power);
                String key = compound.func_74779_i("key");
                compound.func_82580_o("key");
                compound.func_74778_a("encryptionKey", key);
                return compound;
            }
        });
    }

    private static void deprecateItemPart(int srcMeta, Item replacement, Function<ProxyPartItem, ProxyPart> partBuilder) {
        String fullName = "extracells:part.base";
        ProxyPartItem proxyItem = (ProxyPartItem)registry.get("extracells:part.base");
        if (proxyItem == null) {
            proxyItem = new ProxyPartItem("part.base");
            registry.put("extracells:part.base", proxyItem);
            proxyItem.register();
        }
        proxyItem.addItemPart(srcMeta, replacement, partBuilder);
    }

    private static void deprecateItemPart(int srcMeta, IItemDefinition definition, Function<ProxyPartItem, ProxyPart> partBuilder) {
        if (definition.isEnabled()) {
            String fullName = "extracells:part.base";
            ProxyPartItem proxyItem = (ProxyPartItem)registry.get("extracells:part.base");
            if (proxyItem == null) {
                proxyItem = new ProxyPartItem("part.base");
                registry.put("extracells:part.base", proxyItem);
                proxyItem.register();
            }
            proxyItem.addItemPart(srcMeta, definition, partBuilder);
        }
    }

    private static void deprecateFluidStorage(String srcName, int srcMeta, ItemMultiFluidStorageCell replacement, long kilobytes, int bytesPerType, double idleDrain) {
        ProxyFluidStorageCell proxyItem = ItemReplacements.getOrBuildFluidStorage(srcName);
        ProxyItem.ProxyStorageEntry entry = new ProxyItem.ProxyStorageEntry((Item)replacement, 0, kilobytes, bytesPerType, idleDrain);
        proxyItem.addMetaReplacement(srcMeta, entry);
    }

    private static void deprecateItemStorage(int srcMeta, IItemDefinition replacement, long kilobytes, int bytesPerType, double idleDrain) {
        if (replacement.isEnabled()) {
            ProxyItemStorageCell item = ItemReplacements.getOrBuildItemStorage();
            int meta = ((ItemStack)replacement.maybeStack(1).get()).func_77960_j();
            ProxyItem.ProxyStorageEntry storage = new ProxyItem.ProxyStorageEntry((Item)replacement.maybeItem().get(), meta, kilobytes, bytesPerType, idleDrain);
            item.addMetaReplacement(srcMeta, storage);
        }
    }

    private static void deprecateItemStorage(int srcMeta, IItemDefinition replacement, long kilobytes, int bytesPerType, double idleDrain, int types) {
        if (replacement.isEnabled()) {
            ProxyItemStorageCell item = ItemReplacements.getOrBuildItemStorage();
            ProxyItem.ProxyStorageEntry storage = new ProxyItem.ProxyStorageEntry((Item)replacement.maybeItem().get(), kilobytes, bytesPerType, idleDrain, types);
            item.addMetaReplacement(srcMeta, storage);
        }
    }

    private static void deprecateExtremeStorage(String srcName, int srcMeta, IItemDefinition replacement, long bytes, int bytesPerType, double idleDrain) {
        if (replacement.isEnabled()) {
            ProxyExtremeStorageCell item = ItemReplacements.getOrBuildItemStorage(srcName);
            int meta = ((ItemStack)replacement.maybeStack(1).get()).func_77960_j();
            ProxyItem.ProxyStorageEntry storage = new ProxyItem.ProxyStorageEntry((Item)replacement.maybeItem().get(), meta, bytes / 1024L, bytesPerType, idleDrain);
            item.addMetaReplacement(srcMeta, storage);
        }
    }
}

