/*
 * Decompiled with CFR 0.152.
 */
package serverutils.lib.icon;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.File;
import java.net.URI;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ThreadDownloadImageData;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.ResourceLocation;
import serverutils.lib.client.GlStateManager;
import serverutils.lib.client.IPixelBuffer;
import serverutils.lib.client.PixelBuffer;
import serverutils.lib.icon.ImageIcon;
import serverutils.lib.io.DataReader;

public class URLImageIcon
extends ImageIcon {
    public final URI uri;
    private final String url;

    public URLImageIcon(ResourceLocation tex, URI _uri) {
        super(tex);
        this.uri = _uri;
        this.url = this.uri.toString();
    }

    public URLImageIcon(URI uri) {
        this(new ResourceLocation(uri.toString()), uri);
    }

    @Override
    public URLImageIcon copy() {
        URLImageIcon icon = new URLImageIcon(this.texture, this.uri);
        icon.minU = this.minU;
        icon.minV = this.minV;
        icon.maxU = this.maxU;
        icon.maxV = this.maxV;
        icon.tileSize = this.tileSize;
        return icon;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void bindTexture() {
        TextureManager manager = Minecraft.func_71410_x().func_110434_K();
        ITextureObject img = manager.func_110581_b(this.texture);
        if (img == null) {
            if (this.uri.getScheme().equals("http") || this.uri.getScheme().equals("https")) {
                img = new ThreadDownloadImageData(null, this.url, MISSING_IMAGE, null);
            } else {
                File file = null;
                if (this.uri.getScheme().equals("file")) {
                    try {
                        file = new File(this.uri.getPath());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                if (file == null) {
                    file = new File(this.uri);
                }
                img = new ThreadDownloadImageData(file, this.url, MISSING_IMAGE, null);
            }
            manager.func_110579_a(this.texture, img);
        }
        GlStateManager.bindTexture(img.func_110552_b());
    }

    @Override
    public String toString() {
        return this.url;
    }

    @Override
    public IPixelBuffer createPixelBuffer() {
        try {
            return PixelBuffer.from(DataReader.get(this.uri, Minecraft.func_71410_x().func_110437_J()).image());
        }
        catch (Exception ex) {
            return null;
        }
    }
}

