/*
 * Decompiled with CFR 0.152.
 */
package serverutils.invsee.inventories;

import de.eydamos.backpack.inventory.InventoryBackpack;
import de.eydamos.backpack.inventory.slot.SlotBackpack;
import de.eydamos.backpack.item.ItemsBackpack;
import de.eydamos.backpack.saves.BackpackSave;
import de.eydamos.backpack.saves.PlayerSave;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.Slot;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import serverutils.invsee.inventories.IModdedInventory;
import serverutils.lib.data.ForgePlayer;
import serverutils.lib.icon.Icon;
import serverutils.lib.icon.ItemIcon;

public class MinecraftBackpackInv
implements IModdedInventory {
    private static final Icon BACKPACK_ICON = ItemIcon.getItemIcon(ItemsBackpack.backpack);

    @Override
    @Nullable
    public IInventory loadOnlineInventory(EntityPlayerMP player) {
        return MinecraftBackpackInv.loadInventory(player.func_110124_au().toString());
    }

    @Override
    @Nullable
    public IInventory loadOfflineInventory(ForgePlayer player) {
        return MinecraftBackpackInv.loadInventory(player.getId().toString());
    }

    @Override
    @NotNull
    public IInventory createInventory(EntityPlayer player, int size) {
        return new InventoryBasic("", false, size);
    }

    @Override
    @NotNull
    public Icon getButtonIcon() {
        return BACKPACK_ICON;
    }

    @Override
    @NotNull
    public String getButtonText() {
        return "Personal Backpack";
    }

    @Override
    @Nullable
    public Slot getSlot(EntityPlayer player, IInventory inventory, int index, int x, int y) {
        return new SlotBackpack(inventory, index, x, y);
    }

    @Override
    public void saveInventory(ForgePlayer player, IInventory inventory) {
        if (!(inventory instanceof InventoryBackpack)) {
            return;
        }
        InventoryBackpack backpack = (InventoryBackpack)inventory;
        backpack.func_70296_d();
        PlayerSave playerSave = new PlayerSave(player.getId().toString());
        BackpackSave backpackSave = new BackpackSave(playerSave.getPersonalBackpack());
        backpack.writeToNBT(backpackSave);
        backpackSave.save();
    }

    public static InventoryBackpack loadInventory(String uuid) {
        PlayerSave playerSave = new PlayerSave(uuid);
        if (!playerSave.hasPersonalBackpack()) {
            return null;
        }
        InventoryBackpack backpack = new InventoryBackpack("", "");
        backpack.readFromNBT(new BackpackSave(playerSave.getPersonalBackpack()));
        return backpack;
    }
}

