/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.opis.swing.panels.tracking;

import java.awt.Component;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import mcp.mobius.opis.api.ITabPanel;
import mcp.mobius.opis.data.holders.ISerializable;
import mcp.mobius.opis.data.holders.newtypes.DataForcedChunks;
import mcp.mobius.opis.network.PacketBase;
import mcp.mobius.opis.network.enums.Message;
import mcp.mobius.opis.swing.SelectedTab;
import mcp.mobius.opis.swing.widgets.JPanelMsgHandler;
import mcp.mobius.opis.swing.widgets.JTableStats;
import mcp.mobius.shadow.net.miginfocom.swing.MigLayout;

public class PanelForceLoadsPerDim
extends JPanelMsgHandler
implements ITabPanel {
    private static final long serialVersionUID = 3487495895819393L;

    public PanelForceLoadsPerDim() {
        this.setLayout(new MigLayout("", "[grow]", "[grow]"));
        JScrollPane scrollPane = new JScrollPane();
        this.add((Component)scrollPane, "cell 0 0,grow");
        this.table = new JTableStats(new String[]{"Dim", "Name", "Mod Id", "Player or Entity", "Position", "Type", "Num Chunks", "Chunks", "Raw Data"}, new Class[]{Integer.class, String.class, String.class, String.class, String.class, String.class, Integer.class, String.class, String.class}, new boolean[]{false, false, false, false, false, false, false, false, false});
        this.table.setBackground(this.getBackground());
        this.table.setAutoCreateRowSorter(true);
        this.table.setShowGrid(false);
        scrollPane.setViewportView(this.table);
    }

    @Override
    public boolean handleMessage(Message msg, PacketBase rawdata) {
        switch (msg) {
            case LIST_FORCE_CHUNK_DATA: {
                this.cacheData(msg, rawdata);
                SwingUtilities.invokeLater(() -> {
                    this.getTable().setTableData(rawdata.array);
                    DefaultTableModel model = this.getTable().getModel();
                    int lastSelectedRow = this.getTable().clearTable(DataForcedChunks.class);
                    Vector<Vector> dataVector = model.getDataVector();
                    dataVector.clear();
                    for (ISerializable o : rawdata.array) {
                        DataForcedChunks data = (DataForcedChunks)o;
                        dataVector.add(new Vector<Serializable>(Arrays.asList(data.dim, data.dimName.toString(), data.modId.toString(), data.playerOrEntityName.toString(), data.position.toString(), data.type.toString(), data.numChunks, data.chunks.toString(), data.rawData.toString())));
                    }
                    this.getTable().dataUpdated(lastSelectedRow);
                });
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    @Override
    public SelectedTab getSelectedTab() {
        return SelectedTab.FORCELOADS;
    }

    @Override
    public boolean refreshOnString() {
        return true;
    }
}

