/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.opis.api;

import java.util.HashMap;
import java.util.HashSet;
import mcp.mobius.opis.api.IMessageHandler;
import mcp.mobius.opis.modOpis;
import mcp.mobius.opis.network.PacketBase;
import mcp.mobius.opis.network.enums.Message;

public enum MessageHandlerRegistrar {
    INSTANCE;

    private HashMap<Message, HashSet<IMessageHandler>> msgHandlers = new HashMap();
    public boolean suppressUnhandledMsgLogs = false;

    public void registerHandler(Message msg, IMessageHandler handler) {
        if (!this.msgHandlers.containsKey((Object)msg)) {
            this.msgHandlers.put(msg, new HashSet());
        }
        this.msgHandlers.get((Object)msg).add(handler);
    }

    public void routeMessage(Message msg, PacketBase rawdata) {
        if (this.msgHandlers.containsKey((Object)msg)) {
            for (IMessageHandler handler : this.msgHandlers.get((Object)msg)) {
                if (handler.handleMessage(msg, rawdata)) continue;
                modOpis.log.warn(String.format("Unhandled msg %s in handler %s", new Object[]{msg, handler}));
            }
        } else if (!this.suppressUnhandledMsgLogs) {
            modOpis.log.warn(String.format("Unhandled msg : %s", new Object[]{msg}));
        }
    }
}

