/*
 * Decompiled with CFR 0.152.
 */
package openmods.calc.parsing;

import com.google.common.base.Preconditions;
import openmods.calc.IExecutable;
import openmods.calc.parsing.IExecutableListBuilder;
import openmods.calc.parsing.IPostfixCompilerState;
import openmods.calc.parsing.SimplePostfixCompilerState;
import openmods.calc.parsing.Token;
import openmods.calc.parsing.TokenType;
import openmods.calc.parsing.TokenUtils;

public abstract class BracketPostfixCompilerStateBase<E>
extends SimplePostfixCompilerState<E> {
    private final String openingBracket;
    private boolean isFinished;

    public BracketPostfixCompilerStateBase(IExecutableListBuilder<E> builder, String openingBracket) {
        super(builder);
        this.openingBracket = openingBracket;
    }

    @Override
    public IPostfixCompilerState.Result acceptToken(Token token) {
        if (token.type == TokenType.RIGHT_BRACKET) {
            TokenUtils.checkIsValidBracketPair(this.openingBracket, token.value);
            this.isFinished = true;
            return IPostfixCompilerState.Result.ACCEPTED_AND_FINISHED;
        }
        return this.processBracketContent(token);
    }

    protected IPostfixCompilerState.Result processBracketContent(Token token) {
        return super.acceptToken(token);
    }

    @Override
    public IExecutable<E> exit() {
        Preconditions.checkState((boolean)this.isFinished, (Object)"Missing closing bracket");
        IExecutable compiledExpr = super.exit();
        return this.processCompiledBracket(compiledExpr);
    }

    protected abstract IExecutable<E> processCompiledBracket(IExecutable<E> var1);
}

