/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.world.structure.util.pregen;

import chylex.hee.system.logging.Log;
import chylex.hee.system.util.MathUtil;
import chylex.hee.world.structure.ComponentScatteredFeatureCustom;
import chylex.hee.world.structure.util.pregen.ITileEntityGenerator;
import gnu.trove.set.hash.TIntHashSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;

public class LargeStructureChunk {
    public final int x;
    public final int z;
    private final int ySize;
    private int minBlockY;
    private int maxBlockY;
    private final Block[] storedBlocks;
    private final byte[] storedMetadata;
    private final TIntHashSet scheduledForUpdate = new TIntHashSet();
    private final Map<Integer, String> storedTileEntityClues = new HashMap<Integer, String>();
    private final Map<String, ITileEntityGenerator> storedTileEntities = new HashMap<String, ITileEntityGenerator>();
    private final Map<ChunkCoordIntPair, Entity> storedEntities = new HashMap<ChunkCoordIntPair, Entity>();
    private TIntHashSet alreadyGeneratedXZ = new TIntHashSet(256);

    public LargeStructureChunk(int x, int z, int ySize) {
        this.x = x;
        this.z = z;
        this.ySize = ySize;
        this.minBlockY = ySize;
        this.maxBlockY = 0;
        this.storedBlocks = new Block[256 * ySize];
        this.storedMetadata = new byte[256 * ySize];
    }

    public void setBlock(int xInChunk, int yInChunk, int zInChunk, Block block, int metadata, boolean scheduleUpdate) {
        if (xInChunk < 0 || xInChunk >= 16 || yInChunk < 0 || yInChunk >= this.ySize || zInChunk < 0 || zInChunk >= 16) {
            if (Log.isDebugEnabled()) {
                Thread.dumpStack();
            }
            Log.debug("Placing block at invalid coordinates: $0,$1,$2", xInChunk, yInChunk, zInChunk);
            return;
        }
        if (yInChunk < this.minBlockY) {
            this.minBlockY = yInChunk;
        }
        if (yInChunk > this.maxBlockY) {
            this.maxBlockY = yInChunk;
        }
        int index = yInChunk * 256 + xInChunk * 16 + zInChunk;
        this.storedBlocks[index] = block;
        this.storedMetadata[index] = (byte)metadata;
        if (scheduleUpdate) {
            this.scheduledForUpdate.add(index);
        }
    }

    public Block getBlock(int xInChunk, int yInChunk, int zInChunk) {
        if (xInChunk < 0 || xInChunk >= 16 || yInChunk < 0 || yInChunk >= this.ySize || zInChunk < 0 || zInChunk >= 16) {
            if (Log.isDebugEnabled()) {
                Thread.dumpStack();
            }
            Log.debug("Getting block at invalid coordinates: $0,$1,$2", xInChunk, yInChunk, zInChunk);
            return Blocks.field_150350_a;
        }
        Block block = this.storedBlocks[yInChunk * 256 + xInChunk * 16 + zInChunk];
        return block == null ? Blocks.field_150350_a : block;
    }

    public int getMetadata(int xInChunk, int yInChunk, int zInChunk) {
        if (xInChunk < 0 || xInChunk >= 16 || yInChunk < 0 || yInChunk >= this.ySize || zInChunk < 0 || zInChunk >= 16) {
            if (Log.isDebugEnabled()) {
                Thread.dumpStack();
            }
            Log.debug("Getting block metadata at invalid coordinates: $0,$1,$2", xInChunk, yInChunk, zInChunk);
            return 0;
        }
        return this.storedMetadata[yInChunk * 256 + xInChunk * 16 + zInChunk];
    }

    public void addTileEntityGenerator(int xInChunk, int yInChunk, int zInChunk, String key, ITileEntityGenerator tileGen) {
        this.storedTileEntityClues.put(yInChunk * 256 + xInChunk * 16 + zInChunk, key);
        this.storedTileEntities.put(key, tileGen);
    }

    public void addEntity(Entity entity, int xInChunk, int zInChunk) {
        this.storedEntities.put(new ChunkCoordIntPair(xInChunk, zInChunk), entity);
    }

    public Collection<Entity> getAllEntities() {
        return this.storedEntities.values();
    }

    public boolean isBlockScheduledForUpdate(int xInChunk, int yInChunk, int zInChunk) {
        return this.scheduledForUpdate.contains(yInChunk * 256 + xInChunk * 16 + zInChunk);
    }

    public int getHighestBlockY() {
        return this.maxBlockY;
    }

    public void generateInStructure(ComponentScatteredFeatureCustom structure, World world, StructureBoundingBox bb, int addX, int addY, int addZ) {
        if (this.minBlockY == this.ySize && this.maxBlockY == 0) {
            return;
        }
        boolean hasBlocksToUpdate = !this.scheduledForUpdate.isEmpty();
        boolean hasTileEntities = !this.storedTileEntities.isEmpty();
        boolean continueY = true;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                if (!this.alreadyGeneratedXZ.contains(x * 16 + z)) {
                    for (int y = this.minBlockY; y <= this.maxBlockY && continueY; ++y) {
                        Block block;
                        if (continueY && y == this.maxBlockY) {
                            this.alreadyGeneratedXZ.add(x * 16 + z);
                            Iterator<Map.Entry<ChunkCoordIntPair, Entity>> iter = this.storedEntities.entrySet().iterator();
                            while (iter.hasNext()) {
                                Map.Entry<ChunkCoordIntPair, Entity> entry = iter.next();
                                if (entry.getKey().field_77276_a != x || entry.getKey().field_77275_b != z) continue;
                                Entity entity = entry.getValue();
                                int ix = MathUtil.floor(entity.field_70165_t);
                                int iy = MathUtil.floor(entity.field_70163_u);
                                int iz = MathUtil.floor(entity.field_70161_v);
                                double fx = entity.field_70165_t - (double)ix;
                                double fy = entity.field_70163_u - (double)iy;
                                double fz = entity.field_70161_v - (double)iz;
                                ix += addX;
                                iy += addY;
                                iz += addZ;
                                if (entity.field_70170_p == null) {
                                    entity.field_71093_bK = world.field_73011_w.field_76574_g;
                                    entity.func_70029_a(world);
                                }
                                entity.func_70107_b((double)structure.func_74865_a(ix, iz) + fx, (double)structure.func_74862_a(iy) + fy + 0.01, (double)structure.func_74873_b(ix, iz) + fz);
                                world.func_72838_d(entity);
                                iter.remove();
                            }
                        }
                        if ((block = this.getBlock(x, y, z)) == Blocks.field_150350_a || !(continueY = hasBlocksToUpdate && this.isBlockScheduledForUpdate(x, y, z) ? structure.placeBlockAndUpdateUnsafe(block, this.getMetadata(x, y, z), addX + this.x * 16 + x, addY + y, addZ + this.z * 16 + z, world, bb) : structure.placeBlockUnsafe(block, this.getMetadata(x, y, z), addX + this.x * 16 + x, addY + y, addZ + this.z * 16 + z, world, bb)) || !hasTileEntities || !this.storedTileEntityClues.containsKey(y * 256 + x * 16 + z)) continue;
                        String key = this.storedTileEntityClues.get(y * 256 + x * 16 + z);
                        TileEntity tileEntity = structure.getBlockTileEntityUnsafe(addX + this.x * 16 + x, addY + y, addZ + this.z * 16 + z, world, bb);
                        if (tileEntity == null) {
                            Log.debug("Tile entity with key $0 not found at $1,$2,$3!", key, x, y, z);
                            continue;
                        }
                        this.storedTileEntities.get(key).onTileEntityRequested(key, tileEntity, world.field_73012_v);
                    }
                }
                continueY = true;
            }
        }
    }

    public NBTTagCompound saveToNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74783_a("genXZ", this.alreadyGeneratedXZ.toArray());
        return nbt;
    }

    public void loadFromNBT(NBTTagCompound nbt) {
        this.alreadyGeneratedXZ.clear();
        this.alreadyGeneratedXZ.addAll(nbt.func_74759_k("genXZ"));
    }

    public static class Empty
    extends LargeStructureChunk {
        public Empty(int x, int z, int ySize) {
            super(x, z, ySize);
        }

        @Override
        public void setBlock(int xInChunk, int yInChunk, int zInChunk, Block block, int metadata, boolean scheduleUpdate) {
        }

        @Override
        public void addTileEntityGenerator(int xInChunk, int yInChunk, int zInChunk, String key, ITileEntityGenerator tileGen) {
        }
    }
}

