/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.gui;

import com.enderio.core.api.client.gui.IGuiScreen;
import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.client.gui.button.ColorButton;
import com.enderio.core.client.gui.button.IconButton;
import com.enderio.core.client.gui.button.ToggleButton;
import com.enderio.core.client.gui.widget.GuiToolTip;
import com.enderio.core.client.render.ColorUtil;
import com.enderio.core.client.render.RenderUtil;
import com.enderio.core.common.util.DyeColor;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import crazypants.enderio.EnderIO;
import crazypants.enderio.conduit.ConnectionMode;
import crazypants.enderio.conduit.IConduit;
import crazypants.enderio.conduit.gui.BaseSettingsPanel;
import crazypants.enderio.conduit.gui.GuiExternalConnection;
import crazypants.enderio.conduit.gui.PacketFluidChannel;
import crazypants.enderio.conduit.gui.PacketFluidFilter;
import crazypants.enderio.conduit.liquid.AbstractEnderLiquidConduit;
import crazypants.enderio.conduit.liquid.FluidFilter;
import crazypants.enderio.conduit.liquid.ILiquidConduit;
import crazypants.enderio.conduit.packet.PacketExtractMode;
import crazypants.enderio.conduit.packet.PacketRoundRobinMode;
import crazypants.enderio.gui.IconEIO;
import crazypants.enderio.gui.RedstoneModeButton;
import crazypants.enderio.machine.IRedstoneModeControlable;
import crazypants.enderio.machine.RedstoneControlMode;
import crazypants.enderio.network.PacketHandler;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class LiquidSettings
extends BaseSettingsPanel {
    static final int ID_REDSTONE_BUTTON = GuiExternalConnection.nextButtonId();
    private static final int ID_COLOR_BUTTON = GuiExternalConnection.nextButtonId();
    private static final int ID_ROUND_ROBIN_BUTTON = GuiExternalConnection.nextButtonId();
    private static final int ID_INSERT_WHITELIST = GuiExternalConnection.nextButtonId();
    private static final int ID_EXTRACT_WHITELIST = GuiExternalConnection.nextButtonId();
    private static final int NEXT_FILTER_ID = 989322;
    private static final int ID_INSERT_CHANNEL = GuiExternalConnection.nextButtonId();
    private static final int ID_EXTRACT_CHANNEL = GuiExternalConnection.nextButtonId();
    private final RedstoneModeButton rsB;
    private final ToggleButton roundRobinB;
    private final ColorButton colorB;
    private ColorButton insertChannelB;
    private ColorButton extractChannelB;
    private static final String autoExtractStr = EnderIO.lang.localize("gui.conduit.fluid.autoExtract");
    private static final String filterStr = EnderIO.lang.localize("gui.conduit.fluid.filter");
    private final ILiquidConduit conduit;
    private AbstractEnderLiquidConduit eConduit;
    private boolean isEnder;
    private static final int filterIX = 4;
    private static final int filterEX = 104;
    private static final int filterY = 63;
    private static final Rectangle insertFilterBounds = new Rectangle(4, 63, 90, 18);
    private static final Rectangle extractFilterBounds = new Rectangle(104, 63, 90, 18);
    private GuiToolTip[] filterToolTips;
    private boolean inOutShowIn = true;
    private IconButton insertWhiteListB;
    private IconButton extractWhiteListB;

    protected LiquidSettings(final GuiExternalConnection gui, IConduit con) {
        super(IconEIO.WRENCH_OVERLAY_FLUID, EnderIO.lang.localize("itemLiquidConduit.name"), gui, con, "in_out_settings");
        int y;
        int x;
        this.textureHeight += 48;
        this.conduit = (ILiquidConduit)con;
        if (con instanceof AbstractEnderLiquidConduit) {
            this.eConduit = (AbstractEnderLiquidConduit)con;
            this.isEnder = true;
            x = this.leftColumn;
            y = this.customTop;
            this.insertWhiteListB = new IconButton((IGuiScreen)gui, ID_INSERT_WHITELIST, x, y, (IWidgetIcon)IconEIO.FILTER_WHITELIST);
            this.insertWhiteListB.setToolTip(new String[]{EnderIO.lang.localize("gui.conduit.fluid.whitelist")});
            x = this.rightColumn;
            this.extractWhiteListB = new IconButton((IGuiScreen)gui, ID_EXTRACT_WHITELIST, x, y, (IWidgetIcon)IconEIO.FILTER_WHITELIST);
            this.extractWhiteListB.setToolTip(new String[]{EnderIO.lang.localize("gui.conduit.fluid.whitelist")});
        } else {
            this.isEnder = false;
            gui.getContainer().setInventorySlotsVisible(false);
        }
        x = this.leftColumn + 21;
        y = this.customTop;
        if (this.isEnder) {
            this.insertChannelB = new ColorButton((IGuiScreen)gui, ID_INSERT_CHANNEL, x, y);
            this.insertChannelB.setColorIndex(0);
            this.insertChannelB.setToolTipHeading(EnderIO.lang.localize("gui.conduit.item.channel"));
            this.extractChannelB = new ColorButton((IGuiScreen)gui, ID_EXTRACT_CHANNEL, x + this.rightColumn - this.leftColumn, y);
            this.extractChannelB.setColorIndex(0);
            this.extractChannelB.setToolTipHeading(EnderIO.lang.localize("gui.conduit.item.channel"));
            x += this.insertChannelB.getWidth();
        }
        this.rsB = new RedstoneModeButton((IGuiScreen)gui, ID_REDSTONE_BUTTON, x += this.rightColumn - this.leftColumn, y, new IRedstoneModeControlable(){

            @Override
            public void setRedstoneControlMode(RedstoneControlMode mode) {
                RedstoneControlMode curMode = this.getRedstoneControlMode();
                LiquidSettings.this.conduit.setExtractionRedstoneMode(mode, gui.getDir());
                if (curMode != mode) {
                    PacketHandler.INSTANCE.sendToServer((IMessage)new PacketExtractMode(LiquidSettings.this.conduit, gui.getDir()));
                }
            }

            @Override
            public RedstoneControlMode getRedstoneControlMode() {
                return LiquidSettings.this.conduit.getExtractionRedstoneMode(gui.getDir());
            }
        });
        this.colorB = new ColorButton((IGuiScreen)gui, ID_COLOR_BUTTON, x += this.rsB.getWidth(), y);
        this.colorB.setToolTipHeading(EnderIO.lang.localize("gui.conduit.redstone.signalColor"));
        this.colorB.setColorIndex(this.conduit.getExtractionSignalColor(gui.getDir()).ordinal());
        if (this.isEnder) {
            this.roundRobinB = new ToggleButton((IGuiScreen)gui, ID_ROUND_ROBIN_BUTTON, x += this.rsB.getWidth(), y, (IWidgetIcon)IconEIO.ROUND_ROBIN_OFF, (IWidgetIcon)IconEIO.ROUND_ROBIN);
            this.roundRobinB.setSelectedToolTip(new String[]{EnderIO.lang.localize("gui.conduit.item.roundRobinEnabled")});
            this.roundRobinB.setUnselectedToolTip(new String[]{EnderIO.lang.localize("gui.conduit.item.roundRobinDisabled")});
            this.roundRobinB.setPaintSelectedBorder(false);
        } else {
            this.roundRobinB = null;
        }
    }

    private void addFilterTooltips() {
        Rectangle bound;
        int i;
        this.filterToolTips = new GuiToolTip[5];
        for (i = 0; i < 5; ++i) {
            bound = new Rectangle(4 + i * 18, 63, 18, 18);
            this.filterToolTips[i] = new FilterToolTip(bound, i, false);
            this.gui.addToolTip(this.filterToolTips[i]);
        }
        for (i = 0; i < 5; ++i) {
            bound = new Rectangle(104 + i * 18, 63, 18, 18);
            this.filterToolTips[i] = new FilterToolTip(bound, i, true);
            this.gui.addToolTip(this.filterToolTips[i]);
        }
    }

    @Override
    public void actionPerformed(GuiButton guiButton) {
        super.actionPerformed(guiButton);
        if (guiButton.field_146127_k == ID_COLOR_BUTTON) {
            this.conduit.setExtractionSignalColor(this.gui.getDir(), DyeColor.values()[this.colorB.getColorIndex()]);
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketExtractMode(this.conduit, this.gui.getDir()));
        } else if (guiButton.field_146127_k == ID_INSERT_WHITELIST || guiButton.field_146127_k == ID_EXTRACT_WHITELIST) {
            this.toggleBlacklist(guiButton.field_146127_k == ID_EXTRACT_WHITELIST);
        } else if (guiButton.field_146127_k == ID_INSERT_CHANNEL || guiButton.field_146127_k == ID_EXTRACT_CHANNEL) {
            ColorButton btn = (ColorButton)guiButton;
            if (this.isEnder) {
                boolean isInput;
                DyeColor col = DyeColor.values()[btn.getColorIndex()];
                boolean bl = isInput = guiButton.field_146127_k == ID_EXTRACT_CHANNEL;
                if (isInput) {
                    this.eConduit.setInputColor(this.gui.getDir(), col);
                } else {
                    this.eConduit.setOutputColor(this.gui.getDir(), col);
                }
                this.setConduitChannel(isInput, col);
            }
        } else if (guiButton.field_146127_k == ID_ROUND_ROBIN_BUTTON && this.isEnder) {
            boolean selected = this.roundRobinB.isSelected();
            this.eConduit.setRoundRobin(this.gui.getDir(), selected);
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketRoundRobinMode(this.eConduit, this.gui.getDir()));
        }
    }

    @Override
    protected void connectionModeChanged(ConnectionMode conectionMode) {
        super.connectionModeChanged(conectionMode);
        this.updateGuiVisibility();
    }

    private void toggleBlacklist(boolean isInput) {
        if (!this.isFilterVisible()) {
            return;
        }
        FluidFilter filter = this.eConduit.getFilter(this.gui.getDir(), isInput);
        if (filter == null) {
            filter = new FluidFilter();
        }
        filter.setBlacklist(!filter.isBlacklist());
        this.setConduitFilter(isInput, filter);
        this.updateWhiteListButton(filter, isInput);
    }

    @Override
    public void mouseClicked(int x, int y, int button) {
        if (!this.isFilterVisible()) {
            return;
        }
        ItemStack st = Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70445_o();
        this.setFilterFromItem(x, y, st);
    }

    public boolean setFilterFromItem(int x, int y, ItemStack st) {
        if (insertFilterBounds.contains(x, y)) {
            FluidFilter filter = this.eConduit.getFilter(this.gui.getDir(), false);
            if (filter == null && st == null) {
                return false;
            }
            if (filter == null) {
                filter = new FluidFilter();
            }
            int slot = (x - 4) / 18;
            filter.setFluid(slot, st);
            this.setConduitFilter(false, filter);
            return true;
        }
        if (extractFilterBounds.contains(x, y)) {
            FluidFilter filter = this.eConduit.getFilter(this.gui.getDir(), true);
            if (filter == null && st == null) {
                return false;
            }
            if (filter == null) {
                filter = new FluidFilter();
            }
            int slot = (x - 104) / 18;
            filter.setFluid(slot, st);
            this.setConduitFilter(true, filter);
            return true;
        }
        return false;
    }

    protected void setConduitFilter(boolean isInput, FluidFilter filter) {
        this.eConduit.setFilter(this.gui.getDir(), filter, isInput);
        PacketHandler.INSTANCE.sendToServer((IMessage)new PacketFluidFilter(this.eConduit, this.gui.getDir(), filter, isInput));
    }

    protected void setConduitChannel(boolean isInput, DyeColor channel) {
        if (isInput) {
            this.eConduit.setInputColor(this.gui.getDir(), channel);
        } else {
            this.eConduit.setOutputColor(this.gui.getDir(), channel);
        }
        PacketHandler.INSTANCE.sendToServer((IMessage)new PacketFluidChannel(this.eConduit, this.gui.getDir(), isInput, channel));
    }

    @Override
    protected void initCustomOptions() {
        this.updateGuiVisibility();
    }

    private void updateGuiVisibility() {
        this.deactivate();
        this.rsB.onGuiInit();
        this.colorB.onGuiInit();
        if (!this.isEnder) {
            return;
        }
        this.insertChannelB.onGuiInit();
        this.insertChannelB.setColorIndex(this.eConduit.getOutputColor(this.gui.getDir()).ordinal());
        this.extractChannelB.onGuiInit();
        this.extractChannelB.setColorIndex(this.eConduit.getInputColor(this.gui.getDir()).ordinal());
        this.roundRobinB.onGuiInit();
        this.roundRobinB.setSelected(this.eConduit.isRoundRobin(this.gui.getDir()));
        this.gui.getContainer().setInventorySlotsVisible(true);
        if (this.isFilterVisible()) {
            this.addFilterTooltips();
            this.insertWhiteListB.onGuiInit();
            this.extractWhiteListB.onGuiInit();
            this.updateWhiteListButtons();
        }
    }

    private void updateWhiteListButtons() {
        this.updateWhiteListButton(this.eConduit.getFilter(this.gui.getDir(), false), false);
        this.updateWhiteListButton(this.eConduit.getFilter(this.gui.getDir(), true), true);
    }

    private void updateWhiteListButton(FluidFilter filter, boolean isInput) {
        IconButton whiteListB;
        IconButton iconButton = whiteListB = isInput ? this.extractWhiteListB : this.insertWhiteListB;
        if (filter != null && filter.isBlacklist()) {
            whiteListB.setIcon((IWidgetIcon)IconEIO.FILTER_BLACKLIST);
            whiteListB.setToolTip(new String[]{EnderIO.lang.localize("gui.conduit.fluid.blacklist")});
        } else {
            whiteListB.setIcon((IWidgetIcon)IconEIO.FILTER_WHITELIST);
            whiteListB.setToolTip(new String[]{EnderIO.lang.localize("gui.conduit.fluid.whitelist")});
        }
    }

    @Override
    public void deactivate() {
        this.rsB.detach();
        this.colorB.detach();
        this.gui.getContainer().setInventorySlotsVisible(false);
        if (this.isEnder) {
            this.roundRobinB.detach();
            if (this.filterToolTips != null) {
                for (GuiToolTip tt : this.filterToolTips) {
                    if (tt == null) continue;
                    this.gui.removeToolTip(tt);
                }
            }
            this.insertWhiteListB.detach();
            this.extractWhiteListB.detach();
            this.insertChannelB.detach();
            this.extractChannelB.detach();
        }
    }

    @Override
    protected void renderCustomOptions(int top, float par1, int par2, int par3) {
        if (this.isEnder && this.isFilterVisible()) {
            FluidStack f;
            int i;
            int x = this.left;
            int y = top;
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            this.gui.bindGuiTexture(1);
            FontRenderer fr = this.gui.getFontRenderer();
            int sw = fr.func_78256_a(filterStr);
            x = this.left + 50 - sw / 2;
            y = top + 20;
            fr.func_78276_b(filterStr, x, y, ColorUtil.getRGB((Color)Color.DARK_GRAY));
            x = this.left + 150 - sw / 2;
            fr.func_78276_b(filterStr, x, y, ColorUtil.getRGB((Color)Color.DARK_GRAY));
            x = this.gui.getGuiLeft() + 4;
            y = this.gui.getGuiTop() + 63;
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            this.gui.bindGuiTexture();
            this.gui.func_73729_b(x, y, 24, 238, 90, 18);
            FluidFilter filter = this.eConduit.getFilter(this.gui.getDir(), false);
            if (filter != null && !filter.isEmpty()) {
                for (i = 0; i < filter.size(); ++i) {
                    f = filter.getFluidStackAt(i);
                    if (f == null) continue;
                    this.renderFluid(f, x + i * 18, y);
                }
            }
            x = this.gui.getGuiLeft() + 104;
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            this.gui.bindGuiTexture();
            this.gui.func_73729_b(x, y, 24, 238, 90, 18);
            filter = this.eConduit.getFilter(this.gui.getDir(), true);
            if (filter != null && !filter.isEmpty()) {
                for (i = 0; i < filter.size(); ++i) {
                    f = filter.getFluidStackAt(i);
                    if (f == null) continue;
                    this.renderFluid(f, x + i * 18, y);
                }
            }
        }
    }

    private void renderFluid(FluidStack f, int x, int y) {
        IIcon icon = f.getFluid().getIcon();
        if (icon != null) {
            RenderUtil.bindBlockTexture();
            int color = f.getFluid().getColor(f);
            GL11.glColor3ub((byte)((byte)(color >> 16 & 0xFF)), (byte)((byte)(color >> 8 & 0xFF)), (byte)((byte)(color & 0xFF)));
            this.gui.func_94065_a(x + 1, y + 1, icon, 16, 16);
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    private boolean isFilterVisible() {
        return this.isEnder;
    }

    private class FilterToolTip
    extends GuiToolTip {
        int index;
        boolean isInput;

        public FilterToolTip(Rectangle bounds, int index, boolean isInput) {
            super(bounds, (String[])null);
            this.index = index;
            this.isInput = isInput;
        }

        public List<String> getToolTipText() {
            if (!LiquidSettings.this.isFilterVisible()) {
                return null;
            }
            FluidFilter filter = LiquidSettings.this.eConduit.getFilter(LiquidSettings.this.gui.getDir(), this.isInput);
            if (filter == null) {
                return null;
            }
            if (filter.getFluidStackAt(this.index) == null) {
                return null;
            }
            return Collections.singletonList(filter.getFluidStackAt(this.index).getLocalizedName());
        }
    }
}

