/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import java.awt.Color;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.wand.ICoordBoundItem;
import vazkii.botania.api.wand.ITileBound;
import vazkii.botania.api.wand.IWandBindable;
import vazkii.botania.api.wand.IWandable;
import vazkii.botania.client.core.helper.IconHelper;
import vazkii.botania.common.Botania;
import vazkii.botania.common.achievement.ModAchievements;
import vazkii.botania.common.block.BlockPistonRelay;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.tile.TileEnchanter;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.core.helper.Vector3;
import vazkii.botania.common.item.Item16Colors;
import vazkii.botania.common.item.ModItems;

public class ItemTwigWand
extends Item16Colors
implements ICoordBoundItem {
    IIcon[] icons;
    private static final String TAG_COLOR1 = "color1";
    private static final String TAG_COLOR2 = "color2";
    private static final String TAG_BOUND_TILE_X = "boundTileX";
    private static final String TAG_BOUND_TILE_Y = "boundTileY";
    private static final String TAG_BOUND_TILE_Z = "boundTileZ";
    private static final String TAG_BIND_MODE = "bindMode";

    public ItemTwigWand() {
        super("twigWand");
        this.func_77625_d(1);
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float subX, float subY, float subZ) {
        TileEntity tile;
        Block block = world.func_147439_a(x, y, z);
        ChunkCoordinates boundTile = ItemTwigWand.getBoundTile(stack);
        if (boundTile.field_71572_b != -1 && player.func_70093_af() && (boundTile.field_71574_a != x || boundTile.field_71572_b != y || boundTile.field_71573_c != z)) {
            tile = world.func_147438_o(boundTile.field_71574_a, boundTile.field_71572_b, boundTile.field_71573_c);
            if (tile instanceof IWandBindable) {
                if (((IWandBindable)tile).bindTo(player, stack, x, y, z, side)) {
                    Vector3 orig = new Vector3((double)boundTile.field_71574_a + 0.5, (double)boundTile.field_71572_b + 0.5, (double)boundTile.field_71573_c + 0.5);
                    Vector3 end = new Vector3((double)x + 0.5, (double)y + 0.5, (double)z + 0.5);
                    ItemTwigWand.doParticleBeam(world, orig, end);
                    VanillaPacketDispatcher.dispatchTEToNearbyPlayers(world, boundTile.field_71574_a, boundTile.field_71572_b, boundTile.field_71573_c);
                    ItemTwigWand.setBoundTile(stack, 0, -1, 0);
                }
                return true;
            }
            ItemTwigWand.setBoundTile(stack, 0, -1, 0);
        } else if (player.func_70093_af()) {
            block.rotateBlock(world, x, y, z, ForgeDirection.getOrientation((int)side));
            if (world.field_72995_K) {
                player.func_71038_i();
            }
        }
        if (block == Blocks.field_150368_y && ConfigHandler.enchanterEnabled) {
            int meta = -1;
            if (TileEnchanter.canEnchanterExist(world, x, y, z, 0)) {
                meta = 0;
            } else if (TileEnchanter.canEnchanterExist(world, x, y, z, 1)) {
                meta = 1;
            }
            if (meta != -1 && !world.field_72995_K) {
                world.func_147465_d(x, y, z, ModBlocks.enchanter, meta, 3);
                player.func_71064_a((StatBase)ModAchievements.enchanterMake, 1);
                world.func_72908_a((double)x, (double)y, (double)z, "botania:enchanterBlock", 0.5f, 0.6f);
                for (int i = 0; i < 50; ++i) {
                    float red = (float)Math.random();
                    float green = (float)Math.random();
                    float blue = (float)Math.random();
                    double dx = (Math.random() - 0.5) * 6.0;
                    double dy = (Math.random() - 0.5) * 6.0;
                    double dz = (Math.random() - 0.5) * 6.0;
                    float velMul = 0.07f;
                    Botania.proxy.wispFX(world, (double)x + 0.5 + dx, (double)y + 0.5 + dy, (double)z + 0.5 + dz, red, green, blue, (float)Math.random() * 0.15f + 0.15f, (float)(-dx) * velMul, (float)(-dy) * velMul, (float)(-dz) * velMul);
                }
            }
        } else {
            if (block instanceof IWandable) {
                tile = world.func_147438_o(x, y, z);
                boolean bindable = tile instanceof IWandBindable;
                boolean wanded = false;
                if (ItemTwigWand.getBindMode(stack) && bindable && player.func_70093_af() && ((IWandBindable)tile).canSelect(player, stack, x, y, z, side)) {
                    if (boundTile.field_71574_a == x && boundTile.field_71572_b == y && boundTile.field_71573_c == z) {
                        ItemTwigWand.setBoundTile(stack, 0, -1, 0);
                    } else {
                        ItemTwigWand.setBoundTile(stack, x, y, z);
                    }
                    if (world.field_72995_K) {
                        player.func_71038_i();
                    }
                    world.func_72956_a((Entity)player, "botania:ding", 0.1f, 1.0f);
                    wanded = true;
                } else {
                    wanded = ((IWandable)block).onUsedByWand(player, stack, world, x, y, z, side);
                    if (wanded && world.field_72995_K) {
                        player.func_71038_i();
                    }
                }
                return wanded;
            }
            if (BlockPistonRelay.playerPositions.containsKey(player.func_70005_c_()) && !world.field_72995_K) {
                String bindPos = BlockPistonRelay.playerPositions.get(player.func_70005_c_());
                String currentPos = BlockPistonRelay.getCoordsAsString(world.field_73011_w.field_76574_g, x, y, z);
                BlockPistonRelay.playerPositions.remove(player.func_70005_c_());
                BlockPistonRelay.mappedPositions.put(bindPos, currentPos);
                BlockPistonRelay.WorldData.get(world).func_76185_a();
                world.func_72956_a((Entity)player, "botania:ding", 1.0f, 1.0f);
            }
        }
        return false;
    }

    public static void doParticleBeam(World world, Vector3 orig, Vector3 end) {
        if (!world.field_72995_K) {
            return;
        }
        Vector3 diff = end.copy().sub(orig);
        Vector3 movement = diff.copy().normalize().multiply(0.05);
        int iters = (int)(diff.mag() / movement.mag());
        float huePer = 1.0f / (float)iters;
        float hueSum = (float)Math.random();
        Vector3 currentPos = orig.copy();
        for (int i = 0; i < iters; ++i) {
            float hue = (float)i * huePer + hueSum;
            Color color = Color.getHSBColor(hue, 1.0f, 1.0f);
            float r = (float)color.getRed() / 255.0f;
            float g = (float)color.getGreen() / 255.0f;
            float b = (float)color.getBlue() / 255.0f;
            Botania.proxy.setSparkleFXNoClip(true);
            Botania.proxy.sparkleFX(world, currentPos.x, currentPos.y, currentPos.z, r, g, b, 0.5f, 4);
            Botania.proxy.setSparkleFXNoClip(false);
            currentPos.add(movement);
        }
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int invSlot, boolean isHeld) {
        ChunkCoordinates coords = ItemTwigWand.getBoundTile(stack);
        TileEntity tile = world.func_147438_o(coords.field_71574_a, coords.field_71572_b, coords.field_71573_c);
        if (!(tile instanceof IWandBindable)) {
            ItemTwigWand.setBoundTile(stack, 0, -1, 0);
        }
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (!world.field_72995_K && player.func_70093_af()) {
            ItemTwigWand.setBindMode(stack, !ItemTwigWand.getBindMode(stack));
            world.func_72956_a((Entity)player, "botania:ding", 0.1f, 1.0f);
        }
        return stack;
    }

    public boolean func_77662_d() {
        return true;
    }

    @Override
    public void func_94581_a(IIconRegister register) {
        this.icons = new IIcon[4];
        for (int i = 0; i < this.icons.length; ++i) {
            this.icons[i] = IconHelper.forItem(register, (Item)this, i);
        }
    }

    public IIcon getIcon(ItemStack stack, int pass) {
        if (pass == 3 && !ItemTwigWand.getBindMode(stack)) {
            pass = 0;
        }
        return this.icons[Math.min(this.icons.length - 1, pass)];
    }

    @Override
    public int func_82790_a(ItemStack stack, int renderPass) {
        if (renderPass == 0 || renderPass == 3) {
            return 0xFFFFFF;
        }
        float[] color = EntitySheep.field_70898_d[renderPass == 1 ? ItemTwigWand.getColor1(stack) : ItemTwigWand.getColor2(stack)];
        return new Color(color[0], color[1], color[2]).getRGB();
    }

    public boolean func_77623_v() {
        return true;
    }

    public int getRenderPasses(int metadata) {
        return 4;
    }

    @Override
    public void func_150895_a(Item item, CreativeTabs tab, List<ItemStack> list) {
        for (int i = 0; i < 16; ++i) {
            list.add(ItemTwigWand.forColors(i, i));
        }
    }

    @Override
    public String func_77667_c(ItemStack stack) {
        return this.getUnlocalizedNameLazy(stack);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> infoList, boolean advanced) {
        infoList.add(StatCollector.func_74838_a((String)ItemTwigWand.getModeString(stack)));
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.rare;
    }

    public static ItemStack forColors(int color1, int color2) {
        ItemStack stack = new ItemStack(ModItems.twigWand);
        ItemNBTHelper.setInt(stack, TAG_COLOR1, color1);
        ItemNBTHelper.setInt(stack, TAG_COLOR2, color2);
        return stack;
    }

    public static int getColor1(ItemStack stack) {
        return ItemNBTHelper.getInt(stack, TAG_COLOR1, 0);
    }

    public static int getColor2(ItemStack stack) {
        return ItemNBTHelper.getInt(stack, TAG_COLOR2, 0);
    }

    public static void setBoundTile(ItemStack stack, int x, int y, int z) {
        ItemNBTHelper.setInt(stack, TAG_BOUND_TILE_X, x);
        ItemNBTHelper.setInt(stack, TAG_BOUND_TILE_Y, y);
        ItemNBTHelper.setInt(stack, TAG_BOUND_TILE_Z, z);
    }

    public static ChunkCoordinates getBoundTile(ItemStack stack) {
        int x = ItemNBTHelper.getInt(stack, TAG_BOUND_TILE_X, 0);
        int y = ItemNBTHelper.getInt(stack, TAG_BOUND_TILE_Y, -1);
        int z = ItemNBTHelper.getInt(stack, TAG_BOUND_TILE_Z, 0);
        return new ChunkCoordinates(x, y, z);
    }

    public static boolean getBindMode(ItemStack stack) {
        return ItemNBTHelper.getBoolean(stack, TAG_BIND_MODE, true);
    }

    public static void setBindMode(ItemStack stack, boolean bindMode) {
        ItemNBTHelper.setBoolean(stack, TAG_BIND_MODE, bindMode);
    }

    public static String getModeString(ItemStack stack) {
        return "botaniamisc.wandMode." + (ItemTwigWand.getBindMode(stack) ? "bind" : "function");
    }

    @Override
    public ChunkCoordinates getBinding(ItemStack stack) {
        TileEntity tile;
        ChunkCoordinates bound = ItemTwigWand.getBoundTile(stack);
        if (bound.field_71572_b != -1) {
            return bound;
        }
        MovingObjectPosition pos = Minecraft.func_71410_x().field_71476_x;
        if (pos != null && (tile = Minecraft.func_71410_x().field_71441_e.func_147438_o(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d)) instanceof ITileBound) {
            ChunkCoordinates coords = ((ITileBound)tile).getBinding();
            return coords;
        }
        return null;
    }
}

