/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block;

import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.oredict.RecipeSorter;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.lexicon.ILexiconable;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.subtile.ISpecialFlower;
import vazkii.botania.api.wand.IWandHUD;
import vazkii.botania.api.wand.IWandable;
import vazkii.botania.common.block.decor.BlockFloatingFlower;
import vazkii.botania.common.block.tile.TileFloatingSpecialFlower;
import vazkii.botania.common.block.tile.TileMod;
import vazkii.botania.common.block.tile.TileSpecialFlower;
import vazkii.botania.common.crafting.recipe.SpecialFloatingFlowerRecipe;
import vazkii.botania.common.integration.coloredlights.LightHelper;
import vazkii.botania.common.item.block.ItemBlockFloatingSpecialFlower;
import vazkii.botania.common.item.block.ItemBlockSpecialFlower;

public class BlockFloatingSpecialFlower
extends BlockFloatingFlower
implements ISpecialFlower,
IWandable,
ILexiconable,
IWandHUD {
    public BlockFloatingSpecialFlower() {
        super("floatingSpecialFlower");
        GameRegistry.addRecipe((IRecipe)new SpecialFloatingFlowerRecipe());
        RecipeSorter.register((String)"botania:floatingSpecialFlower", SpecialFloatingFlowerRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"");
    }

    @Override
    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        int currentLight = ((TileSpecialFlower)world.func_147438_o(x, y, z)).getLightValue();
        if (currentLight == -1) {
            currentLight = this.originalLight;
        }
        return LightHelper.getPackedColor(world.func_72805_g(x, y, z), currentLight);
    }

    public boolean func_149740_M() {
        return true;
    }

    public int func_149736_g(World world, int x, int y, int z, int side) {
        return ((TileSpecialFlower)world.func_147438_o(x, y, z)).getComparatorInputOverride(side);
    }

    public int func_149709_b(IBlockAccess world, int x, int y, int z, int side) {
        return ((TileSpecialFlower)world.func_147438_o(x, y, z)).getPowerLevel(side);
    }

    public int func_149748_c(IBlockAccess world, int x, int y, int z, int side) {
        return this.func_149709_b(world, x, y, z, side);
    }

    public boolean func_149744_f() {
        return true;
    }

    @Override
    public void func_149734_b(World world, int x, int y, int z, Random random) {
    }

    @Override
    public void func_149666_a(Item item, CreativeTabs tab, List<ItemStack> list) {
        for (String s : BotaniaAPI.subtilesForCreativeMenu) {
            list.add(ItemBlockSpecialFlower.ofType(new ItemStack(item), s));
            if (!BotaniaAPI.miniFlowers.containsKey((Object)s)) continue;
            list.add(ItemBlockSpecialFlower.ofType(new ItemStack(item), (String)BotaniaAPI.miniFlowers.get((Object)s)));
        }
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        String name = ((TileSpecialFlower)world.func_147438_o((int)x, (int)y, (int)z)).subTileName;
        return ItemBlockSpecialFlower.ofType(new ItemStack(world.func_147439_a(x, y, z)), name);
    }

    public void func_149681_a(World world, int x, int y, int z, int meta, EntityPlayer player) {
        if (!player.field_71075_bZ.field_75098_d) {
            this.func_149697_b(world, x, y, z, meta, 0);
            ((TileSpecialFlower)world.func_147438_o(x, y, z)).onBlockHarvested(world, x, y, z, meta, player);
        }
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile != null) {
            String name = ((TileSpecialFlower)tile).subTileName;
            list.add(ItemBlockSpecialFlower.ofType(new ItemStack(world.func_147439_a(x, y, z)), name));
            ((TileSpecialFlower)tile).getDrops(list);
        }
        return list;
    }

    public boolean func_149696_a(World world, int x, int y, int z, int eventId, int eventData) {
        super.func_149696_a(world, x, y, z, eventId, eventData);
        TileEntity tileentity = world.func_147438_o(x, y, z);
        return tileentity != null ? tileentity.func_145842_c(eventId, eventData) : false;
    }

    @Override
    public boolean onUsedByWand(EntityPlayer player, ItemStack stack, World world, int x, int y, int z, int side) {
        return ((TileSpecialFlower)world.func_147438_o(x, y, z)).onWanded(stack, player);
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        ((TileSpecialFlower)world.func_147438_o(x, y, z)).onBlockPlacedBy(world, x, y, z, entity, stack);
    }

    @Override
    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        return ((TileSpecialFlower)world.func_147438_o(x, y, z)).onBlockActivated(world, x, y, z, player, side, hitX, hitY, hitZ) || super.func_149727_a(world, x, y, z, player, side, hitX, hitY, hitZ);
    }

    public void func_149726_b(World world, int x, int y, int z) {
        ((TileSpecialFlower)world.func_147438_o(x, y, z)).onBlockAdded(world, x, y, z);
    }

    @Override
    public void renderHUD(Minecraft mc, ScaledResolution res, World world, int x, int y, int z) {
        ((TileSpecialFlower)world.func_147438_o(x, y, z)).renderHUD(mc, res);
    }

    @Override
    protected void register(String name) {
        GameRegistry.registerBlock((Block)this, ItemBlockFloatingSpecialFlower.class, (String)name);
    }

    @Override
    public TileMod createNewTileEntity(World world, int meta) {
        return new TileFloatingSpecialFlower();
    }

    @Override
    public LexiconEntry getEntry(World world, int x, int y, int z, EntityPlayer player, ItemStack lexicon) {
        return ((TileSpecialFlower)world.func_147438_o(x, y, z)).getEntry();
    }
}

