/*
 * Decompiled with CFR 0.152.
 */
package bq_standard.rewards;

import betterquesting.api.api.QuestingAPI;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.rewards.AbstractReward;
import betterquesting.api.questing.rewards.IReward;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.IGuiPanel;
import bq_standard.AdminExecute;
import bq_standard.client.gui.rewards.PanelRewardCommand;
import bq_standard.handlers.EventHandler;
import bq_standard.rewards.factory.FactoryRewardCommand;
import io.netty.buffer.ByteBuf;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.server.CommandBlockLogic;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class RewardCommand
extends AbstractReward
implements IReward {
    public String command = "/say VAR_NAME Claimed a reward";
    public boolean hideCmd = false;
    public boolean viaPlayer = false;

    @Override
    public ResourceLocation getFactoryID() {
        return FactoryRewardCommand.INSTANCE.getRegistryName();
    }

    @Override
    public String getUnlocalisedName() {
        return "bq_standard.reward.command";
    }

    @Override
    public boolean canClaim(EntityPlayer player, Map.Entry<UUID, IQuest> quest) {
        return true;
    }

    @Override
    protected boolean getDefaultIgnoreDisabled() {
        return true;
    }

    @Override
    protected void claimReward0(EntityPlayer player, Map.Entry<UUID, IQuest> quest) {
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        String tmp = this.command.replaceAll("VAR_NAME", player.func_70005_c_());
        String finCom = tmp.replaceAll("VAR_UUID", QuestingAPI.getQuestingUUID(player).toString());
        MinecraftServer server = MinecraftServer.func_71276_C();
        if (this.viaPlayer) {
            EventHandler.scheduleServerTask(() -> server.func_71187_D().func_71556_a((ICommandSender)new AdminExecute(player), finCom));
        } else {
            RewardCommandSender cmdSender = new RewardCommandSender(player.field_70170_p, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
            EventHandler.scheduleServerTask(() -> server.func_71187_D().func_71556_a((ICommandSender)cmdSender, finCom));
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.command = nbt.func_74779_i("command");
        this.hideCmd = nbt.func_74767_n("hideCommand");
        this.viaPlayer = nbt.func_74767_n("viaPlayer");
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74778_a("command", this.command);
        nbt.func_74757_a("hideCommand", this.hideCmd);
        nbt.func_74757_a("viaPlayer", this.viaPlayer);
        return nbt;
    }

    @Override
    public IGuiPanel getRewardGui(IGuiRect rect, Map.Entry<UUID, IQuest> quest) {
        return new PanelRewardCommand(rect, this);
    }

    @Override
    public GuiScreen getRewardEditor(GuiScreen screen, Map.Entry<UUID, IQuest> quest) {
        return null;
    }

    public static class RewardCommandSender
    extends CommandBlockLogic {
        private final World world;
        private final ChunkCoordinates blockLoc;

        private RewardCommandSender(World world, int x, int y, int z) {
            this.blockLoc = new ChunkCoordinates(x, y, z);
            this.world = world;
        }

        public ChunkCoordinates func_82114_b() {
            return this.blockLoc;
        }

        public World func_130014_f_() {
            return this.world;
        }

        public void func_145756_e() {
        }

        public int func_145751_f() {
            return 0;
        }

        public void func_145757_a(ByteBuf p_145757_1_) {
        }

        public String func_70005_c_() {
            return "BetterQuesting";
        }
    }
}

