/*
 * Decompiled with CFR 0.152.
 */
package de.katzenpapst.amunra.world.mapgen.village;

import de.katzenpapst.amunra.world.mapgen.BaseStructureComponent;
import de.katzenpapst.amunra.world.mapgen.BaseStructureStart;
import de.katzenpapst.amunra.world.mapgen.StructureGenerator;
import de.katzenpapst.amunra.world.mapgen.village.GridVillageComponent;
import de.katzenpapst.amunra.world.mapgen.village.GridVillageStart;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.util.MathHelper;

public class GridVillageGenerator
extends StructureGenerator {
    protected final List<StructureGenerator.SubComponentData> components = new ArrayList<StructureGenerator.SubComponentData>();
    protected int gridSize = 32;
    protected final Map<Long, GridVillageStart> structureMap = new HashMap<Long, GridVillageStart>();

    public void addComponentType(Class<? extends GridVillageComponent> clazz, float probability) {
        this.addComponentType(clazz, probability, 0, 0);
    }

    public void addComponentType(Class<? extends GridVillageComponent> clazz, float probability, int minAmount, int maxAmount) {
        this.components.add(new StructureGenerator.SubComponentData(clazz, probability, minAmount, maxAmount));
    }

    @Override
    protected boolean canGenerateHere(int chunkX, int chunkZ, Random rand) {
        int rangeShift = 5;
        int range = 32;
        int superchunkX = chunkX >> 5;
        int superchunkZ = chunkZ >> 5;
        int chunkStartX = superchunkX << 5;
        int chunkStartZ = superchunkZ << 5;
        int chunkEndX = chunkStartX + 32 - 1;
        int chunkEndZ = chunkStartZ + 32 - 1;
        this.rand.setSeed(this.worldObj.func_72905_C() ^ this.getSalt() ^ (long)superchunkX ^ (long)superchunkZ);
        int actualVillageX = MathHelper.func_76136_a((Random)this.rand, (int)chunkStartX, (int)chunkEndX);
        int actualVillageZ = MathHelper.func_76136_a((Random)this.rand, (int)chunkStartZ, (int)chunkEndZ);
        return chunkX == actualVillageX && chunkZ == actualVillageZ;
    }

    @Override
    protected BaseStructureStart createNewStructure(int xChunkCoord, int zChunkCoord) {
        Random rand4structure = new Random(this.worldObj.func_72905_C() ^ this.getSalt() ^ (long)xChunkCoord ^ (long)zChunkCoord);
        GridVillageStart start = new GridVillageStart(this.worldObj, xChunkCoord, zChunkCoord, rand4structure);
        List<BaseStructureComponent> compList = this.generateSubComponents(this.components, rand4structure, 0);
        start.setComponents(compList);
        return start;
    }

    @Override
    public String getName() {
        return "GridVillage";
    }

    @Override
    protected long getSalt() {
        return 1098540180186541L;
    }
}

