/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.zstd;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.util.zstd.LibZstd;
import org.lwjgl.util.zstd.ZSTDBounds;
import org.lwjgl.util.zstd.ZSTDInBuffer;
import org.lwjgl.util.zstd.ZSTDOutBuffer;

public class Zstd {
    public static final int ZSTD_VERSION_MAJOR = 1;
    public static final int ZSTD_VERSION_MINOR = 5;
    public static final int ZSTD_VERSION_RELEASE = 7;
    public static final int ZSTD_VERSION_NUMBER = 10507;
    public static final String ZSTD_VERSION_STRING = "1.5.7";
    public static final int ZSTD_CLEVEL_DEFAULT = 3;
    public static final int ZSTD_MAGICNUMBER = -47205080;
    public static final int ZSTD_MAGIC_DICTIONARY = -332356553;
    public static final int ZSTD_MAGIC_SKIPPABLE_START = 407710288;
    public static final int ZSTD_MAGIC_SKIPPABLE_MASK = -16;
    public static final int ZSTD_BLOCKSIZELOG_MAX = 17;
    public static final int ZSTD_BLOCKSIZE_MAX = 131072;
    public static final long ZSTD_CONTENTSIZE_UNKNOWN = -1L;
    public static final long ZSTD_CONTENTSIZE_ERROR = -2L;
    public static final int ZSTD_fast = 1;
    public static final int ZSTD_dfast = 2;
    public static final int ZSTD_greedy = 3;
    public static final int ZSTD_lazy = 4;
    public static final int ZSTD_lazy2 = 5;
    public static final int ZSTD_btlazy2 = 6;
    public static final int ZSTD_btopt = 7;
    public static final int ZSTD_btultra = 8;
    public static final int ZSTD_btultra2 = 9;
    public static final int ZSTD_c_compressionLevel = 100;
    public static final int ZSTD_c_windowLog = 101;
    public static final int ZSTD_c_hashLog = 102;
    public static final int ZSTD_c_chainLog = 103;
    public static final int ZSTD_c_searchLog = 104;
    public static final int ZSTD_c_minMatch = 105;
    public static final int ZSTD_c_targetLength = 106;
    public static final int ZSTD_c_strategy = 107;
    public static final int ZSTD_c_targetCBlockSize = 108;
    public static final int ZSTD_c_enableLongDistanceMatching = 160;
    public static final int ZSTD_c_ldmHashLog = 161;
    public static final int ZSTD_c_ldmMinMatch = 162;
    public static final int ZSTD_c_ldmBucketSizeLog = 163;
    public static final int ZSTD_c_ldmHashRateLog = 164;
    public static final int ZSTD_c_contentSizeFlag = 200;
    public static final int ZSTD_c_checksumFlag = 201;
    public static final int ZSTD_c_dictIDFlag = 202;
    public static final int ZSTD_c_nbWorkers = 400;
    public static final int ZSTD_c_jobSize = 401;
    public static final int ZSTD_c_overlapLog = 402;
    public static final int ZSTD_c_experimentalParam1 = 500;
    public static final int ZSTD_c_experimentalParam2 = 10;
    public static final int ZSTD_c_experimentalParam3 = 1000;
    public static final int ZSTD_c_experimentalParam4 = 1001;
    public static final int ZSTD_c_experimentalParam5 = 1002;
    public static final int ZSTD_c_experimentalParam7 = 1004;
    public static final int ZSTD_c_experimentalParam8 = 1005;
    public static final int ZSTD_c_experimentalParam9 = 1006;
    public static final int ZSTD_c_experimentalParam10 = 1007;
    public static final int ZSTD_c_experimentalParam11 = 1008;
    public static final int ZSTD_c_experimentalParam12 = 1009;
    public static final int ZSTD_c_experimentalParam13 = 1010;
    public static final int ZSTD_c_experimentalParam14 = 1011;
    public static final int ZSTD_c_experimentalParam15 = 1012;
    public static final int ZSTD_c_experimentalParam16 = 1013;
    public static final int ZSTD_c_experimentalParam17 = 1014;
    public static final int ZSTD_c_experimentalParam18 = 1015;
    public static final int ZSTD_c_experimentalParam19 = 1016;
    public static final int ZSTD_c_experimentalParam20 = 1017;
    public static final int ZSTD_reset_session_only = 1;
    public static final int ZSTD_reset_parameters = 2;
    public static final int ZSTD_reset_session_and_parameters = 3;
    public static final int ZSTD_d_windowLogMax = 100;
    public static final int ZSTD_d_experimentalParam1 = 1000;
    public static final int ZSTD_d_experimentalParam2 = 1001;
    public static final int ZSTD_d_experimentalParam3 = 1002;
    public static final int ZSTD_d_experimentalParam4 = 1003;
    public static final int ZSTD_d_experimentalParam5 = 1004;
    public static final int ZSTD_d_experimentalParam6 = 1005;
    public static final int ZSTD_e_continue = 0;
    public static final int ZSTD_e_flush = 1;
    public static final int ZSTD_e_end = 2;

    protected Zstd() {
        throw new UnsupportedOperationException();
    }

    @NativeType(value="unsigned")
    public static native int ZSTD_versionNumber();

    public static native long nZSTD_versionString();

    @NativeType(value="char const *")
    public static String ZSTD_versionString() {
        long __result = Zstd.nZSTD_versionString();
        return MemoryUtil.memASCII((long)__result);
    }

    public static native long nZSTD_compress(long var0, long var2, long var4, long var6, int var8);

    @NativeType(value="size_t")
    public static long ZSTD_compress(@NativeType(value="void *") ByteBuffer dst, @NativeType(value="void const *") ByteBuffer src, int compressionLevel) {
        return Zstd.nZSTD_compress(MemoryUtil.memAddress((ByteBuffer)dst), dst.remaining(), MemoryUtil.memAddress((ByteBuffer)src), src.remaining(), compressionLevel);
    }

    public static native long nZSTD_decompress(long var0, long var2, long var4, long var6);

    @NativeType(value="size_t")
    public static long ZSTD_decompress(@NativeType(value="void *") ByteBuffer dst, @NativeType(value="void const *") ByteBuffer src) {
        return Zstd.nZSTD_decompress(MemoryUtil.memAddress((ByteBuffer)dst), dst.remaining(), MemoryUtil.memAddress((ByteBuffer)src), src.remaining());
    }

    public static native long nZSTD_getFrameContentSize(long var0, long var2);

    @NativeType(value="unsigned long long")
    public static long ZSTD_getFrameContentSize(@NativeType(value="void const *") ByteBuffer src) {
        return Zstd.nZSTD_getFrameContentSize(MemoryUtil.memAddress((ByteBuffer)src), src.remaining());
    }

    public static native long nZSTD_findFrameCompressedSize(long var0, long var2);

    @NativeType(value="size_t")
    public static long ZSTD_findFrameCompressedSize(@NativeType(value="void const *") ByteBuffer src) {
        return Zstd.nZSTD_findFrameCompressedSize(MemoryUtil.memAddress((ByteBuffer)src), src.remaining());
    }

    @NativeType(value="size_t")
    public static native long ZSTD_compressBound(@NativeType(value="size_t") long var0);

    public static native int nZSTD_isError(long var0);

    @NativeType(value="unsigned int")
    public static boolean ZSTD_isError(@NativeType(value="size_t") long result) {
        return Zstd.nZSTD_isError(result) != 0;
    }

    @NativeType(value="ZSTD_ErrorCode")
    public static native int ZSTD_getErrorCode(@NativeType(value="size_t") long var0);

    public static native long nZSTD_getErrorName(long var0);

    @NativeType(value="char const *")
    public static String ZSTD_getErrorName(@NativeType(value="size_t") long result) {
        long __result = Zstd.nZSTD_getErrorName(result);
        return MemoryUtil.memASCII((long)__result);
    }

    public static native int ZSTD_minCLevel();

    public static native int ZSTD_maxCLevel();

    public static native int ZSTD_defaultCLevel();

    @NativeType(value="ZSTD_CCtx *")
    public static native long ZSTD_createCCtx();

    @NativeType(value="size_t")
    public static native long ZSTD_freeCCtx(@NativeType(value="ZSTD_CCtx *") long var0);

    public static native long nZSTD_compressCCtx(long var0, long var2, long var4, long var6, long var8, int var10);

    @NativeType(value="size_t")
    public static long ZSTD_compressCCtx(@NativeType(value="ZSTD_CCtx *") long ctx, @NativeType(value="void *") ByteBuffer dst, @NativeType(value="void const *") ByteBuffer src, int compressionLevel) {
        if (Checks.CHECKS) {
            Checks.check((long)ctx);
        }
        return Zstd.nZSTD_compressCCtx(ctx, MemoryUtil.memAddress((ByteBuffer)dst), dst.remaining(), MemoryUtil.memAddress((ByteBuffer)src), src.remaining(), compressionLevel);
    }

    @NativeType(value="ZSTD_DCtx *")
    public static native long ZSTD_createDCtx();

    @NativeType(value="size_t")
    public static native long ZSTD_freeDCtx(@NativeType(value="ZSTD_DCtx *") long var0);

    public static native long nZSTD_decompressDCtx(long var0, long var2, long var4, long var6, long var8);

    @NativeType(value="size_t")
    public static long ZSTD_decompressDCtx(@NativeType(value="ZSTD_DCtx *") long ctx, @NativeType(value="void *") ByteBuffer dst, @NativeType(value="void const *") ByteBuffer src) {
        if (Checks.CHECKS) {
            Checks.check((long)ctx);
        }
        return Zstd.nZSTD_decompressDCtx(ctx, MemoryUtil.memAddress((ByteBuffer)dst), dst.remaining(), MemoryUtil.memAddress((ByteBuffer)src), src.remaining());
    }

    public static native void nZSTD_cParam_getBounds(int var0, long var1);

    @NativeType(value="ZSTD_bounds")
    public static ZSTDBounds ZSTD_cParam_getBounds(@NativeType(value="ZSTD_cParameter") int cParam, @NativeType(value="ZSTD_bounds") ZSTDBounds __result) {
        Zstd.nZSTD_cParam_getBounds(cParam, __result.address());
        return __result;
    }

    public static native long nZSTD_CCtx_setParameter(long var0, int var2, int var3);

    @NativeType(value="size_t")
    public static long ZSTD_CCtx_setParameter(@NativeType(value="ZSTD_CCtx *") long cctx, @NativeType(value="ZSTD_cParameter") int param, int value) {
        if (Checks.CHECKS) {
            Checks.check((long)cctx);
        }
        return Zstd.nZSTD_CCtx_setParameter(cctx, param, value);
    }

    public static native long nZSTD_CCtx_setPledgedSrcSize(long var0, long var2);

    @NativeType(value="size_t")
    public static long ZSTD_CCtx_setPledgedSrcSize(@NativeType(value="ZSTD_CCtx *") long cctx, @NativeType(value="unsigned long long") long pledgedSrcSize) {
        if (Checks.CHECKS) {
            Checks.check((long)cctx);
        }
        return Zstd.nZSTD_CCtx_setPledgedSrcSize(cctx, pledgedSrcSize);
    }

    public static native long nZSTD_CCtx_reset(long var0, int var2);

    @NativeType(value="size_t")
    public static long ZSTD_CCtx_reset(@NativeType(value="ZSTD_CCtx *") long cctx, @NativeType(value="ZSTD_ResetDirective") int reset) {
        if (Checks.CHECKS) {
            Checks.check((long)cctx);
        }
        return Zstd.nZSTD_CCtx_reset(cctx, reset);
    }

    public static native long nZSTD_compress2(long var0, long var2, long var4, long var6, long var8);

    @NativeType(value="size_t")
    public static long ZSTD_compress2(@NativeType(value="ZSTD_CCtx *") long cctx, @NativeType(value="void *") ByteBuffer dst, @NativeType(value="void const *") ByteBuffer src) {
        if (Checks.CHECKS) {
            Checks.check((long)cctx);
        }
        return Zstd.nZSTD_compress2(cctx, MemoryUtil.memAddress((ByteBuffer)dst), dst.remaining(), MemoryUtil.memAddress((ByteBuffer)src), src.remaining());
    }

    public static native void nZSTD_dParam_getBounds(int var0, long var1);

    @NativeType(value="ZSTD_bounds")
    public static ZSTDBounds ZSTD_dParam_getBounds(@NativeType(value="ZSTD_dParameter") int dParam, @NativeType(value="ZSTD_bounds") ZSTDBounds __result) {
        Zstd.nZSTD_dParam_getBounds(dParam, __result.address());
        return __result;
    }

    public static native long nZSTD_DCtx_setParameter(long var0, int var2, int var3);

    @NativeType(value="size_t")
    public static long ZSTD_DCtx_setParameter(@NativeType(value="ZSTD_DCtx *") long dctx, @NativeType(value="ZSTD_dParameter") int param, int value) {
        if (Checks.CHECKS) {
            Checks.check((long)dctx);
        }
        return Zstd.nZSTD_DCtx_setParameter(dctx, param, value);
    }

    public static native long nZSTD_DCtx_reset(long var0, int var2);

    @NativeType(value="size_t")
    public static long ZSTD_DCtx_reset(@NativeType(value="ZSTD_DCtx *") long dctx, @NativeType(value="ZSTD_ResetDirective") int reset) {
        if (Checks.CHECKS) {
            Checks.check((long)dctx);
        }
        return Zstd.nZSTD_DCtx_reset(dctx, reset);
    }

    @NativeType(value="ZSTD_CStream *")
    public static native long ZSTD_createCStream();

    @NativeType(value="size_t")
    public static native long ZSTD_freeCStream(@NativeType(value="ZSTD_CStream *") long var0);

    public static native long nZSTD_compressStream2(long var0, long var2, long var4, int var6);

    @NativeType(value="size_t")
    public static long ZSTD_compressStream2(@NativeType(value="ZSTD_CCtx *") long cctx, @NativeType(value="ZSTD_outBuffer *") ZSTDOutBuffer output, @NativeType(value="ZSTD_inBuffer *") ZSTDInBuffer input, @NativeType(value="ZSTD_EndDirective") int endOp) {
        if (Checks.CHECKS) {
            Checks.check((long)cctx);
            ZSTDOutBuffer.validate(output.address());
            ZSTDInBuffer.validate(input.address());
        }
        return Zstd.nZSTD_compressStream2(cctx, output.address(), input.address(), endOp);
    }

    @NativeType(value="size_t")
    public static native long ZSTD_CStreamInSize();

    @NativeType(value="size_t")
    public static native long ZSTD_CStreamOutSize();

    @NativeType(value="ZSTD_DStream *")
    public static native long ZSTD_createDStream();

    @NativeType(value="size_t")
    public static native long ZSTD_freeDStream(@NativeType(value="ZSTD_DStream *") long var0);

    public static native long nZSTD_decompressStream(long var0, long var2, long var4);

    @NativeType(value="size_t")
    public static long ZSTD_decompressStream(@NativeType(value="ZSTD_DStream *") long zds, @NativeType(value="ZSTD_outBuffer *") ZSTDOutBuffer output, @NativeType(value="ZSTD_inBuffer *") ZSTDInBuffer input) {
        if (Checks.CHECKS) {
            Checks.check((long)zds);
            ZSTDOutBuffer.validate(output.address());
            ZSTDInBuffer.validate(input.address());
        }
        return Zstd.nZSTD_decompressStream(zds, output.address(), input.address());
    }

    @NativeType(value="size_t")
    public static native long ZSTD_DStreamInSize();

    @NativeType(value="size_t")
    public static native long ZSTD_DStreamOutSize();

    public static native long nZSTD_compress_usingDict(long var0, long var2, long var4, long var6, long var8, long var10, long var12, int var14);

    @NativeType(value="size_t")
    public static long ZSTD_compress_usingDict(@NativeType(value="ZSTD_CCtx *") long ctx, @NativeType(value="void *") ByteBuffer dst, @NativeType(value="void const *") ByteBuffer src, @NativeType(value="void const *") @Nullable ByteBuffer dict, int compressionLevel) {
        if (Checks.CHECKS) {
            Checks.check((long)ctx);
        }
        return Zstd.nZSTD_compress_usingDict(ctx, MemoryUtil.memAddress((ByteBuffer)dst), dst.remaining(), MemoryUtil.memAddress((ByteBuffer)src), src.remaining(), MemoryUtil.memAddressSafe((ByteBuffer)dict), Checks.remainingSafe((Buffer)dict), compressionLevel);
    }

    public static native long nZSTD_decompress_usingDict(long var0, long var2, long var4, long var6, long var8, long var10, long var12);

    @NativeType(value="size_t")
    public static long ZSTD_decompress_usingDict(@NativeType(value="ZSTD_DCtx *") long dctx, @NativeType(value="void *") ByteBuffer dst, @NativeType(value="void const *") ByteBuffer src, @NativeType(value="void const *") @Nullable ByteBuffer dict) {
        if (Checks.CHECKS) {
            Checks.check((long)dctx);
        }
        return Zstd.nZSTD_decompress_usingDict(dctx, MemoryUtil.memAddress((ByteBuffer)dst), dst.remaining(), MemoryUtil.memAddress((ByteBuffer)src), src.remaining(), MemoryUtil.memAddressSafe((ByteBuffer)dict), Checks.remainingSafe((Buffer)dict));
    }

    public static native long nZSTD_createCDict(long var0, long var2, int var4);

    @NativeType(value="ZSTD_CDict *")
    public static long ZSTD_createCDict(@NativeType(value="void const *") ByteBuffer dictBuffer, int compressionLevel) {
        return Zstd.nZSTD_createCDict(MemoryUtil.memAddress((ByteBuffer)dictBuffer), dictBuffer.remaining(), compressionLevel);
    }

    @NativeType(value="size_t")
    public static native long ZSTD_freeCDict(@NativeType(value="ZSTD_CDict *") long var0);

    public static native long nZSTD_compress_usingCDict(long var0, long var2, long var4, long var6, long var8, long var10);

    @NativeType(value="size_t")
    public static long ZSTD_compress_usingCDict(@NativeType(value="ZSTD_CCtx *") long cctx, @NativeType(value="void *") ByteBuffer dst, @NativeType(value="void const *") ByteBuffer src, @NativeType(value="ZSTD_CDict const *") long cdict) {
        if (Checks.CHECKS) {
            Checks.check((long)cctx);
            Checks.check((long)cdict);
        }
        return Zstd.nZSTD_compress_usingCDict(cctx, MemoryUtil.memAddress((ByteBuffer)dst), dst.remaining(), MemoryUtil.memAddress((ByteBuffer)src), src.remaining(), cdict);
    }

    public static native long nZSTD_createDDict(long var0, long var2);

    @NativeType(value="ZSTD_DDict *")
    public static long ZSTD_createDDict(@NativeType(value="void const *") ByteBuffer dictBuffer) {
        return Zstd.nZSTD_createDDict(MemoryUtil.memAddress((ByteBuffer)dictBuffer), dictBuffer.remaining());
    }

    @NativeType(value="size_t")
    public static native long ZSTD_freeDDict(@NativeType(value="ZSTD_DDict *") long var0);

    public static native long nZSTD_decompress_usingDDict(long var0, long var2, long var4, long var6, long var8, long var10);

    @NativeType(value="size_t")
    public static long ZSTD_decompress_usingDDict(@NativeType(value="ZSTD_DCtx *") long dctx, @NativeType(value="void *") ByteBuffer dst, @NativeType(value="void const *") ByteBuffer src, @NativeType(value="ZSTD_DDict const *") long ddict) {
        if (Checks.CHECKS) {
            Checks.check((long)dctx);
            Checks.check((long)ddict);
        }
        return Zstd.nZSTD_decompress_usingDDict(dctx, MemoryUtil.memAddress((ByteBuffer)dst), dst.remaining(), MemoryUtil.memAddress((ByteBuffer)src), src.remaining(), ddict);
    }

    public static native int nZSTD_getDictID_fromDict(long var0, long var2);

    @NativeType(value="unsigned int")
    public static int ZSTD_getDictID_fromDict(@NativeType(value="void const *") ByteBuffer dict) {
        return Zstd.nZSTD_getDictID_fromDict(MemoryUtil.memAddress((ByteBuffer)dict), dict.remaining());
    }

    public static native int nZSTD_getDictID_fromCDict(long var0);

    @NativeType(value="unsigned")
    public static int ZSTD_getDictID_fromCDict(@NativeType(value="ZSTD_CDict const *") long cdict) {
        if (Checks.CHECKS) {
            Checks.check((long)cdict);
        }
        return Zstd.nZSTD_getDictID_fromCDict(cdict);
    }

    public static native int nZSTD_getDictID_fromDDict(long var0);

    @NativeType(value="unsigned int")
    public static int ZSTD_getDictID_fromDDict(@NativeType(value="ZSTD_DDict const *") long ddict) {
        if (Checks.CHECKS) {
            Checks.check((long)ddict);
        }
        return Zstd.nZSTD_getDictID_fromDDict(ddict);
    }

    public static native int nZSTD_getDictID_fromFrame(long var0, long var2);

    @NativeType(value="unsigned int")
    public static int ZSTD_getDictID_fromFrame(@NativeType(value="void const *") ByteBuffer src) {
        return Zstd.nZSTD_getDictID_fromFrame(MemoryUtil.memAddress((ByteBuffer)src), src.remaining());
    }

    public static native long nZSTD_CCtx_loadDictionary(long var0, long var2, long var4);

    @NativeType(value="size_t")
    public static long ZSTD_CCtx_loadDictionary(@NativeType(value="ZSTD_CCtx *") long cctx, @NativeType(value="void const *") @Nullable ByteBuffer dict) {
        if (Checks.CHECKS) {
            Checks.check((long)cctx);
        }
        return Zstd.nZSTD_CCtx_loadDictionary(cctx, MemoryUtil.memAddressSafe((ByteBuffer)dict), Checks.remainingSafe((Buffer)dict));
    }

    public static native long nZSTD_CCtx_refCDict(long var0, long var2);

    @NativeType(value="size_t")
    public static long ZSTD_CCtx_refCDict(@NativeType(value="ZSTD_CCtx *") long cctx, @NativeType(value="ZSTD_CDict const *") long cdict) {
        if (Checks.CHECKS) {
            Checks.check((long)cctx);
        }
        return Zstd.nZSTD_CCtx_refCDict(cctx, cdict);
    }

    public static native long nZSTD_CCtx_refPrefix(long var0, long var2, long var4);

    @NativeType(value="size_t")
    public static long ZSTD_CCtx_refPrefix(@NativeType(value="ZSTD_CCtx *") long cctx, @NativeType(value="void const *") @Nullable ByteBuffer prefix) {
        if (Checks.CHECKS) {
            Checks.check((long)cctx);
        }
        return Zstd.nZSTD_CCtx_refPrefix(cctx, MemoryUtil.memAddressSafe((ByteBuffer)prefix), Checks.remainingSafe((Buffer)prefix));
    }

    public static native long nZSTD_DCtx_loadDictionary(long var0, long var2, long var4);

    @NativeType(value="size_t")
    public static long ZSTD_DCtx_loadDictionary(@NativeType(value="ZSTD_DCtx *") long dctx, @NativeType(value="void const *") @Nullable ByteBuffer dict) {
        if (Checks.CHECKS) {
            Checks.check((long)dctx);
        }
        return Zstd.nZSTD_DCtx_loadDictionary(dctx, MemoryUtil.memAddressSafe((ByteBuffer)dict), Checks.remainingSafe((Buffer)dict));
    }

    public static native long nZSTD_DCtx_refDDict(long var0, long var2);

    @NativeType(value="size_t")
    public static long ZSTD_DCtx_refDDict(@NativeType(value="ZSTD_DCtx *") long dctx, @NativeType(value="ZSTD_DDict const *") long ddict) {
        if (Checks.CHECKS) {
            Checks.check((long)dctx);
        }
        return Zstd.nZSTD_DCtx_refDDict(dctx, ddict);
    }

    public static native long nZSTD_DCtx_refPrefix(long var0, long var2, long var4);

    @NativeType(value="size_t")
    public static long ZSTD_DCtx_refPrefix(@NativeType(value="ZSTD_DCtx *") long dctx, @NativeType(value="void const *") ByteBuffer prefix) {
        if (Checks.CHECKS) {
            Checks.check((long)dctx);
        }
        return Zstd.nZSTD_DCtx_refPrefix(dctx, MemoryUtil.memAddress((ByteBuffer)prefix), prefix.remaining());
    }

    public static native long nZSTD_sizeof_CCtx(long var0);

    @NativeType(value="size_t")
    public static long ZSTD_sizeof_CCtx(@NativeType(value="ZSTD_CCtx const *") long cctx) {
        if (Checks.CHECKS) {
            Checks.check((long)cctx);
        }
        return Zstd.nZSTD_sizeof_CCtx(cctx);
    }

    public static native long nZSTD_sizeof_DCtx(long var0);

    @NativeType(value="size_t")
    public static long ZSTD_sizeof_DCtx(@NativeType(value="ZSTD_DCtx const *") long dctx) {
        if (Checks.CHECKS) {
            Checks.check((long)dctx);
        }
        return Zstd.nZSTD_sizeof_DCtx(dctx);
    }

    public static native long nZSTD_sizeof_CStream(long var0);

    @NativeType(value="size_t")
    public static long ZSTD_sizeof_CStream(@NativeType(value="ZSTD_CStream const *") long zcs) {
        if (Checks.CHECKS) {
            Checks.check((long)zcs);
        }
        return Zstd.nZSTD_sizeof_CStream(zcs);
    }

    public static native long nZSTD_sizeof_DStream(long var0);

    @NativeType(value="size_t")
    public static long ZSTD_sizeof_DStream(@NativeType(value="ZSTD_DStream const *") long zds) {
        if (Checks.CHECKS) {
            Checks.check((long)zds);
        }
        return Zstd.nZSTD_sizeof_DStream(zds);
    }

    public static native long nZSTD_sizeof_CDict(long var0);

    @NativeType(value="size_t")
    public static long ZSTD_sizeof_CDict(@NativeType(value="ZSTD_CDict const *") long cdict) {
        if (Checks.CHECKS) {
            Checks.check((long)cdict);
        }
        return Zstd.nZSTD_sizeof_CDict(cdict);
    }

    public static native long nZSTD_sizeof_DDict(long var0);

    @NativeType(value="size_t")
    public static long ZSTD_sizeof_DDict(@NativeType(value="ZSTD_DDict const *") long ddict) {
        if (Checks.CHECKS) {
            Checks.check((long)ddict);
        }
        return Zstd.nZSTD_sizeof_DDict(ddict);
    }

    public static long ZSTD_COMPRESSBOUND(long srcSize) {
        return srcSize + (srcSize >> 8) + (srcSize < 131072L ? 131072L - srcSize >> 11 : 0L);
    }

    static {
        LibZstd.initialize();
    }
}

