/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.zstd;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.util.zstd.ZSTDAllocFunction;
import org.lwjgl.util.zstd.ZSTDAllocFunctionI;
import org.lwjgl.util.zstd.ZSTDFreeFunction;
import org.lwjgl.util.zstd.ZSTDFreeFunctionI;

@NativeType(value="struct ZSTD_customMem")
public class ZSTDCustomMem
extends Struct<ZSTDCustomMem>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int CUSTOMALLOC;
    public static final int CUSTOMFREE;
    public static final int OPAQUE;

    protected ZSTDCustomMem(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected ZSTDCustomMem create(long address, @Nullable ByteBuffer container) {
        return new ZSTDCustomMem(address, container);
    }

    public ZSTDCustomMem(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), ZSTDCustomMem.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="ZSTD_allocFunction")
    public ZSTDAllocFunction customAlloc() {
        return ZSTDCustomMem.ncustomAlloc(this.address());
    }

    @NativeType(value="ZSTD_freeFunction")
    public ZSTDFreeFunction customFree() {
        return ZSTDCustomMem.ncustomFree(this.address());
    }

    @NativeType(value="void *")
    public long opaque() {
        return ZSTDCustomMem.nopaque(this.address());
    }

    public ZSTDCustomMem customAlloc(@NativeType(value="ZSTD_allocFunction") ZSTDAllocFunctionI value) {
        ZSTDCustomMem.ncustomAlloc(this.address(), value);
        return this;
    }

    public ZSTDCustomMem customFree(@NativeType(value="ZSTD_freeFunction") ZSTDFreeFunctionI value) {
        ZSTDCustomMem.ncustomFree(this.address(), value);
        return this;
    }

    public ZSTDCustomMem opaque(@NativeType(value="void *") long value) {
        ZSTDCustomMem.nopaque(this.address(), value);
        return this;
    }

    public ZSTDCustomMem set(ZSTDAllocFunctionI customAlloc, ZSTDFreeFunctionI customFree, long opaque) {
        this.customAlloc(customAlloc);
        this.customFree(customFree);
        this.opaque(opaque);
        return this;
    }

    public ZSTDCustomMem set(ZSTDCustomMem src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static ZSTDCustomMem malloc() {
        return new ZSTDCustomMem(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static ZSTDCustomMem calloc() {
        return new ZSTDCustomMem(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static ZSTDCustomMem create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new ZSTDCustomMem(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static ZSTDCustomMem create(long address) {
        return new ZSTDCustomMem(address, null);
    }

    public static @Nullable ZSTDCustomMem createSafe(long address) {
        return address == 0L ? null : new ZSTDCustomMem(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)ZSTDCustomMem.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = ZSTDCustomMem.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static ZSTDCustomMem malloc(MemoryStack stack) {
        return new ZSTDCustomMem(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static ZSTDCustomMem calloc(MemoryStack stack) {
        return new ZSTDCustomMem(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ZSTDAllocFunction ncustomAlloc(long struct) {
        return ZSTDAllocFunction.create(MemoryUtil.memGetAddress((long)(struct + (long)CUSTOMALLOC)));
    }

    public static ZSTDFreeFunction ncustomFree(long struct) {
        return ZSTDFreeFunction.create(MemoryUtil.memGetAddress((long)(struct + (long)CUSTOMFREE)));
    }

    public static long nopaque(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)OPAQUE));
    }

    public static void ncustomAlloc(long struct, ZSTDAllocFunctionI value) {
        MemoryUtil.memPutAddress((long)(struct + (long)CUSTOMALLOC), (long)value.address());
    }

    public static void ncustomFree(long struct, ZSTDFreeFunctionI value) {
        MemoryUtil.memPutAddress((long)(struct + (long)CUSTOMFREE), (long)value.address());
    }

    public static void nopaque(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)OPAQUE), (long)Checks.check((long)value));
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)CUSTOMALLOC)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)CUSTOMFREE)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)OPAQUE)));
    }

    static {
        Struct.Layout layout = ZSTDCustomMem.__struct((Struct.Member[])new Struct.Member[]{ZSTDCustomMem.__member((int)POINTER_SIZE), ZSTDCustomMem.__member((int)POINTER_SIZE), ZSTDCustomMem.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        CUSTOMALLOC = layout.offsetof(0);
        CUSTOMFREE = layout.offsetof(1);
        OPAQUE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<ZSTDCustomMem, Buffer>
    implements NativeResource {
        private static final ZSTDCustomMem ELEMENT_FACTORY = ZSTDCustomMem.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected ZSTDCustomMem getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="ZSTD_allocFunction")
        public ZSTDAllocFunction customAlloc() {
            return ZSTDCustomMem.ncustomAlloc(this.address());
        }

        @NativeType(value="ZSTD_freeFunction")
        public ZSTDFreeFunction customFree() {
            return ZSTDCustomMem.ncustomFree(this.address());
        }

        @NativeType(value="void *")
        public long opaque() {
            return ZSTDCustomMem.nopaque(this.address());
        }

        public Buffer customAlloc(@NativeType(value="ZSTD_allocFunction") ZSTDAllocFunctionI value) {
            ZSTDCustomMem.ncustomAlloc(this.address(), value);
            return this;
        }

        public Buffer customFree(@NativeType(value="ZSTD_freeFunction") ZSTDFreeFunctionI value) {
            ZSTDCustomMem.ncustomFree(this.address(), value);
            return this;
        }

        public Buffer opaque(@NativeType(value="void *") long value) {
            ZSTDCustomMem.nopaque(this.address(), value);
            return this;
        }
    }
}

