/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.zstd;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.util.zstd.ZDICTParams;

@NativeType(value="struct ZDICT_cover_params_t")
public class ZDICTCoverParams
extends Struct<ZDICTCoverParams>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int K;
    public static final int D;
    public static final int STEPS;
    public static final int NBTHREADS;
    public static final int SPLITPOINT;
    public static final int ZPARAMS;

    protected ZDICTCoverParams(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected ZDICTCoverParams create(long address, @Nullable ByteBuffer container) {
        return new ZDICTCoverParams(address, container);
    }

    public ZDICTCoverParams(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), ZDICTCoverParams.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="unsigned")
    public int k() {
        return ZDICTCoverParams.nk(this.address());
    }

    @NativeType(value="unsigned")
    public int d() {
        return ZDICTCoverParams.nd(this.address());
    }

    @NativeType(value="unsigned")
    public int steps() {
        return ZDICTCoverParams.nsteps(this.address());
    }

    @NativeType(value="unsigned")
    public int nbThreads() {
        return ZDICTCoverParams.nnbThreads(this.address());
    }

    public double splitPoint() {
        return ZDICTCoverParams.nsplitPoint(this.address());
    }

    @NativeType(value="ZDICT_params_t")
    public ZDICTParams zParams() {
        return ZDICTCoverParams.nzParams(this.address());
    }

    public ZDICTCoverParams k(@NativeType(value="unsigned") int value) {
        ZDICTCoverParams.nk(this.address(), value);
        return this;
    }

    public ZDICTCoverParams d(@NativeType(value="unsigned") int value) {
        ZDICTCoverParams.nd(this.address(), value);
        return this;
    }

    public ZDICTCoverParams steps(@NativeType(value="unsigned") int value) {
        ZDICTCoverParams.nsteps(this.address(), value);
        return this;
    }

    public ZDICTCoverParams nbThreads(@NativeType(value="unsigned") int value) {
        ZDICTCoverParams.nnbThreads(this.address(), value);
        return this;
    }

    public ZDICTCoverParams splitPoint(double value) {
        ZDICTCoverParams.nsplitPoint(this.address(), value);
        return this;
    }

    public ZDICTCoverParams zParams(@NativeType(value="ZDICT_params_t") ZDICTParams value) {
        ZDICTCoverParams.nzParams(this.address(), value);
        return this;
    }

    public ZDICTCoverParams zParams(Consumer<ZDICTParams> consumer) {
        consumer.accept(this.zParams());
        return this;
    }

    public ZDICTCoverParams set(int k, int d, int steps, int nbThreads, double splitPoint, ZDICTParams zParams) {
        this.k(k);
        this.d(d);
        this.steps(steps);
        this.nbThreads(nbThreads);
        this.splitPoint(splitPoint);
        this.zParams(zParams);
        return this;
    }

    public ZDICTCoverParams set(ZDICTCoverParams src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static ZDICTCoverParams malloc() {
        return new ZDICTCoverParams(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static ZDICTCoverParams calloc() {
        return new ZDICTCoverParams(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static ZDICTCoverParams create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new ZDICTCoverParams(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static ZDICTCoverParams create(long address) {
        return new ZDICTCoverParams(address, null);
    }

    public static @Nullable ZDICTCoverParams createSafe(long address) {
        return address == 0L ? null : new ZDICTCoverParams(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)ZDICTCoverParams.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = ZDICTCoverParams.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static ZDICTCoverParams malloc(MemoryStack stack) {
        return new ZDICTCoverParams(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static ZDICTCoverParams calloc(MemoryStack stack) {
        return new ZDICTCoverParams(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nk(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)K));
    }

    public static int nd(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)D));
    }

    public static int nsteps(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)STEPS));
    }

    public static int nnbThreads(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)NBTHREADS));
    }

    public static double nsplitPoint(long struct) {
        return MemoryUtil.memGetDouble((long)(struct + (long)SPLITPOINT));
    }

    public static ZDICTParams nzParams(long struct) {
        return ZDICTParams.create(struct + (long)ZPARAMS);
    }

    public static void nk(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)K), (int)value);
    }

    public static void nd(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)D), (int)value);
    }

    public static void nsteps(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)STEPS), (int)value);
    }

    public static void nnbThreads(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)NBTHREADS), (int)value);
    }

    public static void nsplitPoint(long struct, double value) {
        MemoryUtil.memPutDouble((long)(struct + (long)SPLITPOINT), (double)value);
    }

    public static void nzParams(long struct, ZDICTParams value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)ZPARAMS), (long)ZDICTParams.SIZEOF);
    }

    static {
        Struct.Layout layout = ZDICTCoverParams.__struct((Struct.Member[])new Struct.Member[]{ZDICTCoverParams.__member((int)4), ZDICTCoverParams.__member((int)4), ZDICTCoverParams.__member((int)4), ZDICTCoverParams.__member((int)4), ZDICTCoverParams.__member((int)8), ZDICTCoverParams.__member((int)ZDICTParams.SIZEOF, (int)ZDICTParams.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        K = layout.offsetof(0);
        D = layout.offsetof(1);
        STEPS = layout.offsetof(2);
        NBTHREADS = layout.offsetof(3);
        SPLITPOINT = layout.offsetof(4);
        ZPARAMS = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<ZDICTCoverParams, Buffer>
    implements NativeResource {
        private static final ZDICTCoverParams ELEMENT_FACTORY = ZDICTCoverParams.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected ZDICTCoverParams getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="unsigned")
        public int k() {
            return ZDICTCoverParams.nk(this.address());
        }

        @NativeType(value="unsigned")
        public int d() {
            return ZDICTCoverParams.nd(this.address());
        }

        @NativeType(value="unsigned")
        public int steps() {
            return ZDICTCoverParams.nsteps(this.address());
        }

        @NativeType(value="unsigned")
        public int nbThreads() {
            return ZDICTCoverParams.nnbThreads(this.address());
        }

        public double splitPoint() {
            return ZDICTCoverParams.nsplitPoint(this.address());
        }

        @NativeType(value="ZDICT_params_t")
        public ZDICTParams zParams() {
            return ZDICTCoverParams.nzParams(this.address());
        }

        public Buffer k(@NativeType(value="unsigned") int value) {
            ZDICTCoverParams.nk(this.address(), value);
            return this;
        }

        public Buffer d(@NativeType(value="unsigned") int value) {
            ZDICTCoverParams.nd(this.address(), value);
            return this;
        }

        public Buffer steps(@NativeType(value="unsigned") int value) {
            ZDICTCoverParams.nsteps(this.address(), value);
            return this;
        }

        public Buffer nbThreads(@NativeType(value="unsigned") int value) {
            ZDICTCoverParams.nnbThreads(this.address(), value);
            return this;
        }

        public Buffer splitPoint(double value) {
            ZDICTCoverParams.nsplitPoint(this.address(), value);
            return this;
        }

        public Buffer zParams(@NativeType(value="ZDICT_params_t") ZDICTParams value) {
            ZDICTCoverParams.nzParams(this.address(), value);
            return this;
        }

        public Buffer zParams(Consumer<ZDICTParams> consumer) {
            consumer.accept(this.zParams());
            return this;
        }
    }
}

