/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.spng;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct spng_unknown_chunk")
public class spng_unknown_chunk
extends Struct<spng_unknown_chunk>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int LENGTH;
    public static final int DATA;
    public static final int LOCATION;

    protected spng_unknown_chunk(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected spng_unknown_chunk create(long address, @Nullable ByteBuffer container) {
        return new spng_unknown_chunk(address, container);
    }

    public spng_unknown_chunk(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), spng_unknown_chunk.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint8_t[4]")
    public ByteBuffer type() {
        return spng_unknown_chunk.ntype(this.address());
    }

    @NativeType(value="uint8_t")
    public byte type(int index) {
        return spng_unknown_chunk.ntype(this.address(), index);
    }

    @NativeType(value="size_t")
    public long length() {
        return spng_unknown_chunk.nlength(this.address());
    }

    @NativeType(value="void *")
    public ByteBuffer data() {
        return spng_unknown_chunk.ndata(this.address());
    }

    @NativeType(value="spng_location")
    public int location() {
        return spng_unknown_chunk.nlocation(this.address());
    }

    public spng_unknown_chunk type(@NativeType(value="uint8_t[4]") ByteBuffer value) {
        spng_unknown_chunk.ntype(this.address(), value);
        return this;
    }

    public spng_unknown_chunk type(int index, @NativeType(value="uint8_t") byte value) {
        spng_unknown_chunk.ntype(this.address(), index, value);
        return this;
    }

    public spng_unknown_chunk data(@NativeType(value="void *") ByteBuffer value) {
        spng_unknown_chunk.ndata(this.address(), value);
        return this;
    }

    public spng_unknown_chunk location(@NativeType(value="spng_location") int value) {
        spng_unknown_chunk.nlocation(this.address(), value);
        return this;
    }

    public spng_unknown_chunk set(ByteBuffer type, ByteBuffer data, int location) {
        this.type(type);
        this.data(data);
        this.location(location);
        return this;
    }

    public spng_unknown_chunk set(spng_unknown_chunk src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static spng_unknown_chunk malloc() {
        return new spng_unknown_chunk(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static spng_unknown_chunk calloc() {
        return new spng_unknown_chunk(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static spng_unknown_chunk create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new spng_unknown_chunk(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static spng_unknown_chunk create(long address) {
        return new spng_unknown_chunk(address, null);
    }

    public static @Nullable spng_unknown_chunk createSafe(long address) {
        return address == 0L ? null : new spng_unknown_chunk(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)spng_unknown_chunk.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = spng_unknown_chunk.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static spng_unknown_chunk malloc(MemoryStack stack) {
        return new spng_unknown_chunk(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static spng_unknown_chunk calloc(MemoryStack stack) {
        return new spng_unknown_chunk(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ByteBuffer ntype(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)TYPE), (int)4);
    }

    public static byte ntype(long struct, int index) {
        return MemoryUtil.memGetByte((long)(struct + (long)TYPE + Checks.check((int)index, (int)4) * 1L));
    }

    public static long nlength(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)LENGTH));
    }

    public static ByteBuffer ndata(long struct) {
        return MemoryUtil.memByteBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)DATA)), (int)((int)spng_unknown_chunk.nlength(struct)));
    }

    public static int nlocation(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)LOCATION));
    }

    public static void ntype(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)4);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((ByteBuffer)value), (long)(struct + (long)TYPE), (long)(value.remaining() * 1));
    }

    public static void ntype(long struct, int index, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)TYPE + Checks.check((int)index, (int)4) * 1L), (byte)value);
    }

    public static void nlength(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)LENGTH), (long)value);
    }

    public static void ndata(long struct, ByteBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)DATA), (long)MemoryUtil.memAddress((ByteBuffer)value));
        spng_unknown_chunk.nlength(struct, value.remaining());
    }

    public static void nlocation(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)LOCATION), (int)value);
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)DATA)));
    }

    static {
        Struct.Layout layout = spng_unknown_chunk.__struct((Struct.Member[])new Struct.Member[]{spng_unknown_chunk.__array((int)1, (int)4), spng_unknown_chunk.__member((int)POINTER_SIZE), spng_unknown_chunk.__member((int)POINTER_SIZE), spng_unknown_chunk.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        LENGTH = layout.offsetof(1);
        DATA = layout.offsetof(2);
        LOCATION = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<spng_unknown_chunk, Buffer>
    implements NativeResource {
        private static final spng_unknown_chunk ELEMENT_FACTORY = spng_unknown_chunk.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected spng_unknown_chunk getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint8_t[4]")
        public ByteBuffer type() {
            return spng_unknown_chunk.ntype(this.address());
        }

        @NativeType(value="uint8_t")
        public byte type(int index) {
            return spng_unknown_chunk.ntype(this.address(), index);
        }

        @NativeType(value="size_t")
        public long length() {
            return spng_unknown_chunk.nlength(this.address());
        }

        @NativeType(value="void *")
        public ByteBuffer data() {
            return spng_unknown_chunk.ndata(this.address());
        }

        @NativeType(value="spng_location")
        public int location() {
            return spng_unknown_chunk.nlocation(this.address());
        }

        public Buffer type(@NativeType(value="uint8_t[4]") ByteBuffer value) {
            spng_unknown_chunk.ntype(this.address(), value);
            return this;
        }

        public Buffer type(int index, @NativeType(value="uint8_t") byte value) {
            spng_unknown_chunk.ntype(this.address(), index, value);
            return this;
        }

        public Buffer data(@NativeType(value="void *") ByteBuffer value) {
            spng_unknown_chunk.ndata(this.address(), value);
            return this;
        }

        public Buffer location(@NativeType(value="spng_location") int value) {
            spng_unknown_chunk.nlocation(this.address(), value);
            return this;
        }
    }
}

