/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.spng;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct spng_trns")
public class spng_trns
extends Struct<spng_trns>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int GRAY;
    public static final int RED;
    public static final int GREEN;
    public static final int BLUE;
    public static final int N_TYPE3_ENTRIES;
    public static final int TYPE3_ALPHA;

    protected spng_trns(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected spng_trns create(long address, @Nullable ByteBuffer container) {
        return new spng_trns(address, container);
    }

    public spng_trns(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), spng_trns.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint16_t")
    public short gray() {
        return spng_trns.ngray(this.address());
    }

    @NativeType(value="uint16_t")
    public short red() {
        return spng_trns.nred(this.address());
    }

    @NativeType(value="uint16_t")
    public short green() {
        return spng_trns.ngreen(this.address());
    }

    @NativeType(value="uint16_t")
    public short blue() {
        return spng_trns.nblue(this.address());
    }

    @NativeType(value="uint32_t")
    public int n_type3_entries() {
        return spng_trns.nn_type3_entries(this.address());
    }

    @NativeType(value="uint8_t[256]")
    public ByteBuffer type3_alpha() {
        return spng_trns.ntype3_alpha(this.address());
    }

    @NativeType(value="uint8_t")
    public byte type3_alpha(int index) {
        return spng_trns.ntype3_alpha(this.address(), index);
    }

    public spng_trns gray(@NativeType(value="uint16_t") short value) {
        spng_trns.ngray(this.address(), value);
        return this;
    }

    public spng_trns red(@NativeType(value="uint16_t") short value) {
        spng_trns.nred(this.address(), value);
        return this;
    }

    public spng_trns green(@NativeType(value="uint16_t") short value) {
        spng_trns.ngreen(this.address(), value);
        return this;
    }

    public spng_trns blue(@NativeType(value="uint16_t") short value) {
        spng_trns.nblue(this.address(), value);
        return this;
    }

    public spng_trns type3_alpha(@NativeType(value="uint8_t[256]") ByteBuffer value) {
        spng_trns.ntype3_alpha(this.address(), value);
        return this;
    }

    public spng_trns type3_alpha(int index, @NativeType(value="uint8_t") byte value) {
        spng_trns.ntype3_alpha(this.address(), index, value);
        return this;
    }

    public spng_trns set(short gray, short red, short green, short blue, ByteBuffer type3_alpha) {
        this.gray(gray);
        this.red(red);
        this.green(green);
        this.blue(blue);
        this.type3_alpha(type3_alpha);
        return this;
    }

    public spng_trns set(spng_trns src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static spng_trns malloc() {
        return new spng_trns(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static spng_trns calloc() {
        return new spng_trns(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static spng_trns create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new spng_trns(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static spng_trns create(long address) {
        return new spng_trns(address, null);
    }

    public static @Nullable spng_trns createSafe(long address) {
        return address == 0L ? null : new spng_trns(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)spng_trns.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = spng_trns.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static spng_trns malloc(MemoryStack stack) {
        return new spng_trns(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static spng_trns calloc(MemoryStack stack) {
        return new spng_trns(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static short ngray(long struct) {
        return MemoryUtil.memGetShort((long)(struct + (long)GRAY));
    }

    public static short nred(long struct) {
        return MemoryUtil.memGetShort((long)(struct + (long)RED));
    }

    public static short ngreen(long struct) {
        return MemoryUtil.memGetShort((long)(struct + (long)GREEN));
    }

    public static short nblue(long struct) {
        return MemoryUtil.memGetShort((long)(struct + (long)BLUE));
    }

    public static int nn_type3_entries(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)N_TYPE3_ENTRIES));
    }

    public static ByteBuffer ntype3_alpha(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)TYPE3_ALPHA), (int)spng_trns.nn_type3_entries(struct));
    }

    public static byte ntype3_alpha(long struct, int index) {
        return MemoryUtil.memGetByte((long)(struct + (long)TYPE3_ALPHA + Checks.check((int)index, (int)256) * 1L));
    }

    public static void ngray(long struct, short value) {
        MemoryUtil.memPutShort((long)(struct + (long)GRAY), (short)value);
    }

    public static void nred(long struct, short value) {
        MemoryUtil.memPutShort((long)(struct + (long)RED), (short)value);
    }

    public static void ngreen(long struct, short value) {
        MemoryUtil.memPutShort((long)(struct + (long)GREEN), (short)value);
    }

    public static void nblue(long struct, short value) {
        MemoryUtil.memPutShort((long)(struct + (long)BLUE), (short)value);
    }

    public static void nn_type3_entries(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)N_TYPE3_ENTRIES), (int)value);
    }

    public static void ntype3_alpha(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)256);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((ByteBuffer)value), (long)(struct + (long)TYPE3_ALPHA), (long)(value.remaining() * 1));
        spng_trns.nn_type3_entries(struct, value.remaining());
    }

    public static void ntype3_alpha(long struct, int index, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)TYPE3_ALPHA + Checks.check((int)index, (int)256) * 1L), (byte)value);
    }

    static {
        Struct.Layout layout = spng_trns.__struct((Struct.Member[])new Struct.Member[]{spng_trns.__member((int)2), spng_trns.__member((int)2), spng_trns.__member((int)2), spng_trns.__member((int)2), spng_trns.__member((int)4), spng_trns.__array((int)1, (int)256)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        GRAY = layout.offsetof(0);
        RED = layout.offsetof(1);
        GREEN = layout.offsetof(2);
        BLUE = layout.offsetof(3);
        N_TYPE3_ENTRIES = layout.offsetof(4);
        TYPE3_ALPHA = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<spng_trns, Buffer>
    implements NativeResource {
        private static final spng_trns ELEMENT_FACTORY = spng_trns.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected spng_trns getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint16_t")
        public short gray() {
            return spng_trns.ngray(this.address());
        }

        @NativeType(value="uint16_t")
        public short red() {
            return spng_trns.nred(this.address());
        }

        @NativeType(value="uint16_t")
        public short green() {
            return spng_trns.ngreen(this.address());
        }

        @NativeType(value="uint16_t")
        public short blue() {
            return spng_trns.nblue(this.address());
        }

        @NativeType(value="uint32_t")
        public int n_type3_entries() {
            return spng_trns.nn_type3_entries(this.address());
        }

        @NativeType(value="uint8_t[256]")
        public ByteBuffer type3_alpha() {
            return spng_trns.ntype3_alpha(this.address());
        }

        @NativeType(value="uint8_t")
        public byte type3_alpha(int index) {
            return spng_trns.ntype3_alpha(this.address(), index);
        }

        public Buffer gray(@NativeType(value="uint16_t") short value) {
            spng_trns.ngray(this.address(), value);
            return this;
        }

        public Buffer red(@NativeType(value="uint16_t") short value) {
            spng_trns.nred(this.address(), value);
            return this;
        }

        public Buffer green(@NativeType(value="uint16_t") short value) {
            spng_trns.ngreen(this.address(), value);
            return this;
        }

        public Buffer blue(@NativeType(value="uint16_t") short value) {
            spng_trns.nblue(this.address(), value);
            return this;
        }

        public Buffer type3_alpha(@NativeType(value="uint8_t[256]") ByteBuffer value) {
            spng_trns.ntype3_alpha(this.address(), value);
            return this;
        }

        public Buffer type3_alpha(int index, @NativeType(value="uint8_t") byte value) {
            spng_trns.ntype3_alpha(this.address(), index, value);
            return this;
        }
    }
}

