/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.spng;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct spng_text")
public class spng_text
extends Struct<spng_text>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int KEYWORD;
    public static final int TYPE;
    public static final int LENGTH;
    public static final int TEXT;
    public static final int COMPRESSION_FLAG;
    public static final int COMPRESSION_METHOD;
    public static final int LANGUAGE_TAG;
    public static final int TRANSLATED_KEYWORD;

    protected spng_text(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected spng_text create(long address, @Nullable ByteBuffer container) {
        return new spng_text(address, container);
    }

    public spng_text(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), spng_text.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="char[80]")
    public ByteBuffer keyword() {
        return spng_text.nkeyword(this.address());
    }

    @NativeType(value="char[80]")
    public String keywordString() {
        return spng_text.nkeywordString(this.address());
    }

    public int type() {
        return spng_text.ntype(this.address());
    }

    @NativeType(value="size_t")
    public long length() {
        return spng_text.nlength(this.address());
    }

    @NativeType(value="char *")
    public ByteBuffer text() {
        return spng_text.ntext(this.address());
    }

    @NativeType(value="char *")
    public String textString() {
        return spng_text.ntextString(this.address());
    }

    @NativeType(value="uint8_t")
    public byte compression_flag() {
        return spng_text.ncompression_flag(this.address());
    }

    @NativeType(value="uint8_t")
    public byte compression_method() {
        return spng_text.ncompression_method(this.address());
    }

    @NativeType(value="char *")
    public ByteBuffer language_tag() {
        return spng_text.nlanguage_tag(this.address());
    }

    @NativeType(value="char *")
    public String language_tagString() {
        return spng_text.nlanguage_tagString(this.address());
    }

    @NativeType(value="char *")
    public ByteBuffer translated_keyword() {
        return spng_text.ntranslated_keyword(this.address());
    }

    @NativeType(value="char *")
    public String translated_keywordString() {
        return spng_text.ntranslated_keywordString(this.address());
    }

    public spng_text keyword(@NativeType(value="char[80]") ByteBuffer value) {
        spng_text.nkeyword(this.address(), value);
        return this;
    }

    public spng_text type(int value) {
        spng_text.ntype(this.address(), value);
        return this;
    }

    public spng_text text(@NativeType(value="char *") ByteBuffer value) {
        spng_text.ntext(this.address(), value);
        return this;
    }

    public spng_text compression_flag(@NativeType(value="uint8_t") byte value) {
        spng_text.ncompression_flag(this.address(), value);
        return this;
    }

    public spng_text compression_method(@NativeType(value="uint8_t") byte value) {
        spng_text.ncompression_method(this.address(), value);
        return this;
    }

    public spng_text language_tag(@NativeType(value="char *") ByteBuffer value) {
        spng_text.nlanguage_tag(this.address(), value);
        return this;
    }

    public spng_text translated_keyword(@NativeType(value="char *") ByteBuffer value) {
        spng_text.ntranslated_keyword(this.address(), value);
        return this;
    }

    public spng_text set(ByteBuffer keyword, int type, ByteBuffer text, byte compression_flag, byte compression_method, ByteBuffer language_tag, ByteBuffer translated_keyword) {
        this.keyword(keyword);
        this.type(type);
        this.text(text);
        this.compression_flag(compression_flag);
        this.compression_method(compression_method);
        this.language_tag(language_tag);
        this.translated_keyword(translated_keyword);
        return this;
    }

    public spng_text set(spng_text src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static spng_text malloc() {
        return new spng_text(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static spng_text calloc() {
        return new spng_text(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static spng_text create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new spng_text(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static spng_text create(long address) {
        return new spng_text(address, null);
    }

    public static @Nullable spng_text createSafe(long address) {
        return address == 0L ? null : new spng_text(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)spng_text.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = spng_text.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static spng_text malloc(MemoryStack stack) {
        return new spng_text(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static spng_text calloc(MemoryStack stack) {
        return new spng_text(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ByteBuffer nkeyword(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)KEYWORD), (int)80);
    }

    public static String nkeywordString(long struct) {
        return MemoryUtil.memASCII((long)(struct + (long)KEYWORD));
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)TYPE));
    }

    public static long nlength(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)LENGTH));
    }

    public static ByteBuffer ntext(long struct) {
        return MemoryUtil.memByteBufferNT1((long)MemoryUtil.memGetAddress((long)(struct + (long)TEXT)));
    }

    public static String ntextString(long struct) {
        return MemoryUtil.memASCII((long)MemoryUtil.memGetAddress((long)(struct + (long)TEXT)));
    }

    public static byte ncompression_flag(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)COMPRESSION_FLAG));
    }

    public static byte ncompression_method(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)COMPRESSION_METHOD));
    }

    public static ByteBuffer nlanguage_tag(long struct) {
        return MemoryUtil.memByteBufferNT1((long)MemoryUtil.memGetAddress((long)(struct + (long)LANGUAGE_TAG)));
    }

    public static String nlanguage_tagString(long struct) {
        return MemoryUtil.memASCII((long)MemoryUtil.memGetAddress((long)(struct + (long)LANGUAGE_TAG)));
    }

    public static ByteBuffer ntranslated_keyword(long struct) {
        return MemoryUtil.memByteBufferNT1((long)MemoryUtil.memGetAddress((long)(struct + (long)TRANSLATED_KEYWORD)));
    }

    public static String ntranslated_keywordString(long struct) {
        return MemoryUtil.memASCII((long)MemoryUtil.memGetAddress((long)(struct + (long)TRANSLATED_KEYWORD)));
    }

    public static void nkeyword(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)value);
            Checks.checkGT((java.nio.Buffer)value, (int)80);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((ByteBuffer)value), (long)(struct + (long)KEYWORD), (long)value.remaining());
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)TYPE), (int)value);
    }

    public static void nlength(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)LENGTH), (long)value);
    }

    public static void ntext(long struct, ByteBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)TEXT), (long)MemoryUtil.memAddress((ByteBuffer)value));
        spng_text.nlength(struct, value.remaining());
    }

    public static void ncompression_flag(long struct, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)COMPRESSION_FLAG), (byte)value);
    }

    public static void ncompression_method(long struct, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)COMPRESSION_METHOD), (byte)value);
    }

    public static void nlanguage_tag(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)value);
        }
        MemoryUtil.memPutAddress((long)(struct + (long)LANGUAGE_TAG), (long)MemoryUtil.memAddress((ByteBuffer)value));
    }

    public static void ntranslated_keyword(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)value);
        }
        MemoryUtil.memPutAddress((long)(struct + (long)TRANSLATED_KEYWORD), (long)MemoryUtil.memAddress((ByteBuffer)value));
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)TEXT)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)LANGUAGE_TAG)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)TRANSLATED_KEYWORD)));
    }

    static {
        Struct.Layout layout = spng_text.__struct((Struct.Member[])new Struct.Member[]{spng_text.__array((int)1, (int)80), spng_text.__member((int)4), spng_text.__member((int)POINTER_SIZE), spng_text.__member((int)POINTER_SIZE), spng_text.__member((int)1), spng_text.__member((int)1), spng_text.__member((int)POINTER_SIZE), spng_text.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        KEYWORD = layout.offsetof(0);
        TYPE = layout.offsetof(1);
        LENGTH = layout.offsetof(2);
        TEXT = layout.offsetof(3);
        COMPRESSION_FLAG = layout.offsetof(4);
        COMPRESSION_METHOD = layout.offsetof(5);
        LANGUAGE_TAG = layout.offsetof(6);
        TRANSLATED_KEYWORD = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<spng_text, Buffer>
    implements NativeResource {
        private static final spng_text ELEMENT_FACTORY = spng_text.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected spng_text getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="char[80]")
        public ByteBuffer keyword() {
            return spng_text.nkeyword(this.address());
        }

        @NativeType(value="char[80]")
        public String keywordString() {
            return spng_text.nkeywordString(this.address());
        }

        public int type() {
            return spng_text.ntype(this.address());
        }

        @NativeType(value="size_t")
        public long length() {
            return spng_text.nlength(this.address());
        }

        @NativeType(value="char *")
        public ByteBuffer text() {
            return spng_text.ntext(this.address());
        }

        @NativeType(value="char *")
        public String textString() {
            return spng_text.ntextString(this.address());
        }

        @NativeType(value="uint8_t")
        public byte compression_flag() {
            return spng_text.ncompression_flag(this.address());
        }

        @NativeType(value="uint8_t")
        public byte compression_method() {
            return spng_text.ncompression_method(this.address());
        }

        @NativeType(value="char *")
        public ByteBuffer language_tag() {
            return spng_text.nlanguage_tag(this.address());
        }

        @NativeType(value="char *")
        public String language_tagString() {
            return spng_text.nlanguage_tagString(this.address());
        }

        @NativeType(value="char *")
        public ByteBuffer translated_keyword() {
            return spng_text.ntranslated_keyword(this.address());
        }

        @NativeType(value="char *")
        public String translated_keywordString() {
            return spng_text.ntranslated_keywordString(this.address());
        }

        public Buffer keyword(@NativeType(value="char[80]") ByteBuffer value) {
            spng_text.nkeyword(this.address(), value);
            return this;
        }

        public Buffer type(int value) {
            spng_text.ntype(this.address(), value);
            return this;
        }

        public Buffer text(@NativeType(value="char *") ByteBuffer value) {
            spng_text.ntext(this.address(), value);
            return this;
        }

        public Buffer compression_flag(@NativeType(value="uint8_t") byte value) {
            spng_text.ncompression_flag(this.address(), value);
            return this;
        }

        public Buffer compression_method(@NativeType(value="uint8_t") byte value) {
            spng_text.ncompression_method(this.address(), value);
            return this;
        }

        public Buffer language_tag(@NativeType(value="char *") ByteBuffer value) {
            spng_text.nlanguage_tag(this.address(), value);
            return this;
        }

        public Buffer translated_keyword(@NativeType(value="char *") ByteBuffer value) {
            spng_text.ntranslated_keyword(this.address(), value);
            return this;
        }
    }
}

